/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.templates.textmanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.epic.perleditor.templates.textmanipulation.MultiTextEdit;
import org.epic.perleditor.templates.textmanipulation.TextBuffer;
import org.epic.perleditor.templates.textmanipulation.TextEdit;
import org.epic.perleditor.templates.textmanipulation.TextEditNode;
import org.epic.perleditor.templates.textmanipulation.TextEditNodeComparator;
import org.epic.perleditor.templates.textmanipulation.UndoMemento;

public class TextBufferEditor {
    private TextBuffer fBuffer;
    private List fEdits;
    private TextEditNode.RootNode fRootNode;
    private int fNumberOfNodes;
    private int fConnectCount;
    private int fMode;
    static final int UNDEFINED = 0;
    static final int REDO = 1;
    static final int UNDO = 2;

    public TextBufferEditor(TextBuffer buffer) {
        this.fBuffer = buffer;
        this.fEdits = new ArrayList();
    }

    public TextBuffer getTextBuffer() {
        return this.fBuffer;
    }

    public void add(TextEdit edit) throws CoreException {
        this.internalAdd(edit);
        this.fMode = 1;
    }

    public void add(MultiTextEdit edit) throws CoreException {
        edit.connect(this);
        this.fMode = 1;
    }

    public void add(UndoMemento undo) throws CoreException {
        List list = undo.fEdits;
        int i = list.size() - 1;
        while (i >= 0) {
            this.internalAdd((TextEdit)list.get(i));
            --i;
        }
        this.fMode = undo.fMode;
    }

    public boolean canPerformEdits() {
        if (this.fRootNode != null) {
            return true;
        }
        this.fRootNode = this.buildTree();
        if (this.fRootNode == null) {
            return false;
        }
        if (this.fRootNode.validate(this.fBuffer.getLength())) {
            return true;
        }
        this.fRootNode = null;
        return false;
    }

    public void clear() {
        this.fRootNode = null;
        this.fMode = 0;
        this.fEdits.clear();
    }

    public UndoMemento performEdits(IProgressMonitor pm) throws CoreException {
        int size;
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        if ((size = this.fEdits.size()) == 0) {
            return new UndoMemento(this.fMode == 2 ? 1 : 2);
        }
        if (this.fRootNode == null) {
            this.fRootNode = this.buildTree();
            if (this.fRootNode != null) {
                this.fRootNode.validate(this.fBuffer.getLength());
            }
        }
        try {
            pm.beginTask("", this.fNumberOfNodes + 10);
            UndoMemento undo = null;
            if (this.fMode == 1) {
                undo = this.fRootNode.performDo(this.fBuffer, pm);
                this.fRootNode.performedDo();
            } else {
                undo = this.fRootNode.performUndo(this.fBuffer, pm);
                this.fRootNode.performedUndo();
            }
            pm.worked(10);
            UndoMemento undoMemento = undo;
            return undoMemento;
        }
        finally {
            pm.done();
            this.clear();
        }
    }

    private TextEditNode.RootNode buildTree() {
        TextEditNode[] nodes = new TextEditNode[this.fEdits.size()];
        int i = this.fEdits.size() - 1;
        while (i >= 0) {
            nodes[i] = TextEditNode.create((TextEdit)this.fEdits.get(i));
            --i;
        }
        this.fNumberOfNodes = nodes.length;
        Arrays.sort(nodes, new TextEditNodeComparator());
        TextEditNode.RootNode root = new TextEditNode.RootNode(this.fBuffer.getLength());
        int i2 = 0;
        while (i2 < nodes.length) {
            root.add(nodes[i2]);
            ++i2;
        }
        return root;
    }

    private void internalAdd(TextEdit edit) throws CoreException {
        edit.index = this.fEdits.size();
        edit.isSynthetic = this.fConnectCount > 0;
        try {
            ++this.fConnectCount;
            edit.connect(this);
        }
        finally {
            --this.fConnectCount;
        }
        this.fEdits.add(edit);
    }
}

