/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.console;

import java.io.File;
import java.io.IOException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.client.IConsoleListener;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.console.ConsoleDocument;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;

public class SVNOutputConsole
extends IOConsole
implements IConsoleListener,
IPropertyChangeListener {
    public static final String SVN_CONSOLE_TYPE = "SVN";
    private Color commandColor;
    private Color messageColor;
    private Color errorColor;
    private IOConsoleOutputStream commandStream;
    private IOConsoleOutputStream messageStream;
    private IOConsoleOutputStream errorStream;
    private boolean showOnError;
    private boolean showOnMessage = SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_console_show_on_message");
    private ConsoleDocument document;
    private boolean visible = false;
    private boolean initialized = false;

    public SVNOutputConsole() {
        super(SVN_CONSOLE_TYPE, SVN_CONSOLE_TYPE, SVNUIPlugin.getPlugin().getImageDescriptor("cview16/console_view.gif"));
        this.showOnError = SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_console_show_on_error");
        this.document = new ConsoleDocument();
        SVNProviderPlugin.getPlugin().setConsoleListener((IConsoleListener)this);
        SVNUIPlugin.getPlugin().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void init() {
        super.init();
        this.initLimitOutput();
        SVNUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)SVNOutputConsole.this);
                SVNOutputConsole.this.initializeStreams();
                SVNOutputConsole.this.dump();
            }
        });
    }

    private void initLimitOutput() {
        IPreferenceStore store = SVNUIPlugin.getPlugin().getPreferenceStore();
        if (store.getBoolean("pref_console_limit_output")) {
            this.setWaterMarks(1000, store.getInt("pref_console_high_water_mark"));
        } else {
            this.setWaterMarks(-1, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeStreams() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            if (!this.initialized) {
                this.commandStream = this.newOutputStream();
                this.errorStream = this.newOutputStream();
                this.messageStream = this.newOutputStream();
                this.commandColor = this.createColor(SVNUIPlugin.getStandardDisplay(), "pref_console_command_color");
                this.commandStream.setColor(this.commandColor);
                this.messageColor = this.createColor(SVNUIPlugin.getStandardDisplay(), "pref_console_message_color");
                this.messageStream.setColor(this.messageColor);
                this.errorColor = this.createColor(SVNUIPlugin.getStandardDisplay(), "pref_console_error_color");
                this.errorStream.setColor(this.errorColor);
                this.setFont(JFaceResources.getFontRegistry().get("pref_console_font"));
                this.initialized = true;
            }
        }
    }

    public String getHelpContextId() {
        return "org.tigris.subversion.subclipse.ui.console_view_context";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            this.visible = true;
            ConsoleDocument.ConsoleLine[] lines = this.document.getLines();
            int i = 0;
            while (i < lines.length) {
                ConsoleDocument.ConsoleLine line = lines[i];
                this.appendLine(line.type, line.line);
                ++i;
            }
            this.document.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendLine(int type, String line) {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            if (this.visible) {
                try {
                    switch (type) {
                        case 0: {
                            this.commandStream.write(line);
                            this.commandStream.write(10);
                            break;
                        }
                        case 1: {
                            this.messageStream.write("  " + line);
                            this.messageStream.write(10);
                            break;
                        }
                        case 2: {
                            this.errorStream.write("  " + line);
                            this.errorStream.write(10);
                        }
                    }
                }
                catch (IOException e) {
                    SVNUIPlugin.log(0, e.getMessage(), e);
                }
            } else {
                this.document.appendConsoleLine(type, line);
            }
        }
    }

    private void bringConsoleToFront() {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        if (!this.visible) {
            manager.addConsoles(new IConsole[]{this});
        }
        manager.showConsoleView((IConsole)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            this.visible = false;
            JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        }
    }

    public void shutdown() {
        super.dispose();
        if (this.commandColor != null) {
            this.commandColor.dispose();
        }
        if (this.messageColor != null) {
            this.messageColor.dispose();
        }
        if (this.errorColor != null) {
            this.errorColor.dispose();
        }
        SVNUIPlugin.getPlugin().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object value;
        String property = event.getProperty();
        if (this.visible) {
            Color newColor;
            if (property.equals("pref_console_command_color")) {
                newColor = this.createColor(SVNUIPlugin.getStandardDisplay(), "pref_console_command_color");
                this.commandStream.setColor(newColor);
                this.commandColor.dispose();
                this.commandColor = newColor;
            } else if (property.equals("pref_console_message_color")) {
                newColor = this.createColor(SVNUIPlugin.getStandardDisplay(), "pref_console_message_color");
                this.messageStream.setColor(newColor);
                this.messageColor.dispose();
                this.messageColor = newColor;
            } else if (property.equals("pref_console_error_color")) {
                newColor = this.createColor(SVNUIPlugin.getStandardDisplay(), "pref_console_error_color");
                this.errorStream.setColor(newColor);
                this.errorColor.dispose();
                this.errorColor = newColor;
            } else if (property.equals("pref_console_font")) {
                this.setFont(JFaceResources.getFontRegistry().get("pref_console_font"));
            } else if (property.equals("pref_console_limit_output")) {
                this.initLimitOutput();
            }
        }
        if (property.equals("pref_console_show_on_message")) {
            value = event.getNewValue();
            this.showOnMessage = value instanceof String ? Boolean.getBoolean((String)event.getNewValue()) : (Boolean)value;
        }
        if (property.equals("pref_console_show_on_error")) {
            value = event.getNewValue();
            this.showOnError = value instanceof String ? Boolean.getBoolean((String)event.getNewValue()) : (Boolean)value;
        }
    }

    private Color createColor(Display display, String preference) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)SVNUIPlugin.getPlugin().getPreferenceStore(), (String)preference);
        return new Color((Device)display, rgb);
    }

    public void logCommandLine(String commandLine) {
        if (this.showOnMessage) {
            this.bringConsoleToFront();
        }
        this.appendLine(4, Policy.bind("Console.preExecutionDelimiter"));
        this.appendLine(0, commandLine);
    }

    public void logMessage(String message) {
        if (this.showOnMessage) {
            this.bringConsoleToFront();
        }
        this.appendLine(1, "  " + message);
    }

    public void logRevision(long revision, String path) {
    }

    public void logCompleted(String message) {
        if (this.showOnMessage) {
            this.bringConsoleToFront();
        }
        this.appendLine(1, "  " + message);
    }

    public void logError(String message) {
        if (this.showOnMessage || this.showOnError) {
            this.bringConsoleToFront();
        }
        this.appendLine(2, "  " + message);
    }

    public void onNotify(File path, SVNNodeKind kind) {
    }

    public void setCommand(int command) {
    }

    class MyLifecycle
    implements org.eclipse.ui.console.IConsoleListener {
        MyLifecycle() {
        }

        public void consolesAdded(IConsole[] consoles) {
            int i = 0;
            while (i < consoles.length) {
                IConsole console = consoles[i];
                if (console == SVNOutputConsole.this) {
                    SVNOutputConsole.this.init();
                }
                ++i;
            }
        }

        public void consolesRemoved(IConsole[] consoles) {
            int i = 0;
            while (i < consoles.length) {
                IConsole console = consoles[i];
                if (console == SVNOutputConsole.this) {
                    ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener((org.eclipse.ui.console.IConsoleListener)this);
                    SVNOutputConsole.this.dispose();
                }
                ++i;
            }
        }
    }
}

