/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.dialogs;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialogPage;

public class SvnWizardMarkResolvedPage
extends SvnWizardDialogPage {
    private IResource[] resources;
    private Button markResolvedButton;
    private Button chooseUserVersionButton;
    private Button chooseUserVersionForConflictsButton;
    private Button chooseIncomingVersionButton;
    private Button chooseIncomingVersionForConflictsButton;
    private Button chooseBaseVersionButton;
    private IDialogSettings settings;
    private int resolution;
    private boolean propertyConflicts;
    private boolean treeConflicts;
    private static final String LAST_CHOICE = "ResolveConflictDialog.lastChoice";

    public SvnWizardMarkResolvedPage(IResource[] resources) {
        super("MarkResolvedDialog", Policy.bind("ResolveOperation.taskName"));
        this.resources = resources;
        this.settings = SVNUIPlugin.getPlugin().getDialogSettings();
    }

    public void createButtonsForButtonBar(Composite parent, SvnWizardDialog wizardDialog) {
    }

    public void createControls(Composite parent) {
        Label propertyLabel2;
        Label propertyLabel1;
        Composite outerContainer = new Composite(parent, 0);
        GridLayout outerLayout = new GridLayout();
        outerLayout.numColumns = 1;
        outerContainer.setLayout((Layout)outerLayout);
        outerContainer.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite(outerContainer, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 64);
        if (this.resources.length == 1) {
            label.setText(Policy.bind("ResolveDialog.file", this.resources[0].getFullPath().makeRelative().toOSString()));
        } else {
            label.setText(Policy.bind("ResolveDialog.multipleFiles"));
        }
        data = new GridData();
        data.widthHint = 500;
        label.setLayoutData((Object)data);
        if (this.treeConflicts) {
            new Label(composite, 0);
            propertyLabel1 = new Label(composite, 64);
            if (this.resources.length > 1) {
                propertyLabel1.setText(Policy.bind("ResolveDialog.treeConflictMultiple"));
            } else {
                propertyLabel1.setText(Policy.bind("ResolveDialog.treeConflict"));
            }
            data = new GridData();
            data.widthHint = 500;
            propertyLabel1.setLayoutData((Object)data);
        } else if (this.propertyConflicts) {
            new Label(composite, 0);
            propertyLabel1 = new Label(composite, 64);
            if (this.resources.length > 1) {
                propertyLabel1.setText(Policy.bind("ResolveDialog.propertyConflictMultiple"));
            } else {
                propertyLabel1.setText(Policy.bind("ResolveDialog.propertyConflict"));
            }
            data = new GridData();
            data.widthHint = 500;
            propertyLabel1.setLayoutData((Object)data);
        }
        new Label(composite, 0);
        Group conflictGroup = new Group(composite, 0);
        conflictGroup.setText(Policy.bind("ResolveDialog.question"));
        GridLayout conflictLayout = new GridLayout();
        conflictLayout.numColumns = 1;
        conflictGroup.setLayout((Layout)conflictLayout);
        data = new GridData(1808);
        conflictGroup.setLayoutData((Object)data);
        this.markResolvedButton = new Button((Composite)conflictGroup, 16);
        this.markResolvedButton.setText(Policy.bind("ResolveDialog.resolved"));
        if (this.treeConflicts) {
            propertyLabel2 = new Label((Composite)conflictGroup, 0);
            propertyLabel2.setText(Policy.bind("ResolveDialog.nonTreeOnly"));
        } else if (this.propertyConflicts) {
            propertyLabel2 = new Label((Composite)conflictGroup, 0);
            propertyLabel2.setText(Policy.bind("ResolveDialog.nonPropertyOnly"));
        }
        this.chooseUserVersionButton = new Button((Composite)conflictGroup, 16);
        this.chooseUserVersionButton.setText(Policy.bind("ResolveDialog.useMine"));
        if (!this.propertyConflicts) {
            this.chooseUserVersionForConflictsButton = new Button((Composite)conflictGroup, 16);
            this.chooseUserVersionForConflictsButton.setText("Resolve conflicts in local file with my changes.");
        }
        this.chooseIncomingVersionButton = new Button((Composite)conflictGroup, 16);
        this.chooseIncomingVersionButton.setText(Policy.bind("ResolveDialog.useTheirs"));
        if (!this.propertyConflicts) {
            this.chooseIncomingVersionForConflictsButton = new Button((Composite)conflictGroup, 16);
            this.chooseIncomingVersionForConflictsButton.setText("Resolve conflicts in local file with changes from incoming file.");
        }
        this.chooseBaseVersionButton = new Button((Composite)conflictGroup, 16);
        this.chooseBaseVersionButton.setText(Policy.bind("ResolveDialog.useBase"));
        int lastChoice = 6;
        try {
            lastChoice = this.settings.getInt(LAST_CHOICE);
        }
        catch (Exception exception) {}
        if (lastChoice == 6) {
            this.markResolvedButton.setSelection(true);
        } else if (lastChoice == 5 && this.chooseUserVersionForConflictsButton != null) {
            this.chooseUserVersionForConflictsButton.setSelection(true);
        } else if (lastChoice == 3 && this.chooseUserVersionButton != null) {
            this.chooseUserVersionButton.setSelection(true);
        } else if (lastChoice == 4 && this.chooseIncomingVersionForConflictsButton != null) {
            this.chooseIncomingVersionForConflictsButton.setSelection(true);
        } else if (lastChoice == 2 && this.chooseIncomingVersionButton != null) {
            this.chooseIncomingVersionButton.setSelection(true);
        } else if (lastChoice == 1 && this.chooseBaseVersionButton != null) {
            this.chooseBaseVersionButton.setSelection(true);
        }
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SvnWizardMarkResolvedPage.this.markResolvedButton.getSelection()) {
                    SvnWizardMarkResolvedPage.this.settings.put(SvnWizardMarkResolvedPage.LAST_CHOICE, 6);
                } else if (SvnWizardMarkResolvedPage.this.chooseUserVersionButton.getSelection()) {
                    SvnWizardMarkResolvedPage.this.settings.put(SvnWizardMarkResolvedPage.LAST_CHOICE, 3);
                } else if (SvnWizardMarkResolvedPage.this.chooseUserVersionForConflictsButton != null && SvnWizardMarkResolvedPage.this.chooseUserVersionForConflictsButton.getSelection()) {
                    SvnWizardMarkResolvedPage.this.settings.put(SvnWizardMarkResolvedPage.LAST_CHOICE, 5);
                } else if (SvnWizardMarkResolvedPage.this.chooseIncomingVersionButton.getSelection()) {
                    SvnWizardMarkResolvedPage.this.settings.put(SvnWizardMarkResolvedPage.LAST_CHOICE, 2);
                } else if (SvnWizardMarkResolvedPage.this.chooseIncomingVersionForConflictsButton != null && SvnWizardMarkResolvedPage.this.chooseIncomingVersionForConflictsButton.getSelection()) {
                    SvnWizardMarkResolvedPage.this.settings.put(SvnWizardMarkResolvedPage.LAST_CHOICE, 4);
                } else if (SvnWizardMarkResolvedPage.this.chooseBaseVersionButton.getSelection()) {
                    SvnWizardMarkResolvedPage.this.settings.put(SvnWizardMarkResolvedPage.LAST_CHOICE, 1);
                }
            }
        };
        this.markResolvedButton.addSelectionListener((SelectionListener)selectionListener);
        this.chooseUserVersionButton.addSelectionListener((SelectionListener)selectionListener);
        if (this.chooseUserVersionForConflictsButton != null) {
            this.chooseUserVersionForConflictsButton.addSelectionListener((SelectionListener)selectionListener);
        }
        this.chooseIncomingVersionButton.addSelectionListener((SelectionListener)selectionListener);
        if (this.chooseIncomingVersionForConflictsButton != null) {
            this.chooseIncomingVersionForConflictsButton.addSelectionListener((SelectionListener)selectionListener);
        }
        this.chooseBaseVersionButton.addSelectionListener((SelectionListener)selectionListener);
        this.setControl((Control)outerContainer);
    }

    public String getWindowTitle() {
        return Policy.bind("ResolveOperation.taskName");
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performFinish() {
        this.resolution = 0;
        if (this.markResolvedButton.getSelection()) {
            this.resolution = 6;
        } else if (this.chooseIncomingVersionButton.getSelection()) {
            this.resolution = 2;
        } else if (this.chooseUserVersionButton.getSelection()) {
            this.resolution = 3;
        } else if (this.chooseBaseVersionButton.getSelection()) {
            this.resolution = 1;
        } else if (this.chooseUserVersionForConflictsButton != null && this.chooseUserVersionForConflictsButton.getSelection()) {
            this.resolution = 5;
        } else if (this.chooseIncomingVersionForConflictsButton != null && this.chooseIncomingVersionForConflictsButton.getSelection()) {
            this.resolution = 4;
        }
        return true;
    }

    public void saveSettings() {
    }

    public void setMessage() {
        if (this.resources.length == 1) {
            this.setMessage(Policy.bind("ResolveDialog.message", this.resources[0].getName()));
        } else {
            this.setMessage(Policy.bind("ResolveDialog.messageMultiple"));
        }
    }

    public int getResolution() {
        return this.resolution;
    }

    public void setPropertyConflicts(boolean propertyConflicts) {
        this.propertyConflicts = propertyConflicts;
    }

    public void setTreeConflicts(boolean treeConflicts) {
        this.treeConflicts = treeConflicts;
    }
}

