/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.fieldeditors;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.sf.feeling.decompiler.jad.CommandLine;
import org.sf.feeling.decompiler.jad.CommandOption;

public abstract class CommandLineOptionEditor {
    private String optionName;
    private String label;
    private PreferencePage preferencePage;
    private Composite parent;

    protected CommandLineOptionEditor() {
    }

    public CommandLineOptionEditor(String optionName, String label, Composite parent) {
        this.init(optionName, label);
        this.createControl(parent);
    }

    public void accept(CommandLine cmdLine) {
        this.doAccept(cmdLine.getOption(this.optionName));
    }

    protected abstract void adjustForNumColumns(int var1);

    protected void createControl(Composite parent) {
        this.parent = parent;
        GridLayout layout = new GridLayout();
        layout.numColumns = this.getNumberOfControls();
        layout.makeColumnsEqualWidth = false;
        parent.setLayout((Layout)layout);
        this.doFillIntoGrid(parent, layout.numColumns);
    }

    protected void doAccept(CommandOption option) {
    }

    protected abstract void doFillIntoGrid(Composite var1, int var2);

    public String getLabel() {
        return this.label;
    }

    public abstract int getNumberOfControls();

    public String getOptionName() {
        return this.optionName;
    }

    public Composite getParent() {
        return this.parent;
    }

    public PreferencePage getPreferencePage() {
        return this.preferencePage;
    }

    protected void init(String optionName, String label) {
        if (optionName == null) {
            throw new IllegalArgumentException("null option name");
        }
        this.optionName = optionName;
        this.label = label != null ? label : optionName;
    }

    public void setPreferencePage(PreferencePage page) {
        this.preferencePage = page;
    }

    public abstract CommandOption toOption();
}

