/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.jad;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jface.preference.IPreferenceStore;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.editor.DecompilerSourceMapper;
import org.sf.feeling.decompiler.jad.IJadDecompiler;
import org.sf.feeling.decompiler.jad.JadDecompiler;
import org.sf.feeling.decompiler.util.DecompilerOutputUtil;
import org.sf.feeling.decompiler.util.SortMemberUtil;

public class JadSourceMapper
extends DecompilerSourceMapper {
    private IJadDecompiler decompiler = new JadDecompiler();

    public JadSourceMapper() {
        super((IPath)new Path("."), "", new HashMap());
    }

    public char[] findSource(IType type, IBinaryType info) {
        boolean useSorter;
        char[] attachedSource;
        IPreferenceStore prefs = JavaDecompilerPlugin.getDefault().getPreferenceStore();
        boolean always = prefs.getBoolean("net.sf.feeling.decompiler.alwaysuse");
        LinkedList<JavaModelException> exceptions = new LinkedList<JavaModelException>();
        IPackageFragment pkgFrag = type.getPackageFragment();
        IPackageFragmentRoot root = (IPackageFragmentRoot)pkgFrag.getParent();
        if (originalSourceMapper.containsKey(root) && !always && (attachedSource = ((SourceMapper)originalSourceMapper.get(root)).findSource(type, info)) != null) {
            this.isAttachedSource = true;
            return attachedSource;
        }
        if (info == null) {
            return null;
        }
        try {
            if (root instanceof PackageFragmentRoot) {
                char[] attachedSource2;
                PackageFragmentRoot pfr = (PackageFragmentRoot)root;
                SourceMapper sourceMapper = pfr.getSourceMapper();
                if (sourceMapper != null && !always && !(sourceMapper instanceof DecompilerSourceMapper) && (attachedSource2 = sourceMapper.findSource(type, info)) != null) {
                    this.isAttachedSource = true;
                    return attachedSource2;
                }
                if (!originalSourceMapper.containsKey(root)) {
                    originalSourceMapper.put(root, sourceMapper);
                }
                if (sourceMapper != this) {
                    pfr.setSourceMapper((SourceMapper)this);
                }
            }
        }
        catch (JavaModelException e) {
            JavaDecompilerPlugin.logError(e, "Could not set source mapper.");
        }
        this.isAttachedSource = false;
        String pkg = type.getPackageFragment().getElementName().replace('.', '/');
        String location = "\tDecompiled from: ";
        String className = new String(info.getName());
        String fullName = new String(info.getFileName());
        className = fullName.substring(fullName.lastIndexOf(className));
        int p = className.lastIndexOf(47);
        className = className.substring(p + 1);
        if (root.isArchive()) {
            String archivePath = this.getArchivePath(root);
            location = String.valueOf(location) + archivePath;
            this.decompiler.decompileFromArchive(archivePath, pkg, className);
        } else {
            try {
                location = String.valueOf(location) + root.getUnderlyingResource().getLocation().toOSString() + "/" + pkg + "/" + className;
                this.decompiler.decompile(root.getUnderlyingResource().getLocation().toOSString(), pkg, className);
            }
            catch (JavaModelException e) {
                exceptions.add(e);
            }
        }
        String code = "/*** Eclipse Class Decompiler plugin, copyright (c) 2012 Chao Chen (cnfree2000@hotmail.com) ***/\r\n" + this.decompiler.getSource();
        boolean showReport = prefs.getBoolean("jd.ide.eclipse.prefs.DisplayMetadata");
        if (!showReport) {
            code = this.removeComment(code);
        }
        boolean showLineNumber = prefs.getBoolean("jd.ide.eclipse.prefs.DisplayLineNumbers");
        boolean align = prefs.getBoolean("jd.ide.eclipse.prefs.Align");
        if (showLineNumber && align) {
            if (showReport) {
                code = this.removeComment(code);
            }
            DecompilerOutputUtil decompilerOutputUtil = new DecompilerOutputUtil("Jad", code);
            code = decompilerOutputUtil.realign();
        }
        if (useSorter = prefs.getBoolean("net.sf.feeling.decompiler.use_eclipse_sorter")) {
            code = SortMemberUtil.sortMember(type.getPackageFragment().getElementName(), className, code);
        }
        StringBuffer source = new StringBuffer();
        source.append(this.formatSource(code));
        if (showReport) {
            source.append("\n\n/*");
            source.append("\n\tDECOMPILATION REPORT\n\n");
            source.append(location).append("\n");
            source.append("\tTotal time: ").append(this.decompiler.getDecompilationTime()).append(" ms\n");
            source.append(this.decompiler.getLog());
            exceptions.addAll(this.decompiler.getExceptions());
            this.logExceptions(exceptions, source);
            source.append("\n*/");
        }
        if (originalSourceMapper.containsKey(root)) {
            ((SourceMapper)originalSourceMapper.get(root)).mapSource(type, source.toString().toCharArray(), null);
        }
        return source.toString().toCharArray();
    }

    private String removeComment(String code) {
        String[] spilts = code.replaceAll("\r\n", "\n").split("\n");
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < spilts.length) {
            if (i <= 0 || i >= 5) {
                String string = spilts[i];
                Pattern pattern = Pattern.compile("\\s*/\\*\\s*\\S*\\*/", 2);
                Matcher matcher = pattern.matcher(string);
                if (matcher.find() && matcher.start() == 0) {
                    buffer.append(string).append("\r\n");
                } else {
                    boolean refer = false;
                    pattern = Pattern.compile("\\s*// Referenced", 2);
                    matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        refer = true;
                        while (spilts[++i].trim().startsWith("//")) {
                        }
                        if (i < spilts.length) {
                            --i;
                        }
                    }
                    if (!refer) {
                        buffer.append(String.valueOf(string) + "\r\n");
                    }
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    private void logExceptions(Collection exceptions, StringBuffer buffer) {
        buffer.append("\tCaught exceptions:");
        if (exceptions == null || exceptions.size() == 0) {
            return;
        }
        buffer.append("\n");
        StringWriter stackTraces = new StringWriter();
        PrintWriter stackTracesP = new PrintWriter(stackTraces);
        Iterator i = exceptions.iterator();
        while (i.hasNext()) {
            ((Exception)i.next()).printStackTrace(stackTracesP);
            stackTracesP.println("");
        }
        stackTracesP.flush();
        stackTracesP.close();
        buffer.append(stackTraces.toString());
    }
}

