/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.ui.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.epic.core.util.StatusFactory;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.PerlLineBreakpoint;
import org.epic.debug.ui.propertypages.PropertyPageMessages;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.editors.PerlPartitioner;
import org.epic.perleditor.editors.PerlSourceViewerConfiguration;

public class PerlLineBreakpointPage
extends PropertyPage {
    private SourceViewer conditionText;
    private Button enableConditionButton;
    private Button enabledButton;
    private List errors = new ArrayList();

    public boolean performOk() {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                PerlLineBreakpointPage.this.getBreakpoint().setEnabled(PerlLineBreakpointPage.this.enabledButton.getSelection());
                PerlLineBreakpointPage.this.storeCondition();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null, 0, null);
        }
        catch (CoreException e) {
            this.logError(PropertyPageMessages.unableToStore, e);
        }
        return super.performOk();
    }

    protected void addErrorMessage(String message) {
        this.errors.remove(message);
        this.errors.add(message);
        this.setErrorMessage(message);
        this.setValid(message == null);
    }

    protected Button createCheckButton(Composite parent, String text) {
        Button button = new Button(parent, 16416);
        button.setText(text);
        button.setFont(parent.getFont());
        button.setLayoutData((Object)new GridData());
        return button;
    }

    protected Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        return composite;
    }

    protected Control createContents(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.noDefaultAndApplyButton();
        this.createLabels(composite);
        try {
            this.createEnabledButton(composite);
            this.createConditionEditor(composite);
        }
        catch (CoreException e) {
            this.logError(PropertyPageMessages.createContentsError, e);
        }
        this.setValid(true);
        return composite;
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setFont(parent.getFont());
        label.setLayoutData((Object)new GridData());
        return label;
    }

    protected Button createRadioButton(Composite parent, String text) {
        Button button = new Button(parent, 16400);
        button.setText(text);
        button.setFont(parent.getFont());
        button.setLayoutData((Object)new GridData());
        return button;
    }

    protected Text createText(Composite parent, String initialValue) {
        Composite textComposite = this.createComposite(parent, 2);
        Text text = new Text(textComposite, 2052);
        text.setText(initialValue);
        text.setFont(parent.getFont());
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    protected PerlLineBreakpoint getBreakpoint() {
        return (PerlLineBreakpoint)this.getElement();
    }

    protected void removeErrorMessage(String message) {
        this.errors.remove(message);
        if (this.errors.isEmpty()) {
            this.addErrorMessage(null);
        } else {
            this.addErrorMessage((String)this.errors.get(this.errors.size() - 1));
        }
    }

    private void createCondition(Composite parent) throws CoreException {
        Composite composite = this.createComposite(parent, 1);
        PerlLineBreakpoint breakpoint = this.getBreakpoint();
        this.conditionText = new SourceViewer(composite, null, 2816);
        Document document = new Document(breakpoint.getCondition());
        PerlPartitioner partitioner = new PerlPartitioner(PerlDebugPlugin.getDefault().getLog());
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        partitioner.connect((IDocument)document);
        this.conditionText.configure((SourceViewerConfiguration)new PerlSourceViewerConfiguration(PerlEditorPlugin.getDefault().getPreferenceStore(), null));
        this.conditionText.setEditable(true);
        this.conditionText.setDocument((IDocument)document);
        Control control = this.conditionText.getControl();
        control.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(60);
        data.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)data);
        this.conditionText.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                PerlLineBreakpointPage.this.validateCondition();
            }
        });
    }

    private void createConditionEditor(Composite parent) throws CoreException {
        Composite groupComposite = this.createGroup(parent);
        PerlLineBreakpoint breakpoint = this.getBreakpoint();
        String caLabel = PropertyPageMessages.enableConditionWithoutCA;
        this.enableConditionButton = this.createCheckButton(groupComposite, caLabel);
        this.enableConditionButton.setSelection(breakpoint.isConditionEnabled());
        this.enableConditionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerlLineBreakpointPage.this.toggleConditionEnabled(PerlLineBreakpointPage.this.enableConditionButton.getSelection());
                PerlLineBreakpointPage.this.validateCondition();
            }
        });
        this.createCondition(groupComposite);
        this.toggleConditionEnabled(this.enableConditionButton.getSelection());
    }

    private void createEnabledButton(Composite parent) throws CoreException {
        this.enabledButton = this.createCheckButton(parent, PropertyPageMessages.enabled);
        this.enabledButton.setSelection(this.getBreakpoint().isEnabled());
    }

    private Composite createGroup(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout());
        return composite;
    }

    private void createLabels(Composite parent) {
        Composite label = this.createComposite(parent, 2);
        PerlLineBreakpoint breakpoint = (PerlLineBreakpoint)this.getElement();
        String lineNumber = null;
        try {
            lineNumber = Integer.toString(breakpoint.getLineNumber());
            this.createLabel(label, PropertyPageMessages.line);
            this.createLabel(label, lineNumber);
        }
        catch (CoreException e) {
            this.logError(PropertyPageMessages.createContentsError, e);
        }
    }

    private void logError(String message, CoreException e) {
        String id = PerlDebugPlugin.getUniqueIdentifier();
        PerlDebugPlugin.getDefault().getLog().log(StatusFactory.createError((String)id, (String)message, (Throwable)e));
    }

    private void storeCondition() throws CoreException {
        PerlLineBreakpoint breakpoint = this.getBreakpoint();
        if (breakpoint.isConditionEnabled() != this.enableConditionButton.getSelection()) {
            breakpoint.setConditionEnabled(this.enableConditionButton.getSelection());
        }
        if (!this.conditionText.getDocument().get().equals(breakpoint.getCondition())) {
            breakpoint.setCondition(this.conditionText.getDocument().get());
        }
    }

    private void toggleConditionEnabled(boolean enabled) {
        this.conditionText.getTextWidget().setEnabled(enabled);
    }

    private void validateCondition() {
        if (!this.enableConditionButton.getSelection()) {
            this.removeErrorMessage(PropertyPageMessages.conditionBlankErrorMessage);
            return;
        }
        if ("".equals(this.conditionText.getDocument().get().trim())) {
            this.addErrorMessage(PropertyPageMessages.conditionBlankErrorMessage);
        } else {
            this.removeErrorMessage(PropertyPageMessages.conditionBlankErrorMessage);
        }
    }
}

