/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.remote;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNCommitPathHandler;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc2.SvnRemoteOperationRunner;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc2.SvnCommitItem;
import org.tmatesoft.svn.core.wc2.SvnRemoteMkDir;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnRemoteRemoteMkDir
extends SvnRemoteOperationRunner<SVNCommitInfo, SvnRemoteMkDir> {
    @Override
    protected SVNCommitInfo run() throws SVNException {
        Collection<SvnTarget> targets;
        SVNCommitInfo info = this.doRun();
        if (info != null && (targets = ((SvnRemoteMkDir)this.getOperation()).getTargets()) != null && targets.size() != 0) {
            SvnTarget firstTarget = targets.iterator().next();
            SVNRepository repository = this.getRepositoryAccess().createRepository(firstTarget.getURL(), null, true);
            SVNURL repositoryRoot = repository.getRepositoryRoot(true);
            ((SvnRemoteMkDir)this.getOperation()).receive(SvnTarget.fromURL(repositoryRoot), info);
        }
        return info;
    }

    protected SVNCommitInfo doRun() throws SVNException {
        SVNCommitInfo info;
        String commitMessage;
        int i = 0;
        SVNURL[] urls = new SVNURL[((SvnRemoteMkDir)this.getOperation()).getTargets().size()];
        for (SvnTarget target : ((SvnRemoteMkDir)this.getOperation()).getTargets()) {
            urls[i++] = target.getURL();
        }
        if (((SvnRemoteMkDir)this.getOperation()).isMakeParents()) {
            LinkedList<SVNURL> allURLs = new LinkedList<SVNURL>();
            for (i = 0; i < urls.length; ++i) {
                SVNURL url = urls[i];
                this.addURLParents(allURLs, url);
            }
            urls = allURLs.toArray(new SVNURL[allURLs.size()]);
        }
        if (urls == null || urls.length == 0) {
            return SVNCommitInfo.NULL;
        }
        AbstractCollection paths = new SVNHashSet();
        SVNURL rootURL = SVNURLUtil.condenceURLs(urls, paths, false);
        if (rootURL == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "Can not compute common root URL for specified URLs");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (paths.isEmpty()) {
            paths.add(SVNPathUtil.tail(rootURL.getURIEncodedPath()));
            rootURL = rootURL.removePathTail();
        }
        if (paths.contains("")) {
            ArrayList<String> convertedPaths = new ArrayList<String>();
            String tail = SVNPathUtil.tail(rootURL.getURIEncodedPath());
            rootURL = rootURL.removePathTail();
            for (String path : paths) {
                if ("".equals(path)) {
                    convertedPaths.add(tail);
                    continue;
                }
                convertedPaths.add(SVNPathUtil.append(tail, path));
            }
            paths = convertedPaths;
        }
        ArrayList sortedPaths = new ArrayList(paths);
        Collections.sort(sortedPaths, SVNPathUtil.PATH_COMPARATOR);
        if (((SvnRemoteMkDir)this.getOperation()).getCommitHandler() != null) {
            SvnCommitItem[] commitItems = new SvnCommitItem[sortedPaths.size()];
            for (i = 0; i < commitItems.length; ++i) {
                String path;
                path = (String)sortedPaths.get(i);
                SvnCommitItem item = new SvnCommitItem();
                item.setKind(SVNNodeKind.DIR);
                item.setUrl(rootURL.appendPath(path, true));
                item.setFlags(1);
                commitItems[i] = item;
            }
            commitMessage = ((SvnRemoteMkDir)this.getOperation()).getCommitHandler().getCommitMessage(((SvnRemoteMkDir)this.getOperation()).getCommitMessage(), commitItems);
            if (commitMessage == null) {
                return SVNCommitInfo.NULL;
            }
        } else {
            commitMessage = ((SvnRemoteMkDir)this.getOperation()).getCommitMessage();
        }
        commitMessage = commitMessage == null ? "" : SVNCommitUtil.validateCommitMessage(commitMessage);
        ArrayList<String> decodedPaths = new ArrayList<String>();
        for (String path : sortedPaths) {
            decodedPaths.add(SVNEncodingUtil.uriDecode(path));
        }
        paths = decodedPaths;
        SVNRepository repository = this.getRepositoryAccess().createRepository(rootURL, null, true);
        commitMessage = SVNCommitUtil.validateCommitMessage(commitMessage);
        SVNPropertiesManager.validateRevisionProperties(((SvnRemoteMkDir)this.getOperation()).getRevisionProperties());
        ISVNEditor commitEditor = repository.getCommitEditor(commitMessage, null, false, ((SvnRemoteMkDir)this.getOperation()).getRevisionProperties(), null);
        ISVNCommitPathHandler creater = new ISVNCommitPathHandler(){

            @Override
            public boolean handleCommitPath(String commitPath, ISVNEditor commitEditor) throws SVNException {
                SVNPathUtil.checkPathIsValid(commitPath);
                commitEditor.addDir(commitPath, null, -1L);
                return true;
            }
        };
        try {
            SVNCommitUtil.driveCommitEditor(creater, paths, commitEditor, -1L);
            info = commitEditor.closeEdit();
        }
        catch (SVNException e) {
            try {
                commitEditor.abortEdit();
            }
            catch (SVNException inner) {
                // empty catch block
            }
            throw e;
        }
        if (info != null && info.getNewRevision() >= 0L) {
            this.handleEvent(SVNEventFactory.createSVNEvent(null, SVNNodeKind.NONE, null, info.getNewRevision(), SVNEventAction.COMMIT_COMPLETED, null, null, null), -1.0);
        }
        return info != null ? info : SVNCommitInfo.NULL;
    }

    private void addURLParents(List<SVNURL> targets, SVNURL url) throws SVNException {
        SVNURL parentURL = url.removePathTail();
        SVNRepository repository = this.getRepositoryAccess().createRepository(parentURL, null, true);
        SVNNodeKind kind = repository.checkPath("", -1L);
        if (kind == SVNNodeKind.NONE) {
            this.addURLParents(targets, parentURL);
        }
        targets.add(url);
    }
}

