﻿/*
This file is:
The zlib/libpng License 
Copyright (c) 2012 freesftys<freesftys@gmail.com>

This software is provided 'as-is', without any express or implied warranty. 
In no event will the authors be held liable for any damages arising from 
the use of this software.

Permission is granted to anyone to use this software for any purpose, including 
commercial applications, and to alter it and redistribute it freely, subject to 
the following restrictions:

    1. The origin of this software must not be misrepresented; you must not 
	   claim that you wrote the original software. If you use this software in 
	   a product, an acknowledgment in the product documentation would be 
	   appreciated but is not required.
	
    2. Altered source versions must be plainly marked as such, and must not be 
       misrepresented as being the original software.
	
    3. This notice may not be removed or altered from any source distribution.

原文
http://opensource.org/licenses/Zlib

日本語訳
http://sourceforge.jp/projects/opensource/wiki/licenses%2Fzlib_libpng_license
*/

#include <windows.h>
#include <windowsx.h>	// +[JOJO]
#include <tchar.h>
#include <commctrl.h>

#include "NppHorizontalRuler.h"
#include "HorizontalRuler.h"
#include "ini.h"

#define RULER_FONT_SIZE_MIN 5		//+[JOJO]
#define RULER_FONT_SIZE_MAX 15		//+[JOJO]

extern HINSTANCE g_DllhInst;
extern NppData nppData;
extern FuncItem funcItem[];

static HorizontalRuler mainHRuler, subHRuler;

static HWND mainTabHwnd, subTabHwnd;
static WNDPROC mainOldWndProc, subOldWndProc;

static void RulerWndProcSet();
static void RulerWndProcUnset();

namespace Ruler {
	bool /*Ruler::*/visible = true;	// ini
	WCHAR /*Ruler::*/szFontName[LF_FACESIZE] = L"FixedSys";	// ini
	int /*Ruler::*/nFontSize = 7;	// ini
	COLORREF /*Ruler::*/BGColor = 0;	// ini

	HFONT /*Ruler::*/hFont;
	int /*Ruler::*/nDrawHeight;	// font height + 1
	int /*Ruler::*/nRulerHeight;	// NPPM_SETBORDERTOP
};

static void LoadConfig()
{
	WCHAR configDir[MAX_PATH];
	SendMessage(nppData._nppHandle, NPPM_GETPLUGINSCONFIGDIR, _countof(configDir), (LPARAM)configDir);
	Ini::getInstance()->setIniPath(configDir, L"HorizontalRuler.ini");

	Ini::getInstance()->readData(L"HorizontalRuler", L"Visible", &Ruler::visible);
	Ini::getInstance()->readData(L"HorizontalRuler", L"FontName", Ruler::szFontName, LF_FACESIZE);
	Ini::getInstance()->readData(L"HorizontalRuler", L"FontSize", &Ruler::nFontSize);
	Ini::getInstance()->readData(L"HorizontalRuler", L"BGColor", &Ruler::BGColor);

	if (Ruler::nFontSize < RULER_FONT_SIZE_MIN) Ruler::nFontSize = RULER_FONT_SIZE_MIN;
	if (Ruler::nFontSize > RULER_FONT_SIZE_MAX) Ruler::nFontSize = RULER_FONT_SIZE_MAX;
}

static void SaveConfig()
{
	Ini::getInstance()->writeData(L"HorizontalRuler", L"Visible", Ruler::visible);
	Ini::getInstance()->writeData(L"HorizontalRuler", L"FontName", Ruler::szFontName);
	Ini::getInstance()->writeData(L"HorizontalRuler", L"FontSize", Ruler::nFontSize);
	Ini::getInstance()->writeData(L"HorizontalRuler", L"BGColor", Ruler::BGColor);
}

static void LoadFont()
{
	LOGFONT logFont;
	ZeroMemory(&logFont, sizeof(LOGFONT));
	const HDC hDC = GetDC(nppData._scintillaMainHandle);
	logFont.lfHeight = -MulDiv(Ruler::nFontSize, GetDeviceCaps(hDC, LOGPIXELSY), 72);
	ReleaseDC(nppData._scintillaMainHandle, hDC);
	wcscpy_s(logFont.lfFaceName, LF_FACESIZE, Ruler::szFontName);
	Ruler::hFont = CreateFontIndirect(&logFont);

	const int cyedge = GetSystemMetrics(SM_CYEDGE);

	Ruler::nDrawHeight = abs(logFont.lfHeight) + 1;
	Ruler::nRulerHeight = Ruler::nDrawHeight + cyedge;
}

static void UnloadFont()
{
	DeleteObject(Ruler::hFont); Ruler::hFont = nullptr;
}

static void setVisible(bool b)
{
	Ruler::visible = b;

	SendMessage(nppData._nppHandle, NPPM_SETBORDERTOP, Ruler::visible ? Ruler::nRulerHeight : 0, 0);
	SendMessage(nppData._nppHandle, WM_SIZE, 0, 0);	// Notepad_plus::process() call _dockingManager.reSizeTo() --> DocTabView::reSizeTo()

	SendMessage(nppData._nppHandle, NPPM_SETMENUITEMCHECK, funcItem[RULER_VISIBLE]._cmdID, b);
	SendMessage(nppData._nppHandle, NPPM_SETMENUITEMCHECK, funcItem[RULER_HIDE]._cmdID, !b);
}

void RulerVisible()	// RULER_VISIBLE "Visible Ruler"
{
	setVisible(true);
}

void RulerHide()	// RULER_HIDE "Hide Ruler"
{
	setVisible(false);
}

void onHorizontalRulerBeNotified(SCNotification *notifyCode)
{
	switch (notifyCode->nmhdr.code)
	{
	case SCN_PAINT_DONE:
		if (notifyCode->nmhdr.hwndFrom == nppData._scintillaMainHandle)
			mainHRuler.RedrawIfCursorMoved();
		else if (notifyCode->nmhdr.hwndFrom == nppData._scintillaSecondHandle)
			subHRuler.RedrawIfCursorMoved();
		break;

	case NPPN_READY:
		LoadConfig();
		LoadFont();
		RulerWndProcSet();
		mainHRuler.Init(nppData._nppHandle, nppData._scintillaMainHandle, mainTabHwnd);
		subHRuler.Init(nppData._nppHandle, nppData._scintillaSecondHandle, subTabHwnd);
		setVisible(Ruler::visible);
		break;

	case NPPN_SHUTDOWN:
		SaveConfig();
		UnloadFont();
		RulerWndProcUnset();
		break;
	}
}

static LRESULT CALLBACK RulerMainWndProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return mainHRuler.TabWndProc(mainOldWndProc, hwnd, uMsg, wParam, lParam);
}

static LRESULT CALLBACK RulerSubWndProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return subHRuler.TabWndProc(subOldWndProc, hwnd, uMsg, wParam, lParam);
}

static void RulerWndProcSet()
{
	mainTabHwnd = FindWindowEx(nppData._nppHandle, NULL, WC_TABCONTROL, NULL);
	subTabHwnd = FindWindowEx(nppData._nppHandle, mainTabHwnd, WC_TABCONTROL, NULL);
	mainOldWndProc = (WNDPROC)SetWindowLongPtr(mainTabHwnd, GWLP_WNDPROC, (LONG_PTR)RulerMainWndProc);
	subOldWndProc = (WNDPROC)SetWindowLongPtr(subTabHwnd, GWLP_WNDPROC, (LONG_PTR)RulerSubWndProc);
}

static void RulerWndProcUnset()
{
	SetWindowLongPtr(subTabHwnd, GWLP_WNDPROC, (LONG_PTR)subOldWndProc);
	SetWindowLongPtr(mainTabHwnd, GWLP_WNDPROC, (LONG_PTR)mainOldWndProc);
}
