#!perl
use utf8;
use warnings;
use strict;

binmode STDOUT,':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $BIN = 'bin';
if (@ARGV) {
	$BIN = $ARGV[0];
	$BIN =~ s{[\\/]$}{};
}

&start("$BIN/stylers.model.xml");
&start("$BIN/stylers.xml") if -f FS("$BIN/stylers.xml");

my $subDir = "$BIN/themes/";
opendir DIR, FS($subDir);
my @files = map {UTF8($_)} readdir DIR;
closedir DIR;
for my $file (@files) {
	next if $file =~ m/^[.#]/;
	next unless $file =~ m/\.xml$/;
	my $path = $subDir.$file;
	&start($path);
}

exit(0);

sub start {
	my ($path) = @_;

	open FILE, '<:encoding(Windows-1252)', $path or die $!;
	my $mtime = (stat FILE)[9];
	read FILE, my $xml, -s FILE;
	close FILE;

	my $oiginal = $xml;

	#+ <WidgetStyle name="End of line" styleID="0" fgColor="FFFF00" />
	unless ($xml =~ m{<WidgetStyle name="End of line"}s) {
		$xml =~ m{<WidgetStyle name="White space symbol".*fgColor="(.+?)"}m;
		my $fgColor = $1;
		$xml =~ s{([ \t]+)(<WidgetStyle name="White space symbol".*?/>)([\r\n]+)}
		         {$1$2$3$1<WidgetStyle name="End of line" styleID="0" fgColor="$fgColor" />$3}s;
	}

	#+ <WidgetStyle name="Mark Style 1" styleID="25" bgColor="00FFFF" />
	#+ <WidgetStyle name="Mark Style 2" styleID="24" bgColor="FF8000" />
	#+ <WidgetStyle name="Mark Style 3" styleID="23" bgColor="FFFF00" />
	#+ <WidgetStyle name="Mark Style 4" styleID="22" bgColor="8000FF" />
	#+ <WidgetStyle name="Mark Style 5" styleID="21" bgColor="008000" />
	$xml =~ s{([ \t]*)(</GlobalStyles>)}{$1$1<WidgetStyle name="Mark Style 1" styleID="25" bgColor="00FFFF" />\n$1$2} unless $xml =~ m{<WidgetStyle name="Mark Style 1" styleID="25"}s;
	$xml =~ s{([ \t]*)(</GlobalStyles>)}{$1$1<WidgetStyle name="Mark Style 2" styleID="24" bgColor="FF8000" />\n$1$2} unless $xml =~ m{<WidgetStyle name="Mark Style 2" styleID="24"}s;
	$xml =~ s{([ \t]*)(</GlobalStyles>)}{$1$1<WidgetStyle name="Mark Style 3" styleID="23" bgColor="FFFF00" />\n$1$2} unless $xml =~ m{<WidgetStyle name="Mark Style 3" styleID="23"}s;
	$xml =~ s{([ \t]*)(</GlobalStyles>)}{$1$1<WidgetStyle name="Mark Style 4" styleID="22" bgColor="8000FF" />\n$1$2} unless $xml =~ m{<WidgetStyle name="Mark Style 4" styleID="22"}s;
	$xml =~ s{([ \t]*)(</GlobalStyles>)}{$1$1<WidgetStyle name="Mark Style 5" styleID="21" bgColor="008000" />\n$1$2} unless $xml =~ m{<WidgetStyle name="Mark Style 5" styleID="21"}s;

	#+ <WidgetStyle name="URL hovered" styleID="0" fgColor="0000FF" />
	$xml =~ s{([ \t]*)(</GlobalStyles>)}{$1$1<WidgetStyle name="URL hovered" styleID="0" fgColor="0000FF" />\n$1$2} unless $xml =~ m{<WidgetStyle name="URL hovered" styleID="0"}s;

	if ($oiginal ne $xml) {
		print "$path\n";
		open FILE, '>:encoding(Windows-1252)', $path;
		print FILE $xml;
		close FILE;
		utime $mtime + 2, $mtime + 2, $path;
	}
}
