#include <windows.h>
#include <string>

__declspec(dllexport) WCHAR wtolower(WCHAR wc)	// tr/[A-Z]/[a-z]
{
	return wc <= 'Z' && wc >= 'A' ? wc - 'A' + 'a' : wc;
}

__declspec(dllexport) WCHAR wtoupper(WCHAR wc)	// tr/[a-z]/[A-Z]
{
	return wc <= 'z' && wc >= 'a' ? wc - 'a' + 'A' : wc;
}

__declspec(dllexport) bool wcseq(const WCHAR *str1, const WCHAR *str2) /* overload */
{
	for (; *str1 == *str2; ++str1, ++str2) if (*str2 == '\0') return true;
	return false;
}

__declspec(dllexport) bool wcseq(const WCHAR *str1, const char *str2) /* overload */
{
	for (; *str1 == *str2; ++str1, ++str2) if (*str2 == '\0') return true;
	return false;
}

__declspec(dllexport) bool wcseq(const char *str1, const WCHAR *str2) /* overload */
{
	return wcseq(str2, str1);
}

__declspec(dllexport) bool wcseqi(const WCHAR *str1, const WCHAR *str2)
{
	for (; *str1 == *str2 || wtolower(*str1) == wtolower(*str2); ++str1, ++str2) if (*str2 == '\0') return true;
	return false;
}

__declspec(dllexport) bool wcsstartsWith(const WCHAR *ws, const WCHAR *pattern)
{
	for (; *ws == *pattern; ++ws, ++pattern) if (*pattern == '\0') return true;
	return *pattern == '\0';
}

__declspec(dllexport) bool wcsstartsWithi(const WCHAR *ws, const WCHAR *pattern)
{
	for (; *ws == *pattern || wtolower(*ws) == wtolower(*pattern); ++ws, ++pattern) if (*pattern == '\0') return true;
	return *pattern == '\0';
}

__declspec(dllexport) bool wcsendsWith(const WCHAR *ws, const WCHAR *pattern)
{
	int i; return (i = lstrlenW(ws) - lstrlenW(pattern)) >= 0 && wcseq(ws + i, pattern);
}

__declspec(dllexport) bool wcsendsWithi(const WCHAR *ws, const WCHAR *pattern)
{
	int i; return (i = lstrlenW(ws) - lstrlenW(pattern)) >= 0 && wcseqi(ws + i, pattern);
}

__declspec(dllexport) int fwprintf(std::wstring &ws, const WCHAR* format, ...) /* overload */
{
#if 1111
	va_list args;
	va_start(args, format);

	const int count = _vscwprintf(format, args);
	if (count > 0) {
		const int wslength = ws.length();
		const int sizeOfBuffer = count + 1;
		ws.resize(wslength + sizeOfBuffer);
		_vsnwprintf_s(&ws[wslength], sizeOfBuffer, _TRUNCATE, format, args);
		ws.pop_back();	// remove '\0'
	}

	va_end(args);
	return count;
#else
	int count;

	WCHAR a[256], *b = nullptr;

	int sizeOfBuffer = _countof(a);
	WCHAR *buffer = a;
	for (;;) {
		va_list args;
		va_start(args, format);
		count = _vsnwprintf_s(buffer, sizeOfBuffer, _TRUNCATE, format, args);
		va_end(args);
		if (count != -1)
			break;
 #if 1
		sizeOfBuffer *= 2;
		delete[] b;
 #else
		va_start(args, format);
		sizeOfBuffer = _vscwprintf(format, args) + 1;
		va_end(args);
 #endif
		buffer = b = new WCHAR[sizeOfBuffer];
	}
	ws += buffer;

	delete[] b;
	return count;
#endif
}

