﻿/*
This file is:
The zlib/libpng License 
Copyright (c) 2012 freesftys<freesftys@gmail.com>

This software is provided 'as-is', without any express or implied warranty. 
In no event will the authors be held liable for any damages arising from 
the use of this software.

Permission is granted to anyone to use this software for any purpose, including 
commercial applications, and to alter it and redistribute it freely, subject to 
the following restrictions:

    1. The origin of this software must not be misrepresented; you must not 
	   claim that you wrote the original software. If you use this software in 
	   a product, an acknowledgment in the product documentation would be 
	   appreciated but is not required.
	
    2. Altered source versions must be plainly marked as such, and must not be 
       misrepresented as being the original software.
	
    3. This notice may not be removed or altered from any source distribution.

原文
http://opensource.org/licenses/Zlib

日本語訳
http://sourceforge.jp/projects/opensource/wiki/licenses%2Fzlib_libpng_license
*/

#include <shlwapi.h>
#include <assert.h>

#include "Ini.h"

Ini::Ini()
{
}

Ini::~Ini()
{
	delete [] this->fullPath;
}

bool Ini::setIniPath(const WCHAR *directory, const WCHAR *fileName)
{
	if (this->inited)
		return true;

	WCHAR path[MAX_PATH];
	wcscpy_s(path, _countof(path), directory);
	if (! PathAppend(path, fileName)) return false;

	const size_t len = lstrlen(path) + 1;
	delete [] this->fullPath;
	this->fullPath = new WCHAR[len];
	wcscpy_s(this->fullPath, len, path);

	this->inited = true;
	return true;
}

/// write系の戻り値は0以外は正常、0はエラー　http://msdn.microsoft.com/ja-jp/library/cc429952.aspxへ
// NUMDIGIT = 64桁
void Ini::writeData(const WCHAR *section, const WCHAR *key, const WCHAR *value)
{
	WritePrivateProfileStringW(section, key, value, this->fullPath);
}

void Ini::writeData(const WCHAR *section, const WCHAR *key, const bool value)
{
	WritePrivateProfileStringW(section, key, value ? L"true" : L"false", this->fullPath);
}

void Ini::writeData(const WCHAR *section, const WCHAR *key, const int value)
{
	WCHAR buf[NUMDIGIT];
	swprintf_s(buf, _countof(buf), L"%d", value);
	WritePrivateProfileStringW(section, key, buf, this->fullPath);
}

void Ini::writeData(const WCHAR *section, const WCHAR *key, const unsigned int value)
{
	WCHAR buf[NUMDIGIT];
	swprintf_s(buf, _countof(buf), L"%u", value);
	WritePrivateProfileStringW(section, key, buf, this->fullPath);
}

void Ini::writeData(const WCHAR *section, const WCHAR *key, const unsigned long value)
{
	WCHAR buf[NUMDIGIT];
	swprintf_s(buf, _countof(buf), L"%lu", value);
	WritePrivateProfileStringW(section, key, buf, this->fullPath);
}

void Ini::writeData(const WCHAR *section, const WCHAR *key, const double value)
{
	WCHAR buf[NUMDIGIT];
	swprintf_s(buf, _countof(buf), L"%f", value);
	WritePrivateProfileStringW(section, key, buf, this->fullPath);
}

/// 戻り値は読み込んだ文字数 error時はhttp://msdn.microsoft.com/ja-jp/library/cc429779.aspxを
int Ini::_readData(const WCHAR *section, const WCHAR *key, WCHAR *buf, int bufsize)
{
	int readSize = GetPrivateProfileStringW(section, key, L"", buf, bufsize, this->fullPath);
	return readSize == bufsize - 1 || readSize == bufsize - 2 ? 0 : readSize;
}

void Ini::readData(const WCHAR *section, const WCHAR *key, WCHAR value[], int valueSize)
{
	WCHAR buf[MAX_PATH];
	assert(valueSize <= _countof(buf));
	if (this->_readData(section, key, buf, valueSize))
		wcscpy_s(value, valueSize, buf);
}

void Ini::readData(const WCHAR *section, const WCHAR *key, bool *value)
{
	WCHAR buf[NUMDIGIT];
	if (this->_readData(section, key, buf, _countof(buf)))
		*value = lstrcmp(buf, L"true") == 0;
}

void Ini::readData(const WCHAR *section, const WCHAR *key, int *value)
{
	WCHAR buf[NUMDIGIT];
	if (!this->_readData(section, key, buf, _countof(buf))) return;
	wchar_t *end;
	long temp = wcstol(buf, &end, 0);
	if (end == buf) return;
	*value = temp;
}

void Ini::readData(const WCHAR *section, const WCHAR *key, unsigned int *value)
{
	WCHAR buf[NUMDIGIT];
	if (!this->_readData(section, key, buf, _countof(buf))) return;
	wchar_t *end;
	unsigned long temp = wcstoul(buf, &end, 0);
	if (end == buf) return;
	*value = (unsigned int) temp;
}

void Ini::readData(const WCHAR *section, const WCHAR *key, unsigned long *value)
{
	WCHAR buf[NUMDIGIT];
	if (!this->_readData(section, key, buf, _countof(buf))) return;
	wchar_t *end;
	unsigned long temp = wcstoul(buf, &end, 0);
	if (end == buf) return;
	*value = temp;
}

void Ini::readData(const WCHAR *section, const WCHAR *key, float *value)
{
	WCHAR buf[NUMDIGIT];
	if (!this->_readData(section, key, buf, _countof(buf))) return;
	wchar_t *end;
	double temp = wcstod(buf, &end);
	if (end == buf) return;
	*value = (float) temp;
}

void Ini::readData(const WCHAR *section, const WCHAR *key, double *value)
{
	WCHAR buf[NUMDIGIT];
	if (!this->_readData(section, key, buf, _countof(buf))) return;
	wchar_t *end;
	double temp = wcstod(buf, &end);
	if (end == buf) return;
	*value = temp;
}
