#!perl
use utf8;
use warnings;
use strict;
use Encode;

binmode STDOUT,':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $DEBUG = 0;

die unless @ARGV;

my $BIN = $ARGV[0];
$BIN =~ s{[\\/]$}{};

&start("$BIN/");
&start("$BIN/themes/");

exit(0);

sub start {
	my ($subDir) = @_;
	opendir DIR, FS($subDir);
	my @files = map {UTF8($_)} readdir DIR;
	closedir DIR;
	for my $file (@files) {
		next if $file =~ m/^[.#]/;
		my $path = $subDir.$file;
		if (-d FS($path)) {
 #			&start($path.'/');
		} elsif ($file =~ m/\.xml$/) {
			&update($path);
		}
	}
}

sub update {
	my ($path) = @_;
	open FILE, '<:bytes', FS($path) or die $!;
	binmode FILE;
	my $mtime = (stat FILE)[9];
	read FILE, my $xml, -s FILE;
	close FILE;

	my $oiginal = $xml;

	#- <?xml version="1.0" encoding="Windows-1252" ?>
	#+ <?xml version="1.0" encoding="utf-8" ?>
	if ($xml =~ m/(?<=\Q<?xml version="1.0" encoding=\E)"Windows-1252"(?=\Q ?>\E)/)
 	{
		$xml =~ s//"utf-8"/;
		$xml = Encode::decode('Windows-1252', $xml);
 	}

	unlink FS("$path.text") if $DEBUG;
	if ($oiginal ne $xml) {
		$path = "$path.text" if $DEBUG;
		print "$path\n";
		open FILE, '>:utf8', FS($path);
		binmode FILE;
		print FILE $xml;
		close FILE;
		utime $mtime + 2, $mtime + 2, FS($path);
	}
}
