/* SymbolicLink.cpp
 * Last update: 2016.01.04
 * (c) 2015 JOJO
 */
#if 1 //#ifdef FIX_SYMBOLIC_LINK

// Reference: https://svn.apache.org/repos/asf/hadoop/common/trunk/hadoop-common-project/hadoop-common/src/main/winutils/readlink.c
// Reference: http://msdn.microsoft.com/en-us/library/ff552012.aspx

#include <windows.h>

#pragma pack(push, 1)
typedef struct _REPARSE_DATA_BUFFER {
	ULONG  ReparseTag;
	USHORT ReparseDataLength;
	USHORT Reserved;
	union {
		struct {
			USHORT SubstituteNameOffset;
			USHORT SubstituteNameLength;
			USHORT PrintNameOffset;
			USHORT PrintNameLength;
			ULONG  Flags;
			WCHAR  PathBuffer[1];
		} SymbolicLinkReparseBuffer;
		struct {
			USHORT SubstituteNameOffset;
			USHORT SubstituteNameLength;
			USHORT PrintNameOffset;
			USHORT PrintNameLength;
			WCHAR  PathBuffer[1];
		} MountPointReparseBuffer;
		struct {
			UCHAR DataBuffer[1];
		} GenericReparseBuffer;
	};
} REPARSE_DATA_BUFFER, *PREPARSE_DATA_BUFFER;
#pragma pack(pop)

__declspec(dllexport) bool ToReparsePointTarget(WCHAR fileName[], int max_path)
{
	bool ret = false;
 //TODO: const DWORD attribute = GetFileAttributesW(fileName);
 //TODO: if (attribute == -1 || (attribute & FILE_ATTRIBUTE_REPARSE_POINT) == 0) return ret;

	HANDLE hFile = INVALID_HANDLE_VALUE;
	PREPARSE_DATA_BUFFER pReparseData = NULL;
	/*TRY:*/ {
		hFile = CreateFileW(fileName, 0, FILE_SHARE_READ | FILE_SHARE_WRITE | FILE_SHARE_DELETE, NULL, OPEN_EXISTING, FILE_FLAG_BACKUP_SEMANTICS | FILE_FLAG_OPEN_REPARSE_POINT, NULL);
		if (hFile == INVALID_HANDLE_VALUE)
			goto EXCEPTION; // throw

		DWORD nReparseDataSize = 1024;
		for (;;) {
			pReparseData = (PREPARSE_DATA_BUFFER) LocalAlloc(LMEM_FIXED, nReparseDataSize);
			if (pReparseData == NULL)
				goto EXCEPTION; // throw

			DWORD bytesReturned;
			if (DeviceIoControl(hFile, FSCTL_GET_REPARSE_POINT, NULL, 0, pReparseData, nReparseDataSize, &bytesReturned, NULL) != 0)
				break; // success
			DWORD error = GetLastError();
			if (error == ERROR_INSUFFICIENT_BUFFER ||
			    error == ERROR_MORE_DATA) {
				LocalFree(pReparseData);
				nReparseDataSize *= 2; continue;
			}
			else
				goto EXCEPTION; // throw
		}

		if (pReparseData->ReparseTag != IO_REPARSE_TAG_SYMLINK)
			goto FINALLY;

		USHORT printNameLength = pReparseData->SymbolicLinkReparseBuffer.PrintNameLength;
		USHORT printNameOffset = pReparseData->SymbolicLinkReparseBuffer.PrintNameOffset;
		int wLen = printNameLength / sizeof(WCHAR);

		if (wLen >= max_path) {
	//TODO:	SetLastError(******);
			goto EXCEPTION; // throw
		}

		memcpy(fileName, pReparseData->SymbolicLinkReparseBuffer.PathBuffer + printNameOffset, printNameLength);
		fileName[wLen] = L'\0';
		ret = true;
		goto FINALLY;
	}
	EXCEPTION: {
		goto FINALLY;
	}
	FINALLY: {
		if (pReparseData != NULL)
			LocalFree(pReparseData);
		if (hFile != INVALID_HANDLE_VALUE)
			CloseHandle(hFile);
	}

	return ret;
}
#endif // FIX_SYMBOLIC_LINK
