﻿/*
This file is:
The zlib/libpng License 
Copyright (c) 2012 freesftys<freesftys@gmail.com>

This software is provided 'as-is', without any express or implied warranty. 
In no event will the authors be held liable for any damages arising from 
the use of this software.

Permission is granted to anyone to use this software for any purpose, including 
commercial applications, and to alter it and redistribute it freely, subject to 
the following restrictions:

    1. The origin of this software must not be misrepresented; you must not 
	   claim that you wrote the original software. If you use this software in 
	   a product, an acknowledgment in the product documentation would be 
	   appreciated but is not required.
	
    2. Altered source versions must be plainly marked as such, and must not be 
       misrepresented as being the original software.
	
    3. This notice may not be removed or altered from any source distribution.

原文
http://opensource.org/licenses/Zlib

日本語訳
http://sourceforge.jp/projects/opensource/wiki/licenses%2Fzlib_libpng_license
*/
#ifndef HORIZONTAL_RULER
#define HORIZONTAL_RULER

#include "PluginInterface.h"

class HorizontalRuler {

private:
	HWND nppHwnd;	// Notepad_plus
	HWND scintillaHwnd;	// ScintillaEditView
	HWND tabHwnd;	// DocTabView

	int xOffset;	// SCI_GETXOFFSET
	int caretX;		// SCI_MAINCARETX
	int spaceWidth;	// SCI_GETSPACEWIDTH
	int textStart;	// SCI_GETTEXTSTARTX
	static const int nRightMargin = 0;	// SCI_GETMARGINRIGHT

	bool invalid;
	bool isCursorMoved();

	RECT rulerRect;
	RECT rulerDesctopRect;
	int nDrawStartX;
	int nDrawEndX;

	void Redraw();

public:

	HorizontalRuler();
	~HorizontalRuler();

	void Init(HWND npp, HWND scintilla, HWND tab);
	bool IsInit();

	void GetInitPos();
	void GetRuleArea();
	void PaintRuler();

	bool HitDrawArea(int x, int y);
	void EdgeLine(int x, int y);

	void Invalidate();
	void RedrawIfCursorMoved();
	LRESULT TabWndProc(WNDPROC lpPrevWndFunc, HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
};

#endif
