/* UnicodeWidth.cpp
 * Last update: 2017.02.26
 * (c) 2017 JOJO
 */

#include <stdlib.h>
#include <algorithm>

// ../scripts/UnicodeWidth.pl
#include "UnicodeWidthData"

static int _unicodeAmbiWidth = 1;	// 2:double 1:single

__declspec(dllexport) void SetUnicodeAmbiWidth(int w) { _unicodeAmbiWidth = w; }

__declspec(dllexport) int UnicodeWidth(const uint32_t codePoint) {
	if (/*codePoint < 0 ||*/ codePoint > 0x10FFFF)
		return 1;
	const int *p = std::upper_bound(data, data + _countof(data), codePoint << SHIFT | MASK) - 1;
 //	const int *p = std::upper_bound(data, data + _countof(data), codePoint << SHIFT, [](int a, int b){ return a >> SHIFT < b >> SHIFT; }) - 1;
	int w = *p & MASK;
	return w ? w : _unicodeAmbiWidth;
}
