/* UnicodeCharClassify.cpp
 * Last update: 2017.05.17
 * (c) 2016-2017 JOJO
 */

#include <stdlib.h>
#include <algorithm>
#include "CharClassify.h"

// ../scripts/UnicodeCharClassify.pl
#include "UnicodeCharClassifyData"

#ifdef SCI_NAMESPACE
using namespace Scintilla;
#endif

CharClassify::cc UnicodeCharClassify(const uint32_t codePoint) {
	if (/*codePoint < 0 ||*/ codePoint > 0x10FFFF)
		return CharClassify::ccPunctuation;
	const int *p = std::upper_bound(data, data + _countof(data), codePoint << SHIFT | MASK) - 1;
 //	const int *p = std::upper_bound(data, data + _countof(data), codePoint << SHIFT, [](int a, int b){ return a >> SHIFT < b >> SHIFT; }) - 1;
	return (CharClassify::cc)(*p & MASK);
}
