#include <windows.h>
#include <string>

#include "UniConversion.h"

__declspec(dllexport) WCHAR __stdcall wtolower(WCHAR wc)	// tr/[A-Z]/[a-z]
{
	return wc <= 'Z' && wc >= 'A' ? wc - 'A' + 'a' : wc;
}

__declspec(dllexport) WCHAR __stdcall wtoupper(WCHAR wc)	// tr/[a-z]/[A-Z]
{
	return wc <= 'z' && wc >= 'a' ? wc - 'a' + 'A' : wc;
}

__declspec(dllexport) bool __stdcall wcseq(const WCHAR *str1, const WCHAR *str2) /* overload */
{
	for (; *str1 == *str2; ++str1, ++str2) if (*str2 == '\0') return true;
	return false;
}

__declspec(dllexport) bool __stdcall wcseq(const WCHAR *str1, const char *str2) /* overload */
{
	for (; *str1 == *str2; ++str1, ++str2) if (*str2 == '\0') return true;
	return false;
}

__declspec(dllexport) bool __stdcall wcseq(const char *str1, const WCHAR *str2) /* overload */
{
	return wcseq(str2, str1);
}

__declspec(dllexport) bool __stdcall wcseqi(const WCHAR *str1, const WCHAR *str2)
{
	for (; *str1 == *str2 || wtolower(*str1) == wtolower(*str2); ++str1, ++str2) if (*str2 == '\0') return true;
	return false;
}

__declspec(dllexport) bool __stdcall wcsstartsWith(const WCHAR *ws, const WCHAR *pattern)
{
	for (; *ws == *pattern; ++ws, ++pattern) if (*pattern == '\0') return true;
	return *pattern == '\0';
}

__declspec(dllexport) bool __stdcall strstartsWith(const char *s, const char *pattern)
{
	for (; *s == *pattern; ++s, ++pattern) if (*pattern == '\0') return true;
	return *pattern == '\0';
}

__declspec(dllexport) bool __stdcall wcsstartsWithi(const WCHAR *ws, const WCHAR *pattern)
{
	for (; *ws == *pattern || wtolower(*ws) == wtolower(*pattern); ++ws, ++pattern) if (*pattern == '\0') return true;
	return *pattern == '\0';
}

__declspec(dllexport) bool __stdcall strstartsWithi(const char *s, const char *pattern)
{
	for (; *s == *pattern || wtolower(*s) == wtolower(*pattern); ++s, ++pattern) if (*pattern == '\0') return true;
	return *pattern == '\0';
}

__declspec(dllexport) bool __stdcall wcsendsWith(const WCHAR *ws, const WCHAR *pattern)
{
	int i; return (i = lstrlenW(ws) - lstrlenW(pattern)) >= 0 && wcseq(ws + i, pattern);
}

__declspec(dllexport) bool __stdcall wcsendsWithi(const WCHAR *ws, const WCHAR *pattern)
{
	int i; return (i = lstrlenW(ws) - lstrlenW(pattern)) >= 0 && wcseqi(ws + i, pattern);
}

__declspec(dllexport) int fwprintf(std::wstring &ws, const WCHAR* format, ...) /* overload */
{
	va_list args;
	va_start(args, format);

	const int count = _vscwprintf(format, args);
	if (count > 0) {
		const int wslength = ws.length();
 #if _MSC_VER >= 1900 // Visual c++ 2015
		ws.resize(wslength + count);
		_vsnwprintf_s(&ws[wslength], count + 1, _TRUNCATE, format, args);
 #else
		const int sizeOfBuffer = count + 1;
		ws.resize(wslength + sizeOfBuffer);
		_vsnwprintf_s(&ws[wslength], sizeOfBuffer, _TRUNCATE, format, args);
		ws.pop_back();	// remove '\0'
 #endif
	}

	va_end(args);
	return count;
}


__declspec(dllexport) uint32_t __stdcall GetUnicodeCharacter(const unsigned char * s, const unsigned char * const end)
{
	if (!(s < end)) return 0;
	uint32_t leadByte = *s++;
	if (leadByte >= 0x80) {
		int trailLen = Scintilla::UTF8BytesOfLead[leadByte] - 1;
		if (trailLen == 0 || s + trailLen > end) goto ILLEGAL_BYTE;
		uint32_t codePoint = leadByte & 0x3F >> trailLen;
		while (--trailLen >= 0) {
			const unsigned char trailByte = *s++;
			if (!Scintilla::UTF8IsTrailByte(trailByte)) goto ILLEGAL_BYTE;
			codePoint = codePoint << 6 | trailByte & 0b00111111;
		}
		return codePoint;
	}
ILLEGAL_BYTE:
	return leadByte;
}
__declspec(dllexport) uint32_t __stdcall GetUnicodeCharacter(const unsigned char * doc, const int length, int postion)
{
	return GetUnicodeCharacter(doc + postion, doc + length);
}

__declspec(dllexport) uint32_t __stdcall GetUnicodeCharacter(const WCHAR * s, const WCHAR * const end)
{
	if (!(s < end)) return 0;
	uint32_t codePoint, u;
	codePoint = u = *s++;
	if (0xD800 <= u && u < 0xDC00) {
		if (!(s < end)) goto ILLEGAL_WORD;
		uint32_t v = *s++;
		if (!(0xDC00 <= v && v < 0xE000)) goto ILLEGAL_WORD;
		codePoint = (u - 0xD800) * 0x0400 + (v - 0xDC00) + 0x10000;
	}
ILLEGAL_WORD:
	return codePoint;
}
__declspec(dllexport) uint32_t __stdcall GetUnicodeCharacter(const WCHAR * ws, const int length, int postion)
{
	return GetUnicodeCharacter(ws + postion, ws + length);
}
