@REM (c)2017 Hamoschugel
@ECHO OFF
ECHO * %~dpnx0  %*

SETLOCAL

SET ME=%~n0
SET WORKPATH=..\boostregex

SET ADDRESSMODEL=address-model-32
:PARAMLOOP
  IF [%1]==[] GOTO PARAMCONTINUE
  IF [%1]==[-x86] SET ADDRESSMODEL=address-model-32
  IF [%1]==[-x64] SET ADDRESSMODEL=address-model-64
  SHIFT
  GOTO PARAMLOOP
:PARAMCONTINUE

SET PACKAGEPATH=
SET BOOSTVERSION=
SET BOOSTPATH=
SET BOOSTLIBPATH=

REM Parse NuGet.Config packages.config
cscript //nologo NugetBoost.vbs %ADDRESSMODEL%>_.BAT||GOTO :BUILDERROR
CALL _.BAT & DEL  _.BAT

IF [%PACKAGEPATH%]==[]  GOTO :BUILDERROR
IF [%BOOSTVERSION%]==[] GOTO :BUILDERROR
IF [%BOOSTPATH%]==[]    GOTO :BUILDERROR
IF [%BOOSTLIBPATH%]==[] GOTO :BUILDERROR

IF EXIST ..\..\.nuget\nuget.exe GOTO :NUGETEXIST
MKDIR ..\..\.nuget>NUL 2>&1
PUSHD ..\..\.nuget
SET URL=https://dist.nuget.org/win-x86-commandline/latest/nuget.exe
wget -c --check-certificate=off %URL% 2>NUL||^
bash -c "wget -c --check-certificate=off %URL%" 2>NUL||^
powershell Invoke-WebRequest %URL% -OutFile nuget.exe 2>NUL||^
powershell (new-object System.Net.WebClient).DownloadFile('%URL%','nuget.exe') 2>NUL||^
powershell Start-BitsTransfer %URL% nuget.exe 2>NUL||^
bitsadmin /TRANSFER nuget %URL% %CD%\nuget.exe 2>NUL||^
REM
POPD
:NUGETEXIST

@ECHO ON
..\..\.nuget\nuget.exe install packages.config
@ECHO OFF
IF ERRORLEVEL 1 GOTO :BUILDERROR

IF NOT EXIST "%BOOSTPATH%\boost\regex.hpp" ECHO ^<%ME%^> Not found: %BOOSTPATH%\boost\regex.hpp
IF NOT EXIST "%BOOSTLIBPATH%\libboost_regex-*.lib" ECHO ^<%ME%^> Not found: %BOOSTLIBPATH%libboost_regex-*.lib
IF NOT EXIST "%BOOSTPATH%\boost\regex.hpp" GOTO :END
IF NOT EXIST "%BOOSTLIBPATH%\libboost_regex-*.lib" GOTO :END

ECHO *******************************************************************************
ECHO Boost version: %BOOSTVERSION%
ECHO Boost Include: %BOOSTPATH%
ECHO Boost Library: %BOOSTLIBPATH%
ECHO *******************************************************************************

ECHO # Autogenerated file, run %ME%.bat to generate> %WORKPATH%\boostpath.mak
ECHO BOOSTPATH=%BOOSTPATH%>> %WORKPATH%\boostpath.mak
ECHO BOOSTLIBPATH=%BOOSTLIBPATH%>> %WORKPATH%\boostpath.mak
ECHO BUILDTARGETPATH=->> %WORKPATH%\boostpath.mak

ECHO.
ECHO You got Boost::regex.
ECHO.
ECHO Now you need to build scintilla.
ECHO From the scintilla\win32 directory
ECHO.
ECHO   nmake -f scintilla.mak
ECHO.
GOTO :END

:BUILDERROR
ECHO.
ECHO ^<%ME%^> There was an error nuget.  Please see the messages above for details.
ECHO   * scintilla\win32\NuGet.Config
ECHO   * scintilla\win32\packages.config

:END
ENDLOCAL
