//this file is part of notepad++
//Copyright (C)2003 Don HO ( donho@altern.org )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "StaticDialog.h"
#include "RunDlg.h"
#include "FileDialog.h"
#include "Notepad_plus_msgs.h"
#include "shortcut.h"
#include "Parameters.h"
#include "Notepad_plus.h"
#ifdef MOD_RUN_REPLACE
#include "resource.h"
#endif
#ifdef MOD_RUN_HISTORY
extern void addText2Combo(const WCHAR * txt2add, HWND hCombo);	// ../../../ScitillaComponent/FindReplaceDlg.cpp
#endif


void Command::extractArgs(TCHAR *cmd2Exec, TCHAR *args, const TCHAR *cmdEntier)
{
	size_t i = 0;
	bool quoted = false;
	for (size_t len = lstrlen(cmdEntier); i < len ; ++i)
	{
		if ((cmdEntier[i] == ' ') && (!quoted))
			break;
		if (cmdEntier[i]=='"')
			quoted = !quoted;

		cmd2Exec[i] = cmdEntier[i];
	}
	cmd2Exec[i] = '\0';
	
	if (i < size_t(lstrlen(cmdEntier)))
	{
		for (size_t len = size_t(lstrlen(cmdEntier)); (i < len) && (cmdEntier[i] == ' ') ; ++i);
		if (i < size_t(lstrlen(cmdEntier)))
		{
			for (size_t k = 0, len2 = size_t(lstrlen(cmdEntier)); i <= len2; ++i, ++k)
			{
				args[k] = cmdEntier[i];
			}
		}

		int l = lstrlen(args);
		if (args[l-1] == ' ')
		{
			for (l -= 2 ; (l > 0) && (args[l] == ' ') ; l--);
			args[l+1] = '\0';
		}

	}
	else
		args[0] = '\0';
}


#ifdef MOD_BASH_ON_WINDOWS // 59D335E0
 #define BASH_PATH -1
 #if _M_X64
  static const WCHAR bashPath[] = L"bash";
 #else // x86
  static const WCHAR bashPath[] = LR"(C:\Windows\sysnative\bash.exe)";
 #endif
#endif
int whichVar(TCHAR *str)
{
	if (!lstrcmp(fullCurrentPath, str))
		return FULL_CURRENT_PATH;
	else if (!lstrcmp(currentDirectory, str))
		return CURRENT_DIRECTORY;
	else if (!lstrcmp(onlyFileName, str))
		return FILE_NAME;
	else if (!lstrcmp(fileNamePart, str))
		return NAME_PART;
	else if (!lstrcmp(fileExtPart, str))
		return EXT_PART;
	else if (!lstrcmp(currentWord, str))
		return CURRENT_WORD;
	else if (!lstrcmp(nppDir, str))
		return NPP_DIRECTORY;
	else if (!lstrcmp(nppFullFilePath, str))
		return NPP_FULL_FILE_PATH;
	else if (!lstrcmp(currentLine, str))
		return CURRENT_LINE;
	else if (!lstrcmp(currentColumn, str))
		return CURRENT_COLUMN;
#ifdef MOD_BASH_ON_WINDOWS // 59D335E0
	else if (!lstrcmp(str, L"BASH"))
		return BASH_PATH;
#endif

	return VAR_NOT_RECOGNIZED;
}

// Since I'm sure the length will be 256, I won't check the lstrlen : watch out!
void expandNppEnvironmentStrs(const TCHAR *strSrc, TCHAR *stringDest, size_t strDestLen, HWND hWnd)
{
	size_t j = 0;
	for (int i = 0, len = lstrlen(strSrc); i < len; ++i)
	{
		int iBegin = -1;
		int iEnd = -1;
		if ((strSrc[i] == '$') && (strSrc[i+1] == '('))
		{
			iBegin = i += 2;
			for (size_t len2 = size_t(lstrlen(strSrc)); size_t(i) < len2 ; ++i)
			{
				if (strSrc[i] == ')')
				{
					iEnd = i - 1;
					break;
				}
			}
		}
		if (iBegin != -1)
		{
			if (iEnd != -1)
			{
#ifdef MOD_BASH_ON_WINDOWS // 59D335E0
				static const int FLAG_SLASH = 1;
				static const int FLAG_BACKSLASH = 2;
				static const int FLAG_DRIVE = 4;
				int flag = 0;
				int k = iBegin;
				for ( ; k <= iEnd; ++k) {
					WCHAR c = strSrc[k];
					     if (c == '/')  flag |= FLAG_SLASH;	// \ --> /
					else if (c == '\\') flag |= FLAG_BACKSLASH;	// \ --> \\ .
					else if (c == ':')  flag |= FLAG_DRIVE;	// C: --> /mnt/c
					else break;
				}
#endif
				TCHAR str[MAX_PATH];
				int m = 0;
#ifdef MOD_BASH_ON_WINDOWS // 59D335E0
				for ( ; k <= iEnd ; ++k)
#else
				for (int k = iBegin  ; k <= iEnd ; ++k)
#endif
					str[m++] = strSrc[k];
				str[m] = '\0';

				int internalVar = whichVar(str);
				if (internalVar == VAR_NOT_RECOGNIZED)
				{
					i = iBegin - 2;
					if (j < (strDestLen-1))
						stringDest[j++] = strSrc[i];
					else
						break;
				}
				else
				{
					TCHAR expandedStr[CURRENTWORD_MAXLENGTH];
					if (internalVar == CURRENT_LINE || internalVar == CURRENT_COLUMN)
					{
						auto lineNumber = ::SendMessage(hWnd, RUNCOMMAND_USER + internalVar, 0, 0);
						wsprintf(expandedStr, TEXT("%d"), lineNumber);
					}
#ifdef MOD_BASH_ON_WINDOWS // 59D335E0
					else if (internalVar == BASH_PATH)
						wcscpy(expandedStr, bashPath);
#endif
					else
						::SendMessage(hWnd, RUNCOMMAND_USER + internalVar, CURRENTWORD_MAXLENGTH, reinterpret_cast<LPARAM>(expandedStr));

#ifdef MOD_BASH_ON_WINDOWS // 59D335E0
					std::wstring ws;
					const WCHAR *bx = expandedStr;
					if (flag & FLAG_DRIVE) {
						//   'C:\Users\zxcv\1.txt' --> '//mnt/c\Users\zxcv\1.txt'
						const WCHAR wc = bx[0];
						if (isalpha(wc)/*(L'A' <= wc && wc <= L'Z' || L'a' <= wc && wc <= L'z')*/
						 && bx[1] == L':'
						 && bx[2] == L'\\') {
							bx += 2;
							ws.append(L"/mnt/");
							ws.push_back(wtolower(wc));
							flag |= FLAG_SLASH;	// (^_^)
						}
					}
					for ( ; *bx; ++bx)
						if (*bx == L'\\') {
							     if (flag & FLAG_SLASH)     ws.append(L"/");
							else if (flag & FLAG_BACKSLASH) ws.append(L"\\\\");
							else                            ws.push_back(*bx);
						} else {
							ws.push_back(*bx);
						}
					const int a = (int)((strDestLen-1) - j);
					const int b = (int)ws.length();
					const int n = min(a, b);
					wcsncpy(&stringDest[j], ws.c_str(), n);
					j += n;
#else
					for (size_t p = 0, len3 = size_t(lstrlen(expandedStr)); p < len3; ++p)
					{
						if (j < (strDestLen-1))
							stringDest[j++] = expandedStr[p];
						else
							break;
					}
#endif
				}
			}
			else
			{
				i = iBegin - 2;
				if (j < (strDestLen-1))
					stringDest[j++] = strSrc[i];
				else
					break;
			}
		}
		else
			if (j < (strDestLen-1))
				stringDest[j++] = strSrc[i];
			else
				break;
	}
	stringDest[j] = '\0';
}

#ifdef MOD_RUN_REPLACE
__declspec(noinline) static void expandNppEnvironmentStrs(std::wstring &str, HWND hWnd)
{
	const int MAX_CMDLINE = 8191;	// Windows XP~
 //	const int MAX_CMDLINE = 2047;	// ~Windows 2000

	WCHAR *ws = new WCHAR[MAX_CMDLINE + 1];
	expandNppEnvironmentStrs(str.c_str(), ws, MAX_CMDLINE + 1, hWnd);
	str.assign(ws);
	delete[] ws;
}
#endif
HINSTANCE Command::run(HWND hWnd)
{
#ifdef MOD_RUN_REPLACE
	if (_cmdLine[0] == L'|' || _cmdLine[0] == L'`') {
		const WCHAR * cmdLine = _cmdLine.c_str() + 1;
		while (*cmdLine == L' ') ++cmdLine;

		ScintillaEditView * _pEditView = (ScintillaEditView *)::SendMessage(hWnd, NPPM_INTERNAL_PEDITVIEW, 0, 0);
		const Sci_Position selectionStart = (Sci_Position) _pEditView->execute(SCI_GETSELECTIONSTART);
		const Sci_Position selectionEnd   = (Sci_Position) _pEditView->execute(SCI_GETSELECTIONEND);
		const int selectionLength = selectionEnd - selectionStart;

		// Get the current file's directory
		WCHAR currentDir[MAX_PATH];
		::SendMessage(hWnd, NPPM_GETCURRENTDIRECTORY, _countof(currentDir), (LPARAM)currentDir);

		// Temporary files
		WCHAR tmpDir[MAX_PATH];
		::GetTempPathW(_countof(tmpDir), tmpDir);

		std::wstring tmpInput  = tmpDir; tmpInput  += L"N++0";	// < %TMP%N++0
		std::wstring tmpOutput = tmpDir; tmpOutput += L"N++1";	// > %TMP%N++1

		::DeleteFileW(tmpInput.c_str());
		::DeleteFileW(tmpOutput.c_str());

		// Save selected text to temporary file
		if (selectionLength) {
			const Sci_Position gap = (Sci_Position)_pEditView->execute(SCI_GETGAPPOSITION);
			const char * const part1body = (const char *)_pEditView->execute(SCI_GETRANGEPOINTER,   0, 0);	//to get characters directly from Scintilla buffer
			const char * const part2body = (const char *)_pEditView->execute(SCI_GETRANGEPOINTER, gap, 0);	//to get characters directly from Scintilla buffer
			const int selection1Start = selectionStart;
			const int selection2Start = max(0, selectionStart - gap);
			const int range1Length = std::clamp<int>(gap - selectionStart, 0, selectionLength);
			const int range2Length = selectionLength - range1Length;
			FILE *fp = _wfopen(tmpInput.c_str(), L"wb");
			if (range1Length > 0) fwrite(part1body + selection1Start, 1, range1Length, fp);
			if (range2Length > 0) fwrite(part2body + selection2Start, 1, range2Length, fp);
			fclose(fp);
		}
		else
			tmpInput = L"NUL";

		// Command string
		std::wstring cmd2Exec;
	/*	cmd2Exec += L"cmd.exe /C ";	*/
		cmd2Exec += cmdLine;
	/*	ExpandEnvironmentStrings(cmd2Exec);	*/
		expandNppEnvironmentStrs(cmd2Exec, hWnd);

		// Execute the command
		SECURITY_ATTRIBUTES sa = { sizeof(SECURITY_ATTRIBUTES) };
		 sa.bInheritHandle = TRUE;
		STARTUPINFO si = { sizeof(STARTUPINFO) };
		 si.dwFlags = STARTF_USESTDHANDLES;
		 si.hStdInput  = ::CreateFileW(tmpInput.c_str(),  GENERIC_READ,  FILE_SHARE_READ,  &sa, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
		 si.hStdOutput = ::CreateFileW(tmpOutput.c_str(), GENERIC_WRITE, FILE_SHARE_WRITE, &sa, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
		PROCESS_INFORMATION pi = {};
		HINSTANCE res
			= ::CreateProcessW(NULL, (LPWSTR)cmd2Exec.c_str(), NULL, NULL, TRUE, 0/*!CREATE_NO_WINDOW*/
					, NULL, currentDir, &si, &pi)
			? (HINSTANCE)33 : (HINSTANCE)0;
		::CloseHandle(pi.hThread);
		::WaitForSingleObject(pi.hProcess, INFINITE);
		auto error = ::GetLastError();
		if (error != 0)
			res = (HINSTANCE)0;
		::CloseHandle(pi.hProcess);
		::CloseHandle(si.hStdOutput);
		::CloseHandle(si.hStdInput);

		// Replace text
		if ((int)res > 32) {
			std::string text = getFileContent(tmpOutput.c_str());
			if (_cmdLine[0] == L'`') // 59EA2831 chomp
				while (! text.empty() && (text.back() == L'\r'|| text.back() == L'\n'))
					text.pop_back();
			if (text.length()) {
				const int firstVisibleDisplayLine = (int)_pEditView->execute(SCI_GETFIRSTVISIBLELINE);	// 59D49476
				_pEditView->execute(SCI_SETTARGETRANGE, selectionStart, selectionEnd);
				_pEditView->execute(SCI_REPLACETARGET, text.length(), (LPARAM)text.c_str());
				_pEditView->execute(SCI_SETCURRENTPOS, selectionStart + text.length());
				_pEditView->execute(SCI_CHOOSECARETX);
				const int lineStart = (int)_pEditView->execute(SCI_LINEFROMPOSITION, selectionStart);
				const int lineEnd = (int)_pEditView->execute(SCI_LINEFROMPOSITION, selectionStart + text.length() - 1);
				_pEditView->execute(SCI_SETFIRSTVISIBLELINE, firstVisibleDisplayLine);	// 59D49476
				_pEditView->execute(SCI_ENSURERANGEVISIBLE, lineStart, lineEnd + 1);	// 59D49476
			}
			else {
				::MessageBeep(0xFFFFFFFF);
			}
		}
		else {
			::MessageBeep(0xFFFFFFFF);
		}

		::DeleteFileW(tmpInput.c_str());
		::DeleteFileW(tmpOutput.c_str());

		_pEditView->getFocus();	// ORZ  ClipboardHistoryPanel focus
		return res;
	}
	else if (_cmdLine[0] == L'!') { // 59EA2831
		const WCHAR * cmdLine = _cmdLine.c_str() + 1;
		while (*cmdLine == L' ') ++cmdLine;

		// Get the current file's directory
		WCHAR currentDir[MAX_PATH];	// notepad++.exe directory
		::SendMessage(hWnd, NPPM_GETCURRENTDIRECTORY, _countof(currentDir), (LPARAM)currentDir);

		WCHAR cmdPure[MAX_PATH];
		WCHAR args[MAX_PATH];

		extractArgs(cmdPure, args, cmdLine);
		std::wstring cmd2Exec  = cmdPure;
		std::wstring args2Exec = args;
	/*	ExpandEnvironmentStrings(cmd2Exec);	*/
	/*	ExpandEnvironmentStrings(args2Exec);	*/
		expandNppEnvironmentStrs(cmd2Exec, hWnd);
		expandNppEnvironmentStrs(args2Exec, hWnd);

		HINSTANCE res = ::ShellExecuteW(hWnd, L"open", cmd2Exec.c_str(), args2Exec.c_str(), currentDir, SW_SHOW);
		return res;
	}
	else
	{
		WCHAR cmdPure[MAX_PATH];
		WCHAR args[MAX_PATH];

		extractArgs(cmdPure, args, _cmdLine.c_str());
		std::wstring cmd2Exec  = cmdPure;
		std::wstring args2Exec = args;
		ExpandEnvironmentStrings(cmd2Exec);
		ExpandEnvironmentStrings(args2Exec);
		expandNppEnvironmentStrs(cmd2Exec, hWnd);
		expandNppEnvironmentStrs(args2Exec, hWnd);

		HINSTANCE res = ::ShellExecuteW(hWnd, L"open", cmd2Exec.c_str(), args2Exec.c_str(), L".", SW_SHOW);
		return res;
	}
#else // MOD_RUN_REPLACE
	const int argsIntermediateLen = MAX_PATH*2;
	const int args2ExecLen = CURRENTWORD_MAXLENGTH+MAX_PATH*2;

	TCHAR cmdPure[MAX_PATH];
	TCHAR cmdIntermediate[MAX_PATH];
	TCHAR cmd2Exec[MAX_PATH];
	TCHAR args[MAX_PATH];
	TCHAR argsIntermediate[argsIntermediateLen];
	TCHAR args2Exec[args2ExecLen];

	extractArgs(cmdPure, args, _cmdLine.c_str());
	int nbTchar = ::ExpandEnvironmentStrings(cmdPure, cmdIntermediate, MAX_PATH);
	if (!nbTchar)
		lstrcpy(cmdIntermediate, cmdPure);
	else if (nbTchar >= MAX_PATH)
		cmdIntermediate[MAX_PATH-1] = '\0';

	nbTchar = ::ExpandEnvironmentStrings(args, argsIntermediate, argsIntermediateLen);
	if (!nbTchar)
		lstrcpy(argsIntermediate, args);
	else if (nbTchar >= argsIntermediateLen)
		argsIntermediate[argsIntermediateLen-1] = '\0';

	expandNppEnvironmentStrs(cmdIntermediate, cmd2Exec, MAX_PATH, hWnd);
	expandNppEnvironmentStrs(argsIntermediate, args2Exec, args2ExecLen, hWnd);

	HINSTANCE res = ::ShellExecute(hWnd, TEXT("open"), cmd2Exec, args2Exec, TEXT("."), SW_SHOW);

	// As per MSDN (https://msdn.microsoft.com/en-us/library/windows/desktop/bb762153(v=vs.85).aspx)
	// If the function succeeds, it returns a value greater than 32.
	// If the function fails, it returns an error value that indicates the cause of the failure.
	int retResult = reinterpret_cast<int>(res);
	if (retResult <= 32)
	{
		generic_string errorMsg;
		errorMsg += GetLastErrorAsString(retResult);
		errorMsg += TEXT("An attempt was made to execute the below command.");
		errorMsg += TEXT("\n----------------------------------------------------------");
		errorMsg += TEXT("\nCommand: ");
		errorMsg += cmd2Exec;
		errorMsg += TEXT("\nArguments: ");
		errorMsg += args2Exec;
		errorMsg += TEXT("\nError Code: ");
		errorMsg += intToString(retResult);
		errorMsg += TEXT("\n----------------------------------------------------------");

		::MessageBox(hWnd, errorMsg.c_str(), TEXT("ShellExecute - ERROR"), MB_ICONINFORMATION | MB_APPLMODAL);
	}

	return res;
#endif // MOD_RUN_REPLACE
}

INT_PTR CALLBACK RunDlg::run_dlgProc(UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message) 
	{
		case NPPM_INTERNAL_FINDKEYCONFLICTS:
		{
			return ::SendMessage(_hParent, message, wParam, lParam);
		}

#ifdef ADD_BY_JOJO // CB_SETDROPPEDWIDTH
		case WM_INITDIALOG:
		{
			RECT r;
			::GetWindowRect(_hSelf, &r);
			const int RIGHT = r.right;
			HWND combo = ::GetDlgItem(_hSelf, IDC_COMBO_RUN_PATH);
			::GetWindowRect(combo, &r);
			::SendMessage(combo, CB_SETDROPPEDWIDTH, RIGHT - r.left, 0);
			::SendMessage(combo, CB_SETCURSEL, 0, 0);
			return TRUE;
		}
#endif
		case WM_COMMAND : 
		{
			switch (wParam)
			{
				case IDCANCEL :
					display(false);
					return TRUE;
				
				case IDOK :
				{
					TCHAR cmd[MAX_PATH];
					::GetDlgItemText(_hSelf, IDC_COMBO_RUN_PATH, cmd, MAX_PATH);
					_cmdLine = cmd;

					HINSTANCE hInst = run(_hParent);
					if (int(hInst) > 32)
					{
#ifdef MOD_RUN_HISTORY
						addText2Combo(_cmdLine.c_str(), ::GetDlgItem(_hSelf, IDC_COMBO_RUN_PATH));	// CB_INSERTSTRING, 0
#else
						addTextToCombo(_cmdLine.c_str());
#endif
						display(false);
					}
					else
					{
						removeTextFromCombo(_cmdLine.c_str());
					}
					return TRUE;
				}

				case IDC_BUTTON_SAVE :
				{
					std::vector<UserCommand> & theUserCmds = (NppParameters::getInstance())->getUserCommandList();

					int nbCmd = static_cast<int32_t>(theUserCmds.size());

					int cmdID = ID_USER_CMD + nbCmd;
					TCHAR cmd[MAX_PATH];
					::GetDlgItemText(_hSelf, IDC_COMBO_RUN_PATH, cmd, MAX_PATH);
					UserCommand uc(Shortcut(), cmd, cmdID);
					uc.init(_hInst, _hSelf);

					if (uc.doDialog() != -1)
					{
						HMENU mainMenu = reinterpret_cast<HMENU>(::SendMessage(_hParent, NPPM_INTERNAL_GETMENU, 0, 0));
						HMENU hRunMenu = ::GetSubMenu(mainMenu, MENUINDEX_RUN);
						int const posBase = 2;
						
						if (nbCmd == 0)
							::InsertMenu(hRunMenu, posBase - 1, MF_BYPOSITION, static_cast<unsigned int>(-1), 0);
						
						theUserCmds.push_back(uc);
						::InsertMenu(hRunMenu, posBase + nbCmd, MF_BYPOSITION, cmdID, uc.toMenuItemString().c_str());

						NppParameters* nppParams = NppParameters::getInstance();
                        if (nbCmd == 0)
                        {
                            // Insert the separator and modify/delete command
							::InsertMenu(hRunMenu, posBase + nbCmd + 1, MF_BYPOSITION, static_cast<unsigned int>(-1), 0);
							NativeLangSpeaker *pNativeLangSpeaker = nppParams->getNativeLangSpeaker();
							generic_string nativeLangShortcutMapperMacro = pNativeLangSpeaker->getNativeLangMenuString(IDM_SETTING_SHORTCUT_MAPPER_MACRO);
							if (nativeLangShortcutMapperMacro == TEXT(""))
								nativeLangShortcutMapperMacro = TEXT("Modify Shortcut/Delete Command...");

							::InsertMenu(hRunMenu, posBase + nbCmd + 2, MF_BYCOMMAND, IDM_SETTING_SHORTCUT_MAPPER_RUN, nativeLangShortcutMapperMacro.c_str());
                        }
						nppParams->getAccelerator()->updateShortcuts();
						nppParams->setShortcutDirty();
					}
					return TRUE;
				}

				case IDC_BUTTON_FILE_BROWSER :
				{
					FileDialog fd(_hSelf, _hInst);
					fd.setExtFilter(TEXT("Executable file : "), TEXT(".exe"), TEXT(".com"), TEXT(".cmd"), TEXT(".bat"), NULL);
					fd.setExtFilter(TEXT("All files : "), TEXT(".*"), NULL);

					if (const TCHAR *fn = fd.doOpenSingleFileDlg())
					{
						if(wcschr(fn, ' ') != NULL)
						{
							generic_string fn_quotes(fn);
							fn_quotes = TEXT("\"") + fn_quotes + TEXT("\"");
							addTextToCombo(fn_quotes.c_str());
						}
						else
						{
							addTextToCombo(fn);
						}
					}
					return TRUE;
				}

				default :
					break;
			}
		}
	}
	return FALSE;	
}

void RunDlg::addTextToCombo(const TCHAR *txt2Add) const
{
	HWND handle = ::GetDlgItem(_hSelf, IDC_COMBO_RUN_PATH);
	auto i = ::SendMessage(handle, CB_FINDSTRINGEXACT, static_cast<WPARAM>(-1), reinterpret_cast<LPARAM>(txt2Add));
	if (i == CB_ERR)
		i = ::SendMessage(handle, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(txt2Add));
	::SendMessage(handle, CB_SETCURSEL, i, 0);
}
void RunDlg::removeTextFromCombo(const TCHAR *txt2Remove) const
{
	HWND handle = ::GetDlgItem(_hSelf, IDC_COMBO_RUN_PATH);
	auto i = ::SendMessage(handle, CB_FINDSTRINGEXACT, static_cast<WPARAM>(-1), reinterpret_cast<LPARAM>(txt2Remove));
	if (i == CB_ERR)
		return;
	::SendMessage(handle, CB_DELETESTRING, i, 0);
}

void RunDlg::doDialog(bool isRTL)
{
	if (!isCreated()) {
		create(IDD_RUN_DLG, isRTL);
#ifdef MOD_RUN_HISTORY
		fillRunHistory();
#endif
	}

    // Adjust the position in the center
	goToCenter();
	::SetFocus(::GetDlgItem(_hSelf, IDC_COMBO_RUN_PATH));
};

#ifdef MOD_RUN_HISTORY
void RunDlg::fillRunHistory()
{
	RunHistory& runHistory = NppParameters::getInstance()->getRunHistory();

	for (auto it : runHistory.runHistoryCmds)
		addTextToCombo(it.c_str());
	addTextToCombo(L"cmd /C ");	// sample
	addTextToCombo(L"|cmd /C ");	// sample
	::SendMessage(::GetDlgItem(_hSelf, IDC_COMBO_RUN_PATH), CB_SETCURSEL, 0, 0); // select first item

	runHistory.runHistoryCmds.clear();
	runHistory.runHistoryCmds.shrink_to_fit();
}

void RunDlg::saveRunHistory()
{
	if (! isCreated()) return;
	RunHistory& runHistory = NppParameters::getInstance()->getRunHistory();

	HWND hCombo = ::GetDlgItem(_hSelf, IDC_COMBO_RUN_PATH);
	int count = (int) ::SendMessage(hCombo, CB_GETCOUNT, 0, 0);
	if (count == CB_ERR) return;
	count = min(count, runHistory.nbMaxRunHistory);

	runHistory.runHistoryCmds.clear();
	for (int i = 0; i < count; ++i)
	{
		int len = (int) ::SendMessageW(hCombo, CB_GETLBTEXTLEN, i, 0);
 #if _MSC_VER >= 1900 // Visual c++ 2015
		std::wstring text(len, L'\0');
		::SendMessageW(hCombo, CB_GETLBTEXT, i, (LPARAM)&text[0]);
 #else
		std::wstring text(len + 1, L'\0');
		::SendMessageW(hCombo, CB_GETLBTEXT, i, (LPARAM)&text[0]);
		text.pop_back();	// remove '\0'
 #endif
		runHistory.runHistoryCmds.push_back(text);
	}
}
#endif // MOD_RUN_HISTORY
