REM (c)2017 Hamoschugel
Option Explicit

Dim FileSystem: Set FileSystem = CreateObject("Scripting.FileSystemObject")

Dim PACKAGEPATH, BOOSTVERSION, BOOSTPATH, BOOSTLIBPATH
Dim ADDRESSMODEL: ADDRESSMODEL = WScript.Arguments(0)
 If ADDRESSMODEL = "" Then WScript.Quit(1)

Dim config

Dim fp
Set fp = FileSystem.OpenTextFile("NuGet.Config", 1)
config = config & fp.ReadAll
fp.Close
Set fp = FileSystem.OpenTextFile("packages.config", 1)
config = config & fp.ReadAll
fp.Close
Set fp = Nothing

Dim RegExp: Set RegExp = New RegExp
Dim m

RegExp.Pattern = "<add key=""repositoryPath"" value=""(.+?)"""
For Each m In RegExp.Execute(config)
  PACKAGEPATH = m.SubMatches(0)
Next
RegExp.Pattern = "<package id=""boost"" version=""(.+?)"""
For Each m In RegExp.Execute(config)
  BOOSTVERSION = m.SubMatches(0)
Next
RegExp.Pattern = "<package id=""(boost)"" version=""(.+?)"" targetFramework=""(.+?)"""
For Each m In RegExp.Execute(config)
  BOOSTPATH = m.SubMatches(0) & "." & m.SubMatches(1) & "\lib\" & m.SubMatches(2) & "\include"
Next
RegExp.Pattern = "<package id=""(boost_regex-.+?)"" version=""(.+?)"" targetFramework=""(.+?)"""
For Each m In RegExp.Execute(config)
  BOOSTLIBPATH = m.SubMatches(0) & "." & m.SubMatches(1) & "\lib\" & m.SubMatches(2)
Next

If PACKAGEPATH  = "" Then WScript.Quit(1)
If BOOSTVERSION = "" Then WScript.Quit(1)
If BOOSTPATH    = "" Then WScript.Quit(1)
if BOOSTLIBPATH = "" Then WScript.Quit(1)

PACKAGEPATH  = FileSystem.GetAbsolutePathName(PACKAGEPATH)
BOOSTPATH    = PACKAGEPATH & "\" & BOOSTPATH
BOOSTLIBPATH = PACKAGEPATH & "\" & BOOSTLIBPATH & "\" & ADDRESSMODEL & "\lib"
WScript.Echo "SET PACKAGEPATH=" & PACKAGEPATH
WScript.Echo "SET BOOSTVERSION=" & BOOSTVERSION
WScript.Echo "SET BOOSTPATH=" & BOOSTPATH
WScript.Echo "SET BOOSTLIBPATH=" & BOOSTLIBPATH
WScript.Quit(0)
