package jp.sourceforge.larch.core.command
{
    /**
     * コマンド基底クラス
     * @author tdott&lt;tdott@users.sourceforge.jp&gt;
     */
    public class Command
    {
        /**
         * コンストラクタ
         * @param aTarget 結果の設定先
         * @param aTargetProperty 結果の設定先のプロパティ名
         */
        public function Command(aTarget:Object = null, aTargetProperty:String = null)
        {
            super();
            target = aTarget;
            targetProperty = aTargetProperty;
        }

        /** 次に実行するコマンド */
        public var nextCommand:Command;

        /** 結果の設定先 */
        private var target:Object;

        /** 結果の設定先プロパティ */
        private var targetProperty:String;

        /**
         * コンストラクタで指定した結果の設定先に結果を設定します。
         * @param value 結果
         */
        protected function set resultValue(value:Object):void
        {
            if(target != null)
                target[targetProperty] = value;
        }

        /**
         * コマンドを実行します。
         * サブクラスにて実装してください。
         */
        public function execute():void
        {
            throw new Error("doExecuteメソッドを実装してください。");
        }
    }
}