/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util.jdbc.cluster;

import com.lavans.util.Logger;
import com.lavans.util.jdbc.cluster.CalledMethod;
import com.lavans.util.jdbc.cluster.ClusterCallableStatement;
import com.lavans.util.jdbc.cluster.ClusterConnectionPool;
import com.lavans.util.jdbc.cluster.ClusterPreparedStatement;
import com.lavans.util.jdbc.cluster.ClusterStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClusterConnection
implements Connection {
    private static final String MSG_WARN_SWITCH_DB = "\u969c\u5bb3\u304c\u51fa\u305f\u306e\u3067\u63a5\u7d9a\u5148\u3092\u5207\u308a\u66ff\u3048\u307e\u3059\u3002";
    private static final String MSG_ERR_RECREATE = "Statement\u306e\u518d\u751f\u6210\u306b\u5931\u6557\u3002";
    private Connection con = null;
    private ClusterConnectionPool pool = null;
    private List methodList = null;
    private List statementList = null;
    private Map statementMap = null;
    protected static Logger logger = Logger.getInstance();

    public ClusterConnection(Connection con, ClusterConnectionPool pool) {
        this.con = con;
        this.pool = pool;
        this.methodList = new ArrayList();
        this.statementList = new ArrayList();
        this.statementMap = new HashMap();
    }

    public void init() {
        this.methodList.clear();
        this.statementList.clear();
        this.statementMap.clear();
    }

    private Object clusterCall(String methodName, Object[] args, boolean saveMethod) throws SQLException {
        return this.clusterCall(new CalledMethod(methodName, args), saveMethod);
    }

    private Object clusterCall(CalledMethod calledMethod, boolean saveMethod) throws SQLException {
        logger.enteringTool();
        logger.debugTool(calledMethod.toString());
        Object result = null;
        try {
            result = calledMethod.invoke(this.con);
        }
        catch (Exception e) {
            try {
                logger.err(MSG_WARN_SWITCH_DB + e.getCause().getMessage());
            }
            catch (Exception e2) {
                logger.err(MSG_WARN_SWITCH_DB + e.getMessage());
            }
            try {
                this.con.close();
            }
            catch (SQLException e2) {
                // empty catch block
            }
            this.con = this.pool.getAnotherConnection(this);
            try {
                int i = 0;
                while (i < this.methodList.size()) {
                    CalledMethod method = (CalledMethod)this.methodList.get(i);
                    method.invoke(this.con);
                    ++i;
                }
                i = 0;
                while (i < this.statementList.size()) {
                    ClusterStatement cst = (ClusterStatement)this.statementList.get(i);
                    CalledMethod method = (CalledMethod)this.statementMap.get(cst);
                    Statement st = (Statement)method.invoke(this.con);
                    cst.reupdateStatement(st);
                    ++i;
                }
                result = calledMethod.invoke(this.con);
            }
            catch (Exception e2) {
                logger.exitingTool();
                throw new SQLException(e2.getMessage());
            }
        }
        if (saveMethod) {
            this.methodList.add(calledMethod);
        }
        logger.exitingTool();
        return result;
    }

    public void remove(Statement st) {
        this.statementMap.remove(st);
    }

    public void notifyError(ClusterStatement src) throws SQLException {
        try {
            this.con.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.con = this.pool.getAnotherConnection(this);
            int i = 0;
            while (i < this.methodList.size()) {
                CalledMethod method = (CalledMethod)this.methodList.get(i);
                method.invoke(this.con);
                ++i;
            }
            i = 0;
            while (i < this.statementList.size()) {
                ClusterStatement cst = (ClusterStatement)this.statementList.get(i);
                if (src != cst) {
                    CalledMethod method = (CalledMethod)this.statementMap.get(cst);
                    Statement st = (Statement)method.invoke(this.con);
                    cst.reupdateStatement(st);
                }
                ++i;
            }
            CalledMethod method = (CalledMethod)this.statementMap.get(src);
            Statement st = (Statement)method.invoke(this.con);
            src.reupdateStatement(st);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    public Statement createStatement() throws SQLException {
        CalledMethod method = new CalledMethod("createStatement", null);
        Statement st = (Statement)this.clusterCall(method, false);
        ClusterStatement cst = new ClusterStatement(this, st);
        if (!this.getAutoCommit()) {
            this.statementList.add(cst);
        }
        this.statementMap.put(cst, method);
        return cst;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Object[] args = new Object[]{new Integer(resultSetType), new Integer(resultSetConcurrency)};
        CalledMethod method = new CalledMethod("createStatement", args);
        Statement st = (Statement)this.clusterCall(method, false);
        ClusterStatement cst = new ClusterStatement(this, st);
        if (!this.getAutoCommit()) {
            this.statementList.add(cst);
        }
        this.statementMap.put(cst, method);
        return cst;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Object[] args = new Object[]{new Integer(resultSetType), new Integer(resultSetConcurrency), new Integer(resultSetHoldability)};
        CalledMethod method = new CalledMethod("createStatement", args);
        Statement st = (Statement)this.clusterCall(method, false);
        ClusterStatement cst = new ClusterStatement(this, st);
        if (!this.getAutoCommit()) {
            this.statementList.add(cst);
        }
        this.statementMap.put(cst, method);
        return cst;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return new ClusterCallableStatement(this, this.con.prepareCall(sql));
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ClusterCallableStatement(this, this.con.prepareCall(sql, resultSetType, resultSetConcurrency));
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ClusterCallableStatement(this, this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        Object[] args = new Object[]{sql};
        CalledMethod method = new CalledMethod("prepareStatement", args);
        PreparedStatement st = (PreparedStatement)this.clusterCall(method, false);
        ClusterPreparedStatement cst = new ClusterPreparedStatement(this, st);
        if (!this.getAutoCommit()) {
            this.statementList.add(cst);
        }
        this.statementMap.put(cst, method);
        return cst;
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        Object[] args = new Object[]{sql, new Integer(autoGeneratedKeys)};
        CalledMethod method = new CalledMethod("prepareStatement", args);
        PreparedStatement st = (PreparedStatement)this.clusterCall(method, false);
        ClusterPreparedStatement cst = new ClusterPreparedStatement(this, st);
        if (!this.getAutoCommit()) {
            this.statementList.add(cst);
        }
        this.statementMap.put(cst, method);
        return cst;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        Object[] args = new Object[]{sql, new Integer(resultSetType), new Integer(resultSetConcurrency)};
        CalledMethod method = new CalledMethod("prepareStatement", args);
        PreparedStatement st = (PreparedStatement)this.clusterCall(method, false);
        ClusterPreparedStatement cst = new ClusterPreparedStatement(this, st);
        if (!this.getAutoCommit()) {
            this.statementList.add(cst);
        }
        this.statementMap.put(cst, method);
        return cst;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Object[] args = new Object[]{sql, new Integer(resultSetType), new Integer(resultSetConcurrency), new Integer(resultSetHoldability)};
        CalledMethod method = new CalledMethod("prepareStatement", args);
        PreparedStatement st = (PreparedStatement)this.clusterCall(method, false);
        ClusterPreparedStatement cst = new ClusterPreparedStatement(this, st);
        if (!this.getAutoCommit()) {
            this.statementList.add(cst);
        }
        this.statementMap.put(cst, method);
        return cst;
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        Object[] args = new Object[]{sql, columnIndexes};
        CalledMethod method = new CalledMethod("prepareStatement", args);
        PreparedStatement st = (PreparedStatement)this.clusterCall(method, false);
        ClusterPreparedStatement cst = new ClusterPreparedStatement(this, st);
        if (!this.getAutoCommit()) {
            this.statementList.add(cst);
        }
        this.statementMap.put(cst, method);
        return cst;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        Object[] args = new Object[]{sql, columnNames};
        CalledMethod method = new CalledMethod("prepareStatement", args);
        PreparedStatement st = (PreparedStatement)this.clusterCall(method, false);
        ClusterPreparedStatement cst = new ClusterPreparedStatement(this, st);
        if (!this.getAutoCommit()) {
            this.statementList.add(cst);
        }
        this.statementMap.put(cst, method);
        return cst;
    }

    public int getHoldability() throws SQLException {
        return (Integer)this.clusterCall("getHoldability", null, false);
    }

    public int getTransactionIsolation() throws SQLException {
        return (Integer)this.clusterCall("getTransactionIsolation", null, false);
    }

    public void clearWarnings() throws SQLException {
        this.clusterCall("clearWarnings", null, true);
    }

    public void close() throws SQLException {
        this.clusterCall("close", null, false);
        this.methodList.clear();
        this.statementList.clear();
        this.statementMap.clear();
    }

    public void commit() throws SQLException {
        this.clusterCall("commit", null, false);
        this.statementList.clear();
        this.statementMap.clear();
    }

    public void rollback() throws SQLException {
        this.clusterCall("rollback", null, false);
        this.statementList.clear();
        this.statementMap.clear();
    }

    public boolean getAutoCommit() throws SQLException {
        return (Boolean)this.clusterCall("getAutoCommit", null, false);
    }

    public boolean isClosed() throws SQLException {
        return (Boolean)this.clusterCall("isClosed", null, false);
    }

    public boolean isReadOnly() throws SQLException {
        return (Boolean)this.clusterCall("isReadOnly", null, false);
    }

    public void setHoldability(int holdability) throws SQLException {
        this.clusterCall("setHoldability", new Object[]{new Integer(holdability)}, true);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.clusterCall("setTransactionIsolation", new Object[]{new Integer(level)}, true);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.clusterCall("setAutoCommit", new Object[]{new Boolean(autoCommit)}, true);
        this.statementList.clear();
        this.statementMap.clear();
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.clusterCall("setReadOnly", new Object[]{new Boolean(readOnly)}, true);
    }

    public String getCatalog() throws SQLException {
        return (String)this.clusterCall("getCatalog", null, false);
    }

    public void setCatalog(String setCatalog) throws SQLException {
        this.clusterCall("setCatalog", new Object[]{setCatalog}, true);
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        return (DatabaseMetaData)this.clusterCall("getMetaData", null, false);
    }

    public SQLWarning getWarnings() throws SQLException {
        return (SQLWarning)this.clusterCall("getWarnings", null, false);
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Map getTypeMap() throws SQLException {
        return (Map)this.clusterCall("getTypeMap", null, false);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.clusterCall("setTypeMap", new Object[]{map}, true);
    }

    public String nativeSQL(String sql) throws SQLException {
        return (String)this.clusterCall("nativeSQL", new Object[]{sql}, false);
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

