/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util.jdbc.cluster;

import com.lavans.util.Logger;
import com.lavans.util.jdbc.cluster.CalledMethod;
import com.lavans.util.jdbc.cluster.ClusterStatementInterface;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class ClusterResultSet
implements ResultSet {
    protected static final String MSG_WARN_SWITCH_DB = "ResultSet\u5185\u3067\u969c\u5bb3\u304c\u51fa\u305f\u306e\u3067\u63a5\u7d9a\u5148\u3092\u5207\u308a\u66ff\u3048\u307e\u3059\u3002";
    protected static final String MSG_ERR_RECREATE = "ResultSet\u306e\u518d\u751f\u6210\u306b\u5931\u6557\u3002";
    private ResultSet rs = null;
    private ClusterStatementInterface st = null;
    protected static Logger logger = Logger.getInstance();
    private List methodList = null;

    public ClusterResultSet(ClusterStatementInterface st, ResultSet rs) {
        this.st = st;
        this.rs = rs;
        this.methodList = new ArrayList();
    }

    private void setParameters(ResultSet rs) throws SQLException {
        logger.enteringTool();
        int i = 0;
        while (i < this.methodList.size()) {
            CalledMethod calledMethod = (CalledMethod)this.methodList.get(i);
            try {
                calledMethod.invoke(rs);
            }
            catch (Exception e) {
                logger.err(e);
                throw new SQLException(MSG_ERR_RECREATE);
            }
            ++i;
        }
        logger.exitingTool();
    }

    private Object clusterCall(String methodName, Object[] args) throws SQLException {
        logger.enteringTool();
        Object result = null;
        CalledMethod calledMethod = new CalledMethod(methodName, args);
        try {
            result = calledMethod.invoke(this.rs);
        }
        catch (Exception e) {
            logger.debugTool(MSG_WARN_SWITCH_DB + e.getMessage());
            try {
                this.rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.rs = this.st.getAnotherResultSet();
            try {
                this.setParameters(this.rs);
                result = calledMethod.invoke(this.rs);
            }
            catch (Exception e2) {
                throw new SQLException(e2.getMessage());
            }
        }
        this.methodList.add(calledMethod);
        logger.exitingTool();
        return result;
    }

    public int getConcurrency() throws SQLException {
        return (Integer)this.clusterCall("getConcurrency", null);
    }

    public int getFetchDirection() throws SQLException {
        return (Integer)this.clusterCall("getFetchDirection", null);
    }

    public int getFetchSize() throws SQLException {
        return (Integer)this.clusterCall("getFetchSize", null);
    }

    public int getRow() throws SQLException {
        return (Integer)this.clusterCall("getRow", null);
    }

    public int getType() throws SQLException {
        return (Integer)this.clusterCall("getType", null);
    }

    public void afterLast() throws SQLException {
        this.clusterCall("afterLast", null);
    }

    public void beforeFirst() throws SQLException {
        this.clusterCall("beforeFirst", null);
    }

    public void cancelRowUpdates() throws SQLException {
        this.clusterCall("cancelRowUpdates", null);
    }

    public void clearWarnings() throws SQLException {
        this.clusterCall("clearWarnings", null);
    }

    public void close() throws SQLException {
        this.clusterCall("close", null);
    }

    public void deleteRow() throws SQLException {
        this.clusterCall("deleteRow", null);
    }

    public void insertRow() throws SQLException {
        this.clusterCall("insertRow", null);
    }

    public void moveToCurrentRow() throws SQLException {
        this.clusterCall("moveToCurrentRow", null);
    }

    public void moveToInsertRow() throws SQLException {
        this.clusterCall("moveToInsertRow", null);
    }

    public void refreshRow() throws SQLException {
        this.clusterCall("refreshRow", null);
    }

    public void updateRow() throws SQLException {
        this.clusterCall("updateRow", null);
    }

    public boolean first() throws SQLException {
        return (Boolean)this.clusterCall("first", null);
    }

    public boolean isAfterLast() throws SQLException {
        return (Boolean)this.clusterCall("isAfterLast", null);
    }

    public boolean isBeforeFirst() throws SQLException {
        return (Boolean)this.clusterCall("isBeforeFirst", null);
    }

    public boolean isFirst() throws SQLException {
        return (Boolean)this.clusterCall("isFirst", null);
    }

    public boolean isLast() throws SQLException {
        return (Boolean)this.clusterCall("isLast", null);
    }

    public boolean last() throws SQLException {
        return (Boolean)this.clusterCall("last", null);
    }

    public boolean next() throws SQLException {
        return (Boolean)this.clusterCall("next", null);
    }

    public boolean previous() throws SQLException {
        return (Boolean)this.clusterCall("previos", null);
    }

    public boolean rowDeleted() throws SQLException {
        return (Boolean)this.clusterCall("rowDeleted", null);
    }

    public boolean rowInserted() throws SQLException {
        return (Boolean)this.clusterCall("rowInserted", null);
    }

    public boolean rowUpdated() throws SQLException {
        return (Boolean)this.clusterCall("rowUpdated", null);
    }

    public boolean wasNull() throws SQLException {
        return (Boolean)this.clusterCall("wasNull", null);
    }

    public byte getByte(int columnIndex) throws SQLException {
        return (Byte)this.clusterCall("getByte", null);
    }

    public double getDouble(int columnIndex) throws SQLException {
        return (Double)this.clusterCall("getDouble", null);
    }

    public float getFloat(int columnIndex) throws SQLException {
        return ((Float)this.clusterCall("getFloat", null)).floatValue();
    }

    public int getInt(int columnIndex) throws SQLException {
        return (Integer)this.clusterCall("getInt", new Object[]{new Integer(columnIndex)});
    }

    public long getLong(int columnIndex) throws SQLException {
        return (Long)this.clusterCall("getLong", new Object[]{new Integer(columnIndex)});
    }

    public short getShort(int columnIndex) throws SQLException {
        return (Short)this.clusterCall("getShort", new Object[]{new Integer(columnIndex)});
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.clusterCall("setFetchDirection", new Object[]{new Integer(direction)});
    }

    public void setFetchSize(int rows) throws SQLException {
        this.clusterCall("getDouble", new Object[]{new Integer(rows)});
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.clusterCall("getDouble", new Object[]{new Integer(columnIndex)});
    }

    public boolean absolute(int row) throws SQLException {
        return (Boolean)this.clusterCall("absolute", new Object[]{new Integer(row)});
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return (Boolean)this.clusterCall("getBoolean", new Object[]{new Integer(columnIndex)});
    }

    public boolean relative(int rows) throws SQLException {
        return (Boolean)this.clusterCall("relative", new Object[]{new Integer(rows)});
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return (byte[])this.clusterCall("getBytes", new Object[]{new Integer(columnIndex)});
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.clusterCall("updateByte", new Object[]{new Integer(columnIndex), new Byte[x]});
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.clusterCall("updateDouble", new Object[]{new Integer(columnIndex), new Double(x)});
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.clusterCall("updateFloat", new Object[]{new Integer(columnIndex), new Float(x)});
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.clusterCall("updateInt", new Object[]{new Integer(columnIndex), new Integer(x)});
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.clusterCall("updateLong", new Object[]{new Integer(columnIndex), new Long(x)});
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.clusterCall("updateShort", new Object[]{new Integer(columnIndex), new Short(x)});
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.clusterCall("updateBoolean", new Object[]{new Integer(columnIndex), new Boolean(x)});
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.clusterCall("updateBytes", new Object[]{new Integer(columnIndex), x});
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return (InputStream)this.clusterCall("getAsciiStream", new Object[]{new Integer(columnIndex)});
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return (InputStream)this.clusterCall("getBinaryStream", new Object[]{new Integer(columnIndex)});
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return (InputStream)this.clusterCall("getUnicodeStream", new Object[]{new Integer(columnIndex)});
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.clusterCall("updateAsciiStream", new Object[]{new Integer(columnIndex), x, new Integer(length)});
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.clusterCall("updateBinaryStream", new Object[]{new Integer(columnIndex), x, new Integer(length)});
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return (Reader)this.clusterCall("getCharacterStream", new Object[]{new Integer(columnIndex)});
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.clusterCall("updateCharacterStream", new Object[]{new Integer(columnIndex), x, new Integer(length)});
    }

    public Object getObject(int columnIndex) throws SQLException {
        return this.clusterCall("getObject", new Object[]{new Integer(columnIndex)});
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.clusterCall("updateObject", new Object[]{new Integer(columnIndex), x});
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.clusterCall("updateObject", new Object[]{new Integer(columnIndex), x, new Integer(scale)});
    }

    public String getCursorName() throws SQLException {
        return (String)this.clusterCall("getCursorName", null);
    }

    public String getString(int columnIndex) throws SQLException {
        return (String)this.clusterCall("getString", new Object[]{new Integer(columnIndex)});
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.clusterCall("updateString", new Object[]{new Integer(columnIndex), x});
    }

    public byte getByte(String columnName) throws SQLException {
        return (Byte)this.clusterCall("getByte", new Object[]{columnName});
    }

    public double getDouble(String columnName) throws SQLException {
        return (Double)this.clusterCall("getDouble", new Object[]{columnName});
    }

    public float getFloat(String columnName) throws SQLException {
        return ((Float)this.clusterCall("getFloat", new Object[]{columnName})).floatValue();
    }

    public int findColumn(String columnName) throws SQLException {
        return (Integer)this.clusterCall("findColumn", new Object[]{columnName});
    }

    public int getInt(String columnName) throws SQLException {
        return (Integer)this.clusterCall("getInt", new Object[]{columnName});
    }

    public long getLong(String columnName) throws SQLException {
        return (Long)this.clusterCall("getLong", new Object[]{columnName});
    }

    public short getShort(String columnName) throws SQLException {
        return (Short)this.clusterCall("getShort", new Object[]{columnName});
    }

    public void updateNull(String columnName) throws SQLException {
        this.clusterCall("updateNull", new Object[]{columnName});
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return (Boolean)this.clusterCall("getBoolean", new Object[]{columnName});
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return (byte[])this.clusterCall("getBytes", new Object[]{columnName});
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.clusterCall("updateByte", new Object[]{columnName, new Byte(x)});
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.clusterCall("updateDouble", new Object[]{columnName, new Double(x)});
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.clusterCall("updateFloat", new Object[]{columnName, new Float(x)});
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.clusterCall("updateInt", new Object[]{columnName, new Integer(x)});
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.clusterCall("updateLong", new Object[]{columnName, new Long(x)});
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.clusterCall("updateShort", new Object[]{columnName, new Short(x)});
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.clusterCall("updateBoolean", new Object[]{columnName, new Boolean(x)});
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.clusterCall("updateBytes", new Object[]{columnName, x});
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return (BigDecimal)this.clusterCall("getBigDecimal", new Object[]{new Integer(columnIndex)});
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return (BigDecimal)this.clusterCall("getBigDecimal", new Object[]{new Integer(columnIndex), new Integer(scale)});
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.clusterCall("updateBytes", new Object[]{new Integer(columnIndex), x});
    }

    public URL getURL(int columnIndex) throws SQLException {
        return (URL)this.clusterCall("getURL", new Object[]{new Integer(columnIndex)});
    }

    public Array getArray(int i) throws SQLException {
        return (Array)this.clusterCall("getArray", new Object[]{new Integer(i)});
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.clusterCall("updateArray", new Object[]{new Integer(columnIndex), x});
    }

    public Blob getBlob(int i) throws SQLException {
        return (Blob)this.clusterCall("getBlob", new Object[]{new Integer(i)});
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.clusterCall("updateBlob", new Object[]{new Integer(columnIndex), x});
    }

    public Clob getClob(int i) throws SQLException {
        return (Clob)this.clusterCall("getClob", new Object[]{new Integer(i)});
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.clusterCall("updateClob", new Object[]{new Integer(columnIndex), x});
    }

    public Date getDate(int columnIndex) throws SQLException {
        return (Date)this.clusterCall("getDate", new Object[]{new Integer(columnIndex)});
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.clusterCall("updateDate", new Object[]{new Integer(columnIndex), x});
    }

    public Ref getRef(int i) throws SQLException {
        return (Ref)this.clusterCall("getRef", new Object[]{new Integer(i)});
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.clusterCall("updateRef", new Object[]{new Integer(columnIndex), x});
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return (ResultSetMetaData)this.clusterCall("getMetaData", null);
    }

    public SQLWarning getWarnings() throws SQLException {
        return (SQLWarning)this.clusterCall("getWarnings", null);
    }

    public Statement getStatement() throws SQLException {
        return (Statement)this.clusterCall("getStatement", null);
    }

    public Time getTime(int columnIndex) throws SQLException {
        return (Time)this.clusterCall("getTime", new Object[]{new Integer(columnIndex)});
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.clusterCall("updateTime", new Object[]{new Integer(columnIndex), x});
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)this.clusterCall("getTimestamp", new Object[]{new Integer(columnIndex)});
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.clusterCall("updateTimestamp", new Object[]{new Integer(columnIndex), x});
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return (InputStream)this.clusterCall("getAsciiStream", new Object[]{columnName});
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return (InputStream)this.clusterCall("getBinaryStream", new Object[]{columnName});
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return (InputStream)this.clusterCall("getUnicodeStream", new Object[]{columnName});
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.clusterCall("updateAsciiStream", new Object[]{columnName, x, new Integer(length)});
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.clusterCall("updateBinaryStream", new Object[]{columnName, x, new Integer(length)});
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return (Reader)this.clusterCall("getCharacterStream", new Object[]{columnName});
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.clusterCall("updateCharacterStream", new Object[]{columnName, reader, new Integer(length)});
    }

    public Object getObject(String columnName) throws SQLException {
        return this.clusterCall("getObject", new Object[]{columnName});
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.clusterCall("updateObject", new Object[]{columnName, x});
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.clusterCall("updateObject", new Object[]{columnName, x, new Integer(scale)});
    }

    public Object getObject(int i, Map map) throws SQLException {
        return this.clusterCall("getObject", new Object[]{new Integer(i), map});
    }

    public String getString(String columnName) throws SQLException {
        return (String)this.clusterCall("getString", new Object[]{columnName});
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.clusterCall("updateString", new Object[]{columnName, x});
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return (BigDecimal)this.clusterCall("getBigDecimal", new Object[]{columnName});
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return (BigDecimal)this.clusterCall("getBigDecimal", new Object[]{columnName, new Integer(scale)});
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.clusterCall("updateBigDecimal", new Object[]{columnName, x});
    }

    public URL getURL(String columnName) throws SQLException {
        return (URL)this.clusterCall("getURL", new Object[]{columnName});
    }

    public Array getArray(String columnName) throws SQLException {
        return (Array)this.clusterCall("getArray", new Object[]{columnName});
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        this.clusterCall("updateArray", new Object[]{columnName, x});
    }

    public Blob getBlob(String columnName) throws SQLException {
        return (Blob)this.clusterCall("getBlob", new Object[]{columnName});
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.clusterCall("updateBlob", new Object[]{columnName, x});
    }

    public Clob getClob(String columnName) throws SQLException {
        return (Clob)this.clusterCall("getClob", new Object[]{columnName});
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        this.clusterCall("updateClob", new Object[]{columnName, x});
    }

    public Date getDate(String columnName) throws SQLException {
        return (Date)this.clusterCall("getDate", new Object[]{columnName});
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.clusterCall("updateDate", new Object[]{columnName, x});
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return (Date)this.clusterCall("getDate", new Object[]{new Integer(columnIndex), cal});
    }

    public Ref getRef(String columnName) throws SQLException {
        return (Ref)this.clusterCall("getRef", new Object[]{columnName});
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        this.clusterCall("updateRef", new Object[]{columnName, x});
    }

    public Time getTime(String columnName) throws SQLException {
        return (Time)this.clusterCall("getTime", new Object[]{columnName});
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.clusterCall("updateTime", new Object[]{columnName, x});
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return (Time)this.clusterCall("getTime", new Object[]{new Integer(columnIndex), cal});
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return (Timestamp)this.clusterCall("getTimestamp", new Object[]{columnName});
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.clusterCall("updateTimestamp", new Object[]{columnName, x});
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return (Timestamp)this.clusterCall("getTimestamp", new Object[]{new Integer(columnIndex), cal});
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        return this.clusterCall("getObject", new Object[]{columnName, map});
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return (Date)this.clusterCall("getDate", new Object[]{columnName, cal});
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return (Time)this.clusterCall("getTime", new Object[]{columnName, cal});
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return (Timestamp)this.clusterCall("getTimestamp", new Object[]{columnName, cal});
    }
}

