/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util;

import com.lavans.util.Config;
import com.lavans.util.MethodUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class Logger {
    private static final String CLASSNAME;
    private static String configFile;
    private static final String CONFIG_SECTION = "logger";
    public static int ERR;
    public static int WARN;
    public static int LOG;
    public static int TRACE;
    public static int DEBUG;
    public static int DEBUGTOOL;
    private int logLevel = 0;
    public static final String SECONDLY = "secondly";
    public static final String MINUTELY = "minutely";
    public static final String HOURLY = "hourly";
    public static final String DAILY = "daily";
    public static final String WEEKLY = "weekly";
    public static final String MONTHLY = "monthly";
    private int rotate_term = 5;
    private StringBuffer buf = new StringBuffer();
    private DateFormat time_format = null;
    private Calendar lastLog = null;
    private int rotate = 5;
    private String logfileName = null;
    private String errfileName = null;
    private int max_indent_size = 80;
    private static Map instanceMap;
    private static final PrintWriter SYSTEM_WRITER;
    private PrintWriter logWriter;
    private PrintWriter errWriter;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.lavans.util.Logger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASSNAME = clazz.getName();
        configFile = "lavansutil.xml";
        ERR = 0;
        WARN = 1;
        LOG = 2;
        TRACE = 3;
        DEBUG = 4;
        DEBUGTOOL = 5;
        instanceMap = new HashMap();
        SYSTEM_WRITER = new PrintWriter(System.out, true);
    }

    public static void main(String[] args) {
        Logger logger = Logger.getInstance();
        logger.log("LogTest:" + new Date().toString());
        logger.err("LogTest:" + new Date().toString());
        logger.debug("LogTest:" + new Date().toString());
    }

    public static void init(String filename) {
        configFile = filename;
    }

    private Logger(String configSection) {
        String term;
        Element conf = (Element)Config.getInstance(configFile).getNode(configSection);
        if (conf == null) {
            System.out.println(this.getMethodName());
            System.out.println("Logger#<constructor>()");
            System.out.println("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb[" + configFile + "]\u306b[" + configSection + "]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
            this.time_format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
            this.logWriter = SYSTEM_WRITER;
            this.logLevel = ERR;
            return;
        }
        String format = conf.getAttribute("time_format");
        if (format.equals("")) {
            format = "yyyy/MM/dd HH:mm:ss.SSS";
        }
        this.time_format = new SimpleDateFormat(format);
        try {
            this.max_indent_size = Integer.parseInt(conf.getAttribute("max_indent_size"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String level_class = conf.getAttribute("level_class");
        if (!level_class.equals("")) {
            String[] levels = level_class.split(",");
            int i = 0;
            while (i < levels.length) {
                if (levels[i].equals("err")) {
                    ERR = i;
                }
                if (levels[i].equals("warn")) {
                    WARN = i;
                }
                if (levels[i].equals("log")) {
                    LOG = i;
                }
                if (levels[i].equals("debug")) {
                    DEBUG = i;
                }
                if (levels[i].equals("trace")) {
                    TRACE = i;
                }
                ++i;
            }
        }
        if ((term = conf.getAttribute("term")) == null || term.equals("")) {
            this.rotate_term = 5;
        } else if (SECONDLY.equals(term)) {
            this.rotate_term = 13;
        } else if (MINUTELY.equals(term)) {
            this.rotate_term = 12;
        } else if (HOURLY.equals(term)) {
            this.rotate_term = 11;
        } else if (WEEKLY.equals(term)) {
            this.rotate_term = 3;
        } else if (MONTHLY.equals(term)) {
            this.rotate_term = 2;
        }
        try {
            this.rotate = Integer.parseInt(conf.getAttribute("rotate"));
        }
        catch (Exception e) {
            this.debug("log rotate\u53d6\u5f97\u5931\u6557\u3002\u30c7\u30d5\u30a9\u30eb\u30c8" + this.rotate);
        }
        this.logfileName = conf.getAttribute("file");
        boolean isExistFile = false;
        if (this.logfileName.equals("System.out")) {
            this.logWriter = SYSTEM_WRITER;
        } else {
            isExistFile = new File(this.logfileName).exists();
            this.logWriter = this.createWriter(this.logfileName);
        }
        this.errfileName = conf.getAttribute("file_err");
        boolean isExistErrFile = false;
        if (this.errfileName.equals("")) {
            this.errWriter = null;
        } else if (this.errfileName.equals("System.out")) {
            this.errWriter = SYSTEM_WRITER;
        } else {
            isExistFile = new File(this.errfileName).exists();
            this.errWriter = this.createWriter(this.errfileName);
        }
        boolean isInitialRotate = false;
        try {
            isInitialRotate = Boolean.valueOf(conf.getAttribute("initial_rotate"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (isInitialRotate) {
            if (isExistFile) {
                this.logWriter = this.rotate(this.logWriter, this.logfileName);
            }
            if (isExistErrFile) {
                this.errWriter = this.rotate(this.errWriter, this.errfileName);
            }
        }
        this.lastLog = Calendar.getInstance();
        try {
            this.logLevel = Integer.parseInt(conf.getAttribute("level"));
        }
        catch (Exception e) {
            this.logWriter.println(String.valueOf(this.timeFormat()) + "get [level] failed. level is set to TRACE");
            this.logLevel = TRACE;
        }
    }

    private PrintWriter createWriter(String logfile) {
        PrintWriter out = null;
        try {
            FileOutputStream fileOut = new FileOutputStream(logfile, true);
            out = new PrintWriter(fileOut, true);
        }
        catch (FileNotFoundException e) {
            System.err.println("Can't open logfile.[" + logfile + "] log is set to [System.out]");
            System.err.println(e.getMessage());
            out = SYSTEM_WRITER;
        }
        return out;
    }

    public void setStream(PrintStream out) {
        this.logWriter = new PrintWriter(out);
    }

    public void setLogWriter(PrintWriter out) {
        this.logWriter = out;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public static Logger getInstance(String configSection) {
        Logger instance = (Logger)instanceMap.get(configSection);
        if (instance == null) {
            try {
                instance = new Logger(configSection);
                instanceMap.put(configSection, instance);
            }
            catch (Exception e) {
                System.out.println(MethodUtil.getMethodName(CLASSNAME));
                System.out.println("Logger#getInstance() \u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb[" + configFile + "]\u306b[" + configSection + "]\u304c\u5b58\u5728\u3057\u306a\u3044\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002");
                e.printStackTrace();
            }
        }
        return instance;
    }

    public static Logger getInstance() {
        return Logger.getInstance(CONFIG_SECTION);
    }

    private String timeFormat() {
        int lastState;
        if (this.logWriter == SYSTEM_WRITER) {
            return this.time_format.format(new Date());
        }
        Calendar now = Calendar.getInstance();
        int currentState = now.get(this.rotate_term);
        if (currentState != (lastState = this.lastLog.get(this.rotate_term))) {
            PrintWriter printWriter = this.logWriter;
            synchronized (printWriter) {
                lastState = this.lastLog.get(this.rotate_term);
                if (currentState != lastState) {
                    String rotate = "rotate field(" + this.rotate_term + ") now[" + currentState + "] last[" + lastState + "]";
                    this.lastLog = now;
                    this.logWriter = this.rotate(this.logWriter, this.logfileName);
                    this.errWriter = this.rotate(this.errWriter, this.errfileName);
                    this.logWriter.println(rotate);
                }
            }
        }
        return this.time_format.format(now.getTime());
    }

    private PrintWriter rotate(PrintWriter writer, String filename) {
        if (filename.equals("System.out") || filename.equals("") || writer == null) {
            return writer;
        }
        File file = new File(String.valueOf(filename) + "." + this.rotate);
        file.delete();
        int i = this.rotate;
        while (i > 1) {
            file = new File(String.valueOf(filename) + "." + (i - 1));
            file.renameTo(new File(String.valueOf(filename) + "." + i));
            --i;
        }
        PrintWriter oldWriter = writer;
        file = new File(filename);
        if (this.logLevel >= DEBUG) {
            System.out.println("logfile path[" + file.getAbsolutePath() + "]");
        }
        if (file.renameTo(new File(String.valueOf(filename) + ".1"))) {
            System.out.println("rotate " + filename);
        } else {
            oldWriter.close();
            if (file.renameTo(new File(String.valueOf(filename) + ".1"))) {
                System.out.println("rotate " + filename + " after close.");
            } else {
                System.out.println("rotate " + filename + " NG.");
            }
        }
        writer = this.createWriter(filename);
        this.buf.delete(0, this.buf.length());
        writer.println(String.valueOf(this.time_format.format(new Date())) + " logfile created.");
        oldWriter.close();
        return writer;
    }

    public void err(String msg) {
        this.logWriter.println(String.valueOf(this.timeFormat()) + " ERR  :" + this.buf + msg);
        if (this.errWriter != null) {
            this.errWriter.println(String.valueOf(this.timeFormat()) + " ERR  :" + this.getMethodName());
            this.errWriter.println(String.valueOf(this.timeFormat()) + " ERR  :" + msg);
        }
    }

    public void err(Throwable e) {
        this.logWriter.println(String.valueOf(this.timeFormat()) + " ERR  :" + this.buf + e.getMessage());
        e.printStackTrace(this.logWriter);
        if (this.errWriter != null) {
            this.errWriter.println(String.valueOf(this.timeFormat()) + " ERR  :" + this.getMethodName());
            e.printStackTrace(this.errWriter);
        }
    }

    public void warn(String msg) {
        if (this.logLevel < WARN) {
            return;
        }
        this.logWriter.println(String.valueOf(this.timeFormat()) + " WARN :" + this.buf + msg);
        this.logWriter.flush();
    }

    public void warn(Throwable e) {
        if (this.logLevel < WARN) {
            return;
        }
        this.logWriter.println(String.valueOf(this.timeFormat()) + " WARN :" + this.buf + e.getMessage());
        e.printStackTrace(this.logWriter);
    }

    public void log(String msg) {
        if (this.logLevel < LOG) {
            return;
        }
        this.logWriter.println(String.valueOf(this.timeFormat()) + " LOG  :" + this.buf + msg);
        this.logWriter.flush();
    }

    public void debug(byte[] msg) {
        if (this.logLevel < DEBUG) {
            return;
        }
        this.logWriter.println(String.valueOf(this.timeFormat()) + " DEBUG:" + this.buf + new String(msg));
    }

    public void debug(String msg) {
        if (this.logLevel < DEBUG) {
            return;
        }
        StringBuffer dbuf = null;
        dbuf = msg == null ? new StringBuffer(34) : new StringBuffer(30 + msg.length());
        this.logWriter.println(dbuf.append(this.timeFormat()).append(" DEBUG:").append(this.buf).append(msg));
    }

    public void debug(Throwable e) {
        if (this.logLevel < DEBUG) {
            return;
        }
        this.logWriter.println(String.valueOf(this.timeFormat()) + " DEBUG:" + this.buf + e.getMessage());
        e.printStackTrace(this.logWriter);
    }

    public void entering(String sourceClass, String sourceMethod) {
        if (this.logLevel < TRACE) {
            return;
        }
        this.logWriter.println(String.valueOf(this.timeFormat()) + " TRACE:" + this.buf + sourceClass + "#" + sourceMethod + "() ENTER");
        if (this.buf.length() < this.max_indent_size) {
            StringBuffer stringBuffer = this.buf;
            synchronized (stringBuffer) {
                this.buf.append("  ");
            }
        }
    }

    public void entering() {
        if (this.logLevel < TRACE) {
            return;
        }
        this.logWriter.println(String.valueOf(this.timeFormat()) + " TRACE:" + this.buf + this.getMethodName() + " ENTER");
        if (this.buf.length() < this.max_indent_size) {
            StringBuffer stringBuffer = this.buf;
            synchronized (stringBuffer) {
                this.buf.append("  ");
            }
        }
    }

    public void exiting(String sourceClass, String sourceMethod) {
        if (this.logLevel < TRACE) {
            return;
        }
        try {
            StringBuffer stringBuffer = this.buf;
            synchronized (stringBuffer) {
                this.buf.delete(0, 2);
            }
        }
        catch (Exception e) {
            this.buf = new StringBuffer();
        }
        this.logWriter.println(String.valueOf(this.timeFormat()) + " TRACE:" + this.buf + sourceClass + "#" + sourceMethod + "() EXIT");
    }

    public void exiting() {
        if (this.logLevel < TRACE) {
            return;
        }
        try {
            StringBuffer stringBuffer = this.buf;
            synchronized (stringBuffer) {
                this.buf.delete(0, 2);
            }
        }
        catch (Exception e) {
            this.buf = new StringBuffer();
        }
        this.logWriter.println(String.valueOf(this.timeFormat()) + " TRACE:" + this.buf + this.getMethodName() + " EXIT");
    }

    public void debugTool(String msg) {
        if (this.logLevel < DEBUGTOOL) {
            return;
        }
        this.logWriter.println(String.valueOf(this.timeFormat()) + " TOOLDEBUG:" + this.buf + msg);
    }

    public void enteringTool() {
        if (this.logLevel < DEBUGTOOL) {
            return;
        }
        this.logWriter.println(String.valueOf(this.timeFormat()) + " TOOLDEBUG:" + this.buf + MethodUtil.getMethodNameTool(CLASSNAME) + " ENTER");
        if (this.buf.length() < this.max_indent_size) {
            StringBuffer stringBuffer = this.buf;
            synchronized (stringBuffer) {
                this.buf.append("  ");
            }
        }
    }

    public void exitingTool() {
        if (this.logLevel < DEBUGTOOL) {
            return;
        }
        try {
            this.buf.delete(0, 2);
        }
        catch (Exception e) {
            this.buf = new StringBuffer();
        }
        this.logWriter.println(String.valueOf(this.timeFormat()) + " TOOLDEBUG:" + this.buf + MethodUtil.getMethodNameTool(CLASSNAME) + " EXIT");
    }

    public void log(int level, String msg) {
        if (level == ERR) {
            this.err(msg);
        }
        if (level == WARN) {
            this.warn(msg);
        }
        if (level == LOG) {
            this.log(msg);
        }
        if (level == DEBUG) {
            this.debug(msg);
        }
        if (level == DEBUGTOOL) {
            this.debugTool(msg);
        }
    }

    protected void finalize() throws Throwable {
        this.logWriter.close();
        super.finalize();
    }

    private String getMethodName() {
        return MethodUtil.getMethodName(CLASSNAME);
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public void setTime_format(DateFormat time_format) {
        this.time_format = time_format;
    }

    public void deleteBuf(int i) {
        try {
            this.buf.delete(0, i);
        }
        catch (Exception e) {
            this.buf = new StringBuffer();
        }
    }

    public boolean isDebug() {
        return this.logLevel >= DEBUG;
    }
}

