/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util.jdbc.cluster;

import com.lavans.util.Logger;
import com.lavans.util.jdbc.cluster.CalledMethod;
import com.lavans.util.jdbc.cluster.ClusterCallableStatement;
import com.lavans.util.jdbc.cluster.ClusterConnectionPool;
import com.lavans.util.jdbc.cluster.ClusterPreparedStatement;
import com.lavans.util.jdbc.cluster.ClusterStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClusterConnection
implements Connection {
    private static final String MSG_WARN_SWITCH_DB = "\u969c\u5bb3\u304c\u51fa\u305f\u306e\u3067\u63a5\u7d9a\u5148\u3092\u5207\u308a\u66ff\u3048\u307e\u3059\u3002";
    private Connection con = null;
    private ClusterConnectionPool pool = null;
    private boolean isAutoCommit = true;
    private String catalog = null;
    private int holdability = 2;
    private boolean isReadOnly = false;
    private int transactionIsolation = 2;
    private Map typeMap = null;
    private List statementList = null;
    private Map statementMap = null;
    protected static Logger logger = Logger.getInstance();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public ClusterConnection(Connection con, ClusterConnectionPool pool) throws SQLException {
        this.con = con;
        this.pool = pool;
        this.statementList = new ArrayList();
        this.statementMap = new HashMap();
        this.isAutoCommit = con.getAutoCommit();
        this.catalog = con.getCatalog();
        this.isReadOnly = con.isReadOnly();
        this.transactionIsolation = con.getTransactionIsolation();
        this.typeMap = con.getTypeMap();
    }

    private Object clusterCall(String methodName, Object[] args, Class[] parameterTypes) throws SQLException {
        return this.clusterCall(new CalledMethod(methodName, args, parameterTypes));
    }

    private Object clusterCall(CalledMethod calledMethod) throws SQLException {
        logger.enteringTool();
        logger.debugTool(calledMethod.toString());
        Object result = null;
        try {
            result = calledMethod.invoke(this.con);
        }
        catch (Exception e) {
            try {
                logger.err(MSG_WARN_SWITCH_DB + e.getCause().getMessage());
            }
            catch (Exception e2) {
                logger.err(MSG_WARN_SWITCH_DB + e.getMessage());
            }
            try {
                this.con.close();
            }
            catch (SQLException e2) {
                // empty catch block
            }
            this.con = this.pool.getAnotherConnection(this);
            try {
                this.con.setAutoCommit(this.isAutoCommit);
                this.con.setCatalog(this.catalog);
                this.con.setHoldability(this.holdability);
                this.con.setReadOnly(this.isReadOnly);
                this.con.setTransactionIsolation(this.transactionIsolation);
                this.con.setTypeMap(this.typeMap);
                int i = 0;
                while (i < this.statementList.size()) {
                    ClusterStatement cst = (ClusterStatement)this.statementList.get(i);
                    CalledMethod method = (CalledMethod)this.statementMap.get(cst);
                    Statement st = (Statement)method.invoke(this.con);
                    cst.reupdateStatement(st);
                    ++i;
                }
                result = calledMethod.invoke(this.con);
            }
            catch (Exception e2) {
                logger.exitingTool();
                throw new SQLException(e2.getMessage());
            }
        }
        logger.exitingTool();
        return result;
    }

    public void remove(Statement st) {
        this.statementList.remove(st);
        this.statementMap.remove(st);
    }

    public void notifyError(ClusterStatement src) throws SQLException {
        try {
            this.con.rollback();
            this.con.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.con = this.pool.getAnotherConnection(this);
            this.con.setAutoCommit(this.isAutoCommit);
            this.con.setTransactionIsolation(this.transactionIsolation);
            this.con.setCatalog(this.catalog);
            this.con.setReadOnly(this.isReadOnly);
            this.con.setTypeMap(this.typeMap);
            int i = 0;
            while (i < this.statementList.size()) {
                ClusterStatement cst = (ClusterStatement)this.statementList.get(i);
                if (src != cst) {
                    CalledMethod method = (CalledMethod)this.statementMap.get(cst);
                    Statement st = (Statement)method.invoke(this.con);
                    cst.reupdateStatement(st);
                }
                ++i;
            }
            CalledMethod method = (CalledMethod)this.statementMap.get(src);
            Statement st = (Statement)method.invoke(this.con);
            src.reupdateStatement(st);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    public Statement createStatement() throws SQLException {
        CalledMethod method = new CalledMethod("createStatement", null, null);
        Statement st = (Statement)this.clusterCall(method);
        ClusterStatement cst = new ClusterStatement(this, st);
        if (!this.getAutoCommit()) {
            this.statementList.add(cst);
            this.statementMap.put(cst, method);
        }
        return cst;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Object[] args = new Object[]{new Integer(resultSetType), new Integer(resultSetConcurrency)};
        Class[] types = new Class[]{Integer.TYPE, Integer.TYPE};
        CalledMethod method = new CalledMethod("createStatement", args, types);
        Statement st = (Statement)this.clusterCall(method);
        ClusterStatement cst = new ClusterStatement(this, st);
        if (!this.getAutoCommit()) {
            this.statementList.add(cst);
            this.statementMap.put(cst, method);
        }
        return cst;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Object[] args = new Object[]{new Integer(resultSetType), new Integer(resultSetConcurrency), new Integer(resultSetHoldability)};
        Class[] types = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
        CalledMethod method = new CalledMethod("createStatement", args, types);
        Statement st = (Statement)this.clusterCall(method);
        ClusterStatement cst = new ClusterStatement(this, st);
        if (!this.getAutoCommit()) {
            this.statementList.add(cst);
            this.statementMap.put(cst, method);
        }
        return cst;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        ClusterCallableStatement cst = new ClusterCallableStatement(this, this.con.prepareCall(sql));
        if (!this.getAutoCommit()) {
            this.statementList.add(cst);
        }
        return cst;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        ClusterCallableStatement cst = new ClusterCallableStatement(this, this.con.prepareCall(sql, resultSetType, resultSetConcurrency));
        if (!this.getAutoCommit()) {
            this.statementList.add(cst);
        }
        return cst;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        ClusterCallableStatement cst = new ClusterCallableStatement(this, this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        if (!this.getAutoCommit()) {
            this.statementList.add(cst);
        }
        return cst;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        Object[] args = new Object[]{sql};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] types = classArray;
        CalledMethod method = new CalledMethod("prepareStatement", args, types);
        PreparedStatement st = (PreparedStatement)this.clusterCall(method);
        ClusterPreparedStatement cst = new ClusterPreparedStatement(this, st);
        if (!this.getAutoCommit()) {
            this.statementList.add(cst);
            this.statementMap.put(cst, method);
        }
        return cst;
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        Object[] args = new Object[]{sql, new Integer(autoGeneratedKeys)};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        classArray[1] = Integer.TYPE;
        Class[] types = classArray;
        CalledMethod method = new CalledMethod("prepareStatement", args, types);
        PreparedStatement st = (PreparedStatement)this.clusterCall(method);
        ClusterPreparedStatement cst = new ClusterPreparedStatement(this, st);
        if (!this.getAutoCommit()) {
            this.statementList.add(cst);
            this.statementMap.put(cst, method);
        }
        return cst;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        Object[] args = new Object[]{sql, new Integer(resultSetType), new Integer(resultSetConcurrency)};
        Class[] classArray = new Class[3];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        classArray[1] = Integer.TYPE;
        classArray[2] = Integer.TYPE;
        Class[] types = classArray;
        CalledMethod method = new CalledMethod("prepareStatement", args, types);
        PreparedStatement st = (PreparedStatement)this.clusterCall(method);
        ClusterPreparedStatement cst = new ClusterPreparedStatement(this, st);
        if (!this.getAutoCommit()) {
            this.statementList.add(cst);
            this.statementMap.put(cst, method);
        }
        return cst;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Object[] args = new Object[]{sql, new Integer(resultSetType), new Integer(resultSetConcurrency), new Integer(resultSetHoldability)};
        Class[] classArray = new Class[4];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        classArray[1] = Integer.TYPE;
        classArray[2] = Integer.TYPE;
        classArray[3] = Integer.TYPE;
        Class[] types = classArray;
        CalledMethod method = new CalledMethod("prepareStatement", args, types);
        PreparedStatement st = (PreparedStatement)this.clusterCall(method);
        ClusterPreparedStatement cst = new ClusterPreparedStatement(this, st);
        if (!this.getAutoCommit()) {
            this.statementList.add(cst);
            this.statementMap.put(cst, method);
        }
        return cst;
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        Object[] args = new Object[]{sql, columnIndexes};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] types = classArray;
        CalledMethod method = new CalledMethod("prepareStatement", args, types);
        PreparedStatement st = (PreparedStatement)this.clusterCall(method);
        ClusterPreparedStatement cst = new ClusterPreparedStatement(this, st);
        if (!this.getAutoCommit()) {
            this.statementList.add(cst);
            this.statementMap.put(cst, method);
        }
        return cst;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        Object[] args = new Object[]{sql, columnNames};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] types = classArray;
        CalledMethod method = new CalledMethod("prepareStatement", args, types);
        PreparedStatement st = (PreparedStatement)this.clusterCall(method);
        ClusterPreparedStatement cst = new ClusterPreparedStatement(this, st);
        if (!this.getAutoCommit()) {
            this.statementList.add(cst);
            this.statementMap.put(cst, method);
        }
        return cst;
    }

    public int getHoldability() throws SQLException {
        return this.holdability;
    }

    public int getTransactionIsolation() throws SQLException {
        return this.transactionIsolation;
    }

    public void clearWarnings() throws SQLException {
        this.clusterCall("clearWarnings", null, null);
    }

    public void close() throws SQLException {
        this.clusterCall("close", null, null);
        this.statementList.clear();
        this.statementMap.clear();
    }

    public void commit() throws SQLException {
        this.clusterCall("commit", null, null);
        this.statementList.clear();
        this.statementMap.clear();
    }

    public void rollback() throws SQLException {
        this.clusterCall("rollback", null, null);
        this.statementList.clear();
        this.statementMap.clear();
    }

    public boolean getAutoCommit() throws SQLException {
        return this.isAutoCommit;
    }

    public boolean isClosed() throws SQLException {
        return (Boolean)this.clusterCall("isClosed", null, null);
    }

    public boolean isReadOnly() throws SQLException {
        return this.isReadOnly;
    }

    public void setHoldability(int holdability) throws SQLException {
        this.clusterCall("setHoldability", new Object[]{new Integer(holdability)}, new Class[]{Integer.TYPE});
        this.holdability = holdability;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.clusterCall("setTransactionIsolation", new Object[]{new Integer(level)}, new Class[]{Integer.TYPE});
        this.transactionIsolation = level;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.clusterCall("setAutoCommit", new Object[]{new Boolean(autoCommit)}, new Class[]{Boolean.TYPE});
        this.isAutoCommit = autoCommit;
        this.statementList.clear();
        this.statementMap.clear();
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.clusterCall("setReadOnly", new Object[]{new Boolean(readOnly)}, new Class[]{Boolean.TYPE});
        this.isReadOnly = readOnly;
    }

    public String getCatalog() throws SQLException {
        return this.catalog;
    }

    public void setCatalog(String setCatalog) throws SQLException {
        Object[] objectArray = new Object[]{setCatalog};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        this.clusterCall("setCatalog", objectArray, classArray);
        this.catalog = setCatalog;
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        return (DatabaseMetaData)this.clusterCall("getMetaData", null, null);
    }

    public SQLWarning getWarnings() throws SQLException {
        return (SQLWarning)this.clusterCall("getWarnings", null, null);
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Map getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public void setTypeMap(Map map) throws SQLException {
        Object[] objectArray = new Object[]{map};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        this.clusterCall("setTypeMap", objectArray, classArray);
        this.typeMap = map;
    }

    public String nativeSQL(String sql) throws SQLException {
        Object[] objectArray = new Object[]{sql};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (String)this.clusterCall("nativeSQL", objectArray, classArray);
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

