/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util.jdbc.pool;

import com.lavans.util.Logger;
import com.lavans.util.jdbc.ConnectionPool;
import com.lavans.util.jdbc.DBManager;
import com.lavans.util.jdbc.bind.BindConnection;
import com.lavans.util.jdbc.bind.BindPreparedStatement;
import com.lavans.util.jdbc.pool.PooledBindPreparedStatement;
import com.lavans.util.jdbc.pool.PooledCallableStatement;
import com.lavans.util.jdbc.pool.PooledPreparedStatement;
import com.lavans.util.jdbc.pool.PooledStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PooledConnection
implements BindConnection {
    private static Logger logger = Logger.getInstance();
    private BindConnection bcon = null;
    private ConnectionPool pool = null;
    private List statementList = new ArrayList();

    public BindConnection getRealConnection() {
        return this.bcon;
    }

    public PooledConnection(ConnectionPool pool, BindConnection bcon) {
        this.pool = pool;
        this.bcon = bcon;
    }

    public boolean removeStatement(PooledStatement st) {
        logger.debugTool("before:" + this.statementList.size());
        boolean result = this.statementList.remove(st);
        logger.debugTool("after:" + this.statementList.size());
        return result;
    }

    public BindPreparedStatement bindPrepareStatement(String sql) throws SQLException {
        BindPreparedStatement bst = this.bcon.bindPrepareStatement(sql);
        PooledBindPreparedStatement pst = new PooledBindPreparedStatement(this, bst);
        this.statementList.add(pst);
        return pst;
    }

    public void close() throws SQLException {
        DBManager.releaseConnection((Connection)this, this.pool);
        this.clearStatementList();
    }

    public void clearStatementList() {
        while (this.statementList.size() > 0) {
            Statement st = (Statement)this.statementList.get(0);
            try {
                st.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.statementList.clear();
    }

    public void clearWarnings() throws SQLException {
        this.bcon.clearWarnings();
    }

    public void commit() throws SQLException {
        this.bcon.commit();
    }

    public Statement createStatement() throws SQLException {
        Statement st = this.bcon.createStatement();
        PooledStatement pst = new PooledStatement(this, st);
        this.statementList.add(pst);
        return pst;
    }

    public Statement createStatement(int arg0, int arg1) throws SQLException {
        Statement st = this.bcon.createStatement(arg0, arg1);
        PooledStatement pst = new PooledStatement(this, st);
        this.statementList.add(pst);
        return pst;
    }

    public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
        Statement st = this.bcon.createStatement(arg0, arg1, arg2);
        PooledStatement pst = new PooledStatement(this, st);
        this.statementList.add(pst);
        return pst;
    }

    public boolean getAutoCommit() throws SQLException {
        return this.bcon.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        return this.bcon.getCatalog();
    }

    public int getHoldability() throws SQLException {
        return this.bcon.getHoldability();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.bcon.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        return this.bcon.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        return this.bcon.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.bcon.getWarnings();
    }

    public int hashCode() {
        return this.bcon.hashCode();
    }

    public boolean isClosed() throws SQLException {
        return this.bcon.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        return this.bcon.isReadOnly();
    }

    public String nativeSQL(String arg0) throws SQLException {
        return this.bcon.nativeSQL(arg0);
    }

    public CallableStatement prepareCall(String arg0) throws SQLException {
        CallableStatement st = this.bcon.prepareCall(arg0);
        PooledCallableStatement pst = new PooledCallableStatement(this, st);
        this.statementList.add(pst);
        return pst;
    }

    public CallableStatement prepareCall(String arg0, int arg1, int arg2) throws SQLException {
        CallableStatement st = this.bcon.prepareCall(arg0, arg1, arg2);
        PooledCallableStatement pst = new PooledCallableStatement(this, st);
        this.statementList.add(pst);
        return pst;
    }

    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        CallableStatement st = this.bcon.prepareCall(arg0, arg1, arg2, arg3);
        PooledCallableStatement pst = new PooledCallableStatement(this, st);
        this.statementList.add(pst);
        return pst;
    }

    public PreparedStatement prepareStatement(String arg0) throws SQLException {
        PreparedStatement st = this.bcon.prepareStatement(arg0);
        PooledPreparedStatement pst = new PooledPreparedStatement(this, st);
        this.statementList.add(pst);
        return pst;
    }

    public PreparedStatement prepareStatement(String arg0, int arg1) throws SQLException {
        PreparedStatement st = this.bcon.prepareStatement(arg0, arg1);
        PooledPreparedStatement pst = new PooledPreparedStatement(this, st);
        this.statementList.add(pst);
        return pst;
    }

    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2) throws SQLException {
        PreparedStatement st = this.bcon.prepareStatement(arg0, arg1, arg2);
        PooledPreparedStatement pst = new PooledPreparedStatement(this, st);
        this.statementList.add(pst);
        return pst;
    }

    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        PreparedStatement st = this.bcon.prepareStatement(arg0, arg1, arg2, arg3);
        PooledPreparedStatement pst = new PooledPreparedStatement(this, st);
        this.statementList.add(pst);
        return pst;
    }

    public PreparedStatement prepareStatement(String arg0, int[] arg1) throws SQLException {
        PreparedStatement st = this.bcon.prepareStatement(arg0, arg1);
        PooledPreparedStatement pst = new PooledPreparedStatement(this, st);
        this.statementList.add(pst);
        return pst;
    }

    public PreparedStatement prepareStatement(String arg0, String[] arg1) throws SQLException {
        PreparedStatement st = this.bcon.prepareStatement(arg0, arg1);
        PooledPreparedStatement pst = new PooledPreparedStatement(this, st);
        this.statementList.add(pst);
        return pst;
    }

    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        this.bcon.releaseSavepoint(arg0);
    }

    public void rollback() throws SQLException {
        this.bcon.rollback();
    }

    public void rollback(Savepoint arg0) throws SQLException {
        this.bcon.rollback(arg0);
    }

    public void setAutoCommit(boolean arg0) throws SQLException {
        this.bcon.setAutoCommit(arg0);
    }

    public void setCatalog(String arg0) throws SQLException {
        this.bcon.setCatalog(arg0);
    }

    public void setHoldability(int arg0) throws SQLException {
        this.bcon.setHoldability(arg0);
    }

    public void setReadOnly(boolean arg0) throws SQLException {
        this.bcon.setReadOnly(arg0);
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.bcon.setSavepoint();
    }

    public Savepoint setSavepoint(String arg0) throws SQLException {
        return this.bcon.setSavepoint(arg0);
    }

    public void setTransactionIsolation(int arg0) throws SQLException {
        this.bcon.setTransactionIsolation(arg0);
    }

    public void setTypeMap(Map arg0) throws SQLException {
        this.bcon.setTypeMap(arg0);
    }
}

