/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util.jdbc.stats;

import com.lavans.util.BaseClass;
import com.lavans.util.MethodUtil;
import com.lavans.util.jdbc.stats.StatsRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Statistics
extends BaseClass {
    private Map sqlMap = new HashMap();
    private static Statistics instance = new Statistics();
    private Map countConnMap = new HashMap();
    private static final int COUNT_GET = 0;
    private static final int COUNT_RELEASE = 1;
    private static final String CLASSNAME;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.lavans.util.jdbc.stats.Statistics");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASSNAME = clazz.getName();
    }

    private Statistics() {
    }

    public static Statistics getInstance() {
        return instance;
    }

    public void addData(String sql, long costTime, String classname) {
        StatsRecord record = (StatsRecord)this.sqlMap.get(sql);
        if (record == null) {
            record = new StatsRecord();
            this.sqlMap.put(sql, record);
            record.setSql(sql);
        }
        record.callCountUp();
        record.addTotalCostTime(costTime);
        String method = MethodUtil.getMethodName(classname);
        record.addMethodNames(method);
    }

    public List getStatInfoByTotal() {
        return this.getStatInfoByTotal(0, this.sqlMap.size());
    }

    public List getStatInfoByTotal(int fromIndex, int toIndex) {
        ArrayList list = new ArrayList(this.sqlMap.values());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                int result = -1;
                StatsRecord r1 = (StatsRecord)o1;
                StatsRecord r2 = (StatsRecord)o2;
                if (r1.getTotalCostTime() < r2.getTotalCostTime()) {
                    result = 1;
                } else if (r1.getTotalCostTime() == r2.getTotalCostTime()) {
                    result = 0;
                }
                return result;
            }
        });
        return list.subList(fromIndex, toIndex);
    }

    public List getStatInfoByAverage() {
        return this.getStatInfoByAverage(0, this.sqlMap.size());
    }

    public List getStatInfoByAverage(int fromIndex, int toIndex) {
        ArrayList list = new ArrayList(this.sqlMap.values());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                int result = -1;
                StatsRecord r1 = (StatsRecord)o1;
                StatsRecord r2 = (StatsRecord)o2;
                if (r1.getAverage() < r2.getAverage()) {
                    result = 1;
                } else if (r1.getAverage() == r2.getAverage()) {
                    result = 0;
                }
                return result;
            }
        });
        return list.subList(fromIndex, toIndex);
    }

    public void getConnection() {
        String method = MethodUtil.getMethodName(CLASSNAME).split(":")[0];
        int[] count = (int[])this.countConnMap.get(method);
        if (count == null) {
            count = new int[]{1, 0};
            this.countConnMap.put(method, count);
        } else {
            count[0] = count[0] + 1;
        }
    }

    public void releaseConnection() {
        String method = MethodUtil.getMethodName(CLASSNAME).split(":")[0];
        int[] count = (int[])this.countConnMap.get(method);
        if (count == null) {
            BaseClass.logger.debug("\u8cb8\u3057\u51fa\u3057\u3066\u306a\u3044\u30e1\u30bd\u30c3\u30c9\u304b\u3089\u8fd4\u5374\u3055\u308c\u305f\u3002" + method);
            count = new int[]{0, 1};
            this.countConnMap.put(method, count);
        } else {
            count[1] = count[1] + 1;
        }
    }

    public String viewConnectionPool() {
        if (this.countConnMap.size() == 0) {
            return "no stats data.";
        }
        Set col = this.countConnMap.keySet();
        ArrayList list = new ArrayList(col.size());
        Iterator ite = col.iterator();
        while (ite.hasNext()) {
            list.add(ite.next());
        }
        Collections.sort(list);
        StringBuffer buf = new StringBuffer();
        buf.append("Connection List\n");
        int i = 0;
        while (i < list.size()) {
            int[] count = (int[])this.countConnMap.get(list.get(i));
            buf.append(list.get(i) + "\t:" + count[0] + "\t:" + count[1] + "\t:" + (count[0] - count[1]) + "\n");
            ++i;
        }
        return buf.toString();
    }
}

