/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.laxGenerator;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.co.cybec.laxGenerator.DataSourceFileAnalyst;
import jp.co.cybec.laxGenerator.DataSourceMethod;
import jp.co.cybec.laxGenerator.DataSourceService;
import junit.framework.TestCase;
import org.jdom.JDOMException;

public class DataSourceFileAnalystTest
extends TestCase {
    private static final String DATA_SOURCE = "src/test/resources/DataSourceTest2.xml";

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private DataSourceFileAnalyst getInstance(String dataSourcePass) {
        return new DataSourceFileAnalyst(dataSourcePass);
    }

    public void testParse1() {
        try {
            DataSourceFileAnalyst dataSource = this.getInstance(DATA_SOURCE);
            dataSource.parse();
            HashMap dataSourceMap = dataSource.getDataSourceMap();
            this.showDataSourceMap(dataSourceMap);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void showDataSourceMap(Map detaSourceMap) {
        Set keySet = detaSourceMap.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            DataSourceService service = (DataSourceService)detaSourceMap.get(it.next());
            this.showDataServiceDetails(service);
        }
    }

    private void showDataServiceDetails(DataSourceService service) {
        System.out.println("## DataSourceServicies details ##");
        System.out.println("  This DataSourceServicies id is [" + service.getServiceId() + "]");
        System.out.println("   #itemNamesList#");
        for (String itemName : service.getItemNameList()) {
            System.out.println("      " + itemName);
        }
        System.out.println("   #methodList# ");
        this.showMethodDetails(service.getSaveMethod(), "      #saveMethodList# ");
        this.showMethodDetails(service.getUpdateMethod(), "      #updateMethodList# ");
        this.showMethodDetails(service.getDeleteMethod(), "      #deleteMethodList# ");
        this.showMethodDetails(service.getFindMethodList(), "      #findMethodList# ");
        this.showMethodDetails(service.getMethodList(), "      #methodList# ");
        System.out.println("## End of DataSourceServicies details ##\n");
    }

    private void showMethodDetails(List methodList, String exp) {
        System.out.println(exp);
        Iterator methodIt = methodList.iterator();
        while (methodIt.hasNext()) {
            System.out.println("        " + methodIt.next() + "\n");
        }
    }

    private void showMethodDetails(DataSourceMethod method, String exp) {
        System.out.println(exp);
        if (method != null) {
            System.out.println("        " + method.toString() + "\n");
        }
    }
}

