/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.laxGenerator.attributes.base;

import java.util.List;
import java.util.Map;
import jp.co.cybec.laxGenerator.attributes.base.BaseTag;
import jp.co.cybec.laxGenerator.attributes.js.ComponentJsTag;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageTag
extends BaseTag {
    private String fileName;
    private ComponentJsTag jsTag = null;

    public ImageTag(String idString) {
        this.id = idString;
        this.jsTag = new ComponentJsTag();
    }

    @Override
    protected String getTagName() {
        return "<img  ";
    }

    @Override
    protected String getTagsAttribute() {
        String html = "id=\"" + this.id + "\"";
        html = String.valueOf(html) + this.getFileName();
        html = String.valueOf(html) + this.getScript();
        html = String.valueOf(html) + "/>\n";
        return html;
    }

    @Override
    protected String getPositionEndTag() {
        String divEnd = "";
        if (!super.getX().equals("") || !super.getY().equals("")) {
            divEnd = "</div>\n";
        }
        return divEnd;
    }

    @Override
    protected String getPositionTag() {
        String div = "";
        if (!super.getX().equals("") || !super.getY().equals("")) {
            div = "<div style=\"position:absolute;" + super.getX() + super.getY() + "\">\n";
        }
        return div;
    }

    @Override
    public void setAttributes(Element element) {
        this.x = element.getAttributeValue("x");
        this.y = element.getAttributeValue("y");
        this.fileName = element.getAttributeValue("file");
        this.event = element.getAttributeValue("event");
        this.jsTag.setAttributes(element);
    }

    private String getScript() {
        StringBuilder script = new StringBuilder("");
        if (this.event != null && !this.event.equals("")) {
            script.append(" ").append(this.event).append("=\"").append(this.id).append("();\"");
        }
        return script.toString();
    }

    @Override
    public String toFunction() {
        String scriptDefine = "function " + this.id + "() {\n" + "} \n";
        scriptDefine = String.valueOf(scriptDefine) + this.jsTag.toFunction();
        return scriptDefine;
    }

    public String getFileName() {
        if (this.fileName == null || this.fileName != null && this.fileName.equals("")) {
            return "";
        }
        return " fileName=\"" + this.fileName + "\" ";
    }

    @Override
    public List<String> getDefineFileList() {
        return this.jsTag.getDefineFileList();
    }

    @Override
    public void setDataSource(Map map) {
        this.jsTag.setDataSource(map);
    }
}

