/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.json.JSONException;
import net.sf.json.JsonConfig;
import net.sf.json.util.JsonEventListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class AbstractJSON {
    private static Set cycleSet = new HashSet();
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$json$AbstractJSON == null ? (class$net$sf$json$AbstractJSON = AbstractJSON.class$("net.sf.json.AbstractJSON")) : class$net$sf$json$AbstractJSON));
    static /* synthetic */ Class class$net$sf$json$AbstractJSON;

    AbstractJSON() {
    }

    protected static boolean addInstance(Object instance) {
        return cycleSet.add(instance);
    }

    protected static void fireArrayEndEvent() {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        if (jsonConfig.isEventTriggeringEnabled()) {
            Iterator listeners = jsonConfig.getJsonEventListeners().iterator();
            while (listeners.hasNext()) {
                JsonEventListener listener = (JsonEventListener)listeners.next();
                try {
                    listener.onArrayEnd();
                }
                catch (RuntimeException e) {
                    log.warn((Object)e);
                }
            }
        }
    }

    protected static void fireArrayStartEvent() {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        if (jsonConfig.isEventTriggeringEnabled()) {
            Iterator listeners = jsonConfig.getJsonEventListeners().iterator();
            while (listeners.hasNext()) {
                JsonEventListener listener = (JsonEventListener)listeners.next();
                try {
                    listener.onArrayStart();
                }
                catch (RuntimeException e) {
                    log.warn((Object)e);
                }
            }
        }
    }

    protected static void fireElementAddedEvent(int index, Object element) {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        if (jsonConfig.isEventTriggeringEnabled()) {
            Iterator listeners = jsonConfig.getJsonEventListeners().iterator();
            while (listeners.hasNext()) {
                JsonEventListener listener = (JsonEventListener)listeners.next();
                try {
                    listener.onElementAdded(index, element);
                }
                catch (RuntimeException e) {
                    log.warn((Object)e);
                }
            }
        }
    }

    protected static void fireErrorEvent(JSONException jsone) {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        if (jsonConfig.isEventTriggeringEnabled()) {
            Iterator listeners = jsonConfig.getJsonEventListeners().iterator();
            while (listeners.hasNext()) {
                JsonEventListener listener = (JsonEventListener)listeners.next();
                try {
                    listener.onError(jsone);
                }
                catch (RuntimeException e) {
                    log.warn((Object)e);
                }
            }
        }
    }

    protected static void fireObjectEndEvent() {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        if (jsonConfig.isEventTriggeringEnabled()) {
            Iterator listeners = jsonConfig.getJsonEventListeners().iterator();
            while (listeners.hasNext()) {
                JsonEventListener listener = (JsonEventListener)listeners.next();
                try {
                    listener.onObjectEnd();
                }
                catch (RuntimeException e) {
                    log.warn((Object)e);
                }
            }
        }
    }

    protected static void fireObjectStartEvent() {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        if (jsonConfig.isEventTriggeringEnabled()) {
            Iterator listeners = jsonConfig.getJsonEventListeners().iterator();
            while (listeners.hasNext()) {
                JsonEventListener listener = (JsonEventListener)listeners.next();
                try {
                    listener.onObjectStart();
                }
                catch (RuntimeException e) {
                    log.warn((Object)e);
                }
            }
        }
    }

    protected static void firePropertySetEvent(String key, Object value, boolean accumulated) {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        if (jsonConfig.isEventTriggeringEnabled()) {
            Iterator listeners = jsonConfig.getJsonEventListeners().iterator();
            while (listeners.hasNext()) {
                JsonEventListener listener = (JsonEventListener)listeners.next();
                try {
                    listener.onPropertySet(key, value, accumulated);
                }
                catch (RuntimeException e) {
                    log.warn((Object)e);
                }
            }
        }
    }

    protected static void fireWarnEvent(String warning) {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        if (jsonConfig.isEventTriggeringEnabled()) {
            Iterator listeners = jsonConfig.getJsonEventListeners().iterator();
            while (listeners.hasNext()) {
                JsonEventListener listener = (JsonEventListener)listeners.next();
                try {
                    listener.onWarning(warning);
                }
                catch (RuntimeException e) {
                    log.warn((Object)e);
                }
            }
        }
    }

    protected static void removeInstance(Object instance) {
        cycleSet.remove(instance);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

