/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ezmorph.Morpher;
import net.sf.ezmorph.object.IdentityObjectMorpher;
import net.sf.json.AbstractJSON;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONFunction;
import net.sf.json.JSONNull;
import net.sf.json.JSONSerializer;
import net.sf.json.JSONString;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonBeanProcessor;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.processors.JsonVerifier;
import net.sf.json.regexp.RegexpUtils;
import net.sf.json.util.JSONTokener;
import net.sf.json.util.JSONUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JSONObject
extends AbstractJSON
implements JSON,
Map,
Comparable {
    private static final Log log = LogFactory.getLog(JSONObject.class);
    private boolean nullObject;
    private Map properties = new HashMap();

    public static JSONObject fromBean(Object bean) {
        if (bean == null || JSONUtils.isNull(bean)) {
            return new JSONObject(true);
        }
        if (bean instanceof Enum) {
            throw new JSONException("'bean' is an Enum. Use JSONArray instead");
        }
        if (bean instanceof Annotation || bean != null && bean.getClass().isAnnotation()) {
            throw new JSONException("'bean' is an Annotation.");
        }
        if (bean instanceof JSONObject) {
            return JSONObject._fromJSONObject((JSONObject)bean);
        }
        if (bean instanceof DynaBean) {
            return JSONObject._fromDynaBean((DynaBean)bean);
        }
        if (bean instanceof JSONTokener) {
            return JSONObject._fromJSONTokener((JSONTokener)bean);
        }
        if (bean instanceof JSONString) {
            return JSONObject._fromJSONString((JSONString)bean);
        }
        if (bean instanceof Map) {
            return JSONObject._fromMap((Map)bean);
        }
        if (bean instanceof String) {
            return JSONObject._fromString((String)bean);
        }
        if (JSONUtils.isNumber(bean) || JSONUtils.isBoolean(bean) || JSONUtils.isString(bean)) {
            return new JSONObject();
        }
        if (JSONUtils.isArray(bean)) {
            throw new JSONException("'bean' is an array. Use JSONArray instead");
        }
        return JSONObject._fromBean(bean);
    }

    public static JSONObject fromDynaBean(DynaBean bean) {
        return JSONObject._fromDynaBean(bean);
    }

    public static JSONObject fromJSONObject(JSONObject object) {
        return JSONObject._fromJSONObject(object);
    }

    public static JSONObject fromJSONString(JSONString string) {
        return JSONObject._fromJSONString(string);
    }

    public static JSONObject fromMap(Map map) {
        return JSONObject._fromMap(map);
    }

    public static JSONObject fromObject(Object object) {
        if (object == null || JSONUtils.isNull(object)) {
            return new JSONObject(true);
        }
        if (object instanceof Enum) {
            throw new JSONException("'object' is an Enum. Use JSONArray instead");
        }
        if (object instanceof Annotation || object != null && object.getClass().isAnnotation()) {
            throw new JSONException("'object' is an Annotation.");
        }
        if (object instanceof JSONObject) {
            return JSONObject._fromJSONObject((JSONObject)object);
        }
        if (object instanceof DynaBean) {
            return JSONObject._fromDynaBean((DynaBean)object);
        }
        if (object instanceof JSONTokener) {
            return JSONObject._fromJSONTokener((JSONTokener)object);
        }
        if (object instanceof JSONString) {
            return JSONObject._fromJSONString((JSONString)object);
        }
        if (object instanceof Map) {
            return JSONObject._fromMap((Map)object);
        }
        if (object instanceof String) {
            return JSONObject._fromString((String)object);
        }
        if (JSONUtils.isNumber(object) || JSONUtils.isBoolean(object) || JSONUtils.isString(object)) {
            return new JSONObject();
        }
        if (JSONUtils.isArray(object)) {
            throw new JSONException("'object' is an array. Use JSONArray instead");
        }
        return JSONObject._fromBean(object);
    }

    public static JSONObject fromString(String str) {
        return JSONObject._fromString(str);
    }

    public static Object toBean(JSONObject jsonObject) {
        if (jsonObject == null || jsonObject.isNullObject()) {
            return null;
        }
        DynaBean dynaBean = null;
        Map props = JSONUtils.getProperties(jsonObject);
        dynaBean = JSONUtils.newDynaBean(jsonObject);
        for (String name : jsonObject.names()) {
            String key = JSONUtils.convertToJavaIdentifier(name);
            Class type = (Class)props.get(name);
            Object value = jsonObject.get(name);
            try {
                if (!JSONUtils.isNull(value)) {
                    if (value instanceof JSONArray) {
                        dynaBean.set(key, (Object)JSONArray.toList((JSONArray)value));
                        continue;
                    }
                    if (String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || JSONUtils.isNumber(type) || Character.class.isAssignableFrom(type) || JSONFunction.class.isAssignableFrom(type)) {
                        dynaBean.set(key, value);
                        continue;
                    }
                    dynaBean.set(key, JSONObject.toBean((JSONObject)value));
                    continue;
                }
                if (type.isPrimitive()) {
                    log.warn((Object)("Tried to assign null value to " + key + ":" + type.getName()));
                    dynaBean.set(key, JSONUtils.getMorpherRegistry().morph(type, null));
                    continue;
                }
                dynaBean.set(key, null);
            }
            catch (JSONException jsone) {
                throw jsone;
            }
            catch (Exception e) {
                throw new JSONException("Error while setting property=" + name + " type" + type, e);
            }
        }
        return dynaBean;
    }

    public static Object toBean(JSONObject jsonObject, Class beanClass) {
        return JSONObject.toBean(jsonObject, beanClass, null);
    }

    public static Object toBean(JSONObject jsonObject, Class beanClass, Map classMap) {
        if (jsonObject == null || jsonObject.isNullObject()) {
            return null;
        }
        if (beanClass == null) {
            return JSONObject.toBean(jsonObject);
        }
        if (classMap == null) {
            classMap = Collections.EMPTY_MAP;
        }
        HashMap bean = null;
        try {
            if (beanClass.isInterface()) {
                if (!Map.class.isAssignableFrom(beanClass)) {
                    throw new JSONException("beanClass is an interface. " + beanClass);
                }
                bean = new HashMap();
            } else {
                bean = (HashMap)beanClass.newInstance();
            }
        }
        catch (JSONException jsone) {
            throw jsone;
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        Map props = JSONUtils.getProperties(jsonObject);
        JsonConfig jsonConfig = JsonConfig.getInstance();
        for (String name : jsonObject.names()) {
            String key = Map.class.isAssignableFrom(beanClass) && jsonConfig.isSkipJavaIdentifierTransformationInMapKeys() ? name : JSONUtils.convertToJavaIdentifier(name);
            Class type = (Class)props.get(name);
            Object value = jsonObject.get(name);
            try {
                PropertyDescriptor pd;
                PropertyDescriptor propertyDescriptor = pd = Map.class.isAssignableFrom(beanClass) ? null : PropertyUtils.getPropertyDescriptor(bean, (String)key);
                if (pd != null && pd.getWriteMethod() == null) {
                    log.warn((Object)("Property '" + key + "' has no write method. SKIPPED."));
                    continue;
                }
                if (!JSONUtils.isNull(value)) {
                    Class targetClass;
                    if (value instanceof JSONArray) {
                        if (List.class.isAssignableFrom(pd.getPropertyType())) {
                            targetClass = JSONObject.findTargetClass(key, classMap);
                            targetClass = targetClass == null ? JSONObject.findTargetClass(name, classMap) : targetClass;
                            List list = JSONArray.toList((JSONArray)value, targetClass, classMap);
                            JSONObject.setProperty(bean, key, list);
                            continue;
                        }
                        Object array = JSONArray.toArray((JSONArray)value, beanClass, classMap);
                        Class innerType = JSONUtils.getInnerComponentType(pd.getPropertyType());
                        if (innerType.isPrimitive() || JSONUtils.isNumber(innerType) || Boolean.class.isAssignableFrom(innerType) || JSONUtils.isString(innerType) || !array.getClass().equals(pd.getPropertyType())) {
                            array = JSONUtils.getMorpherRegistry().morph(Array.newInstance(innerType, 0).getClass(), array);
                        }
                        JSONObject.setProperty(bean, key, array);
                        continue;
                    }
                    if (String.class.isAssignableFrom(type) || JSONUtils.isBoolean(type) || JSONUtils.isNumber(type) || JSONUtils.isString(type) || JSONFunction.class.isAssignableFrom(type)) {
                        if (pd != null) {
                            if (!pd.getPropertyType().isInstance(value)) {
                                Morpher morpher = JSONUtils.getMorpherRegistry().getMorpherFor(pd.getPropertyType());
                                if (morpher != IdentityObjectMorpher.getInstance()) {
                                    JSONObject.setProperty(bean, key, JSONUtils.getMorpherRegistry().morph(pd.getPropertyType(), value));
                                    continue;
                                }
                                throw new JSONException("Can't transform property '" + key + "' from " + type.getName() + "into " + pd.getPropertyType().getName());
                            }
                            JSONObject.setProperty(bean, key, value);
                            continue;
                        }
                        JSONObject.setProperty(bean, key, value);
                        continue;
                    }
                    if (pd != null) {
                        targetClass = pd.getPropertyType();
                        if (targetClass == Object.class) {
                            targetClass = JSONObject.findTargetClass(key, classMap);
                            targetClass = targetClass == null ? JSONObject.findTargetClass(name, classMap) : targetClass;
                        }
                        JSONObject.setProperty(bean, key, JSONObject.toBean((JSONObject)value, targetClass, classMap));
                        continue;
                    }
                    targetClass = JSONObject.findTargetClass(key, classMap);
                    Class clazz = targetClass = targetClass == null ? JSONObject.findTargetClass(name, classMap) : targetClass;
                    if (targetClass != null) {
                        JSONObject.setProperty(bean, key, JSONObject.toBean((JSONObject)value, targetClass, classMap));
                        continue;
                    }
                    JSONObject.setProperty(bean, key, JSONObject.toBean((JSONObject)value));
                    continue;
                }
                if (type.isPrimitive()) {
                    log.warn((Object)("Tried to assign null value to " + key + ":" + type.getName()));
                    JSONObject.setProperty(bean, key, JSONUtils.getMorpherRegistry().morph(type, null));
                    continue;
                }
                JSONObject.setProperty(bean, key, null);
            }
            catch (JSONException jsone) {
                throw jsone;
            }
            catch (Exception e) {
                throw new JSONException("Error while setting property=" + name + " type" + type, e);
            }
        }
        return bean;
    }

    private static JSONObject _fromBean(Object bean) {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        JSONObject.fireObjectStartEvent();
        if (!JSONObject.addInstance(bean)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsObject(bean);
            }
            catch (JSONException jsone) {
                JSONObject.removeInstance(bean);
                JSONObject.fireErrorEvent(jsone);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONObject.removeInstance(bean);
                JSONException jsone = new JSONException(e);
                JSONObject.fireErrorEvent(jsone);
                throw jsone;
            }
        }
        JsonBeanProcessor processor = jsonConfig.findJsonBeanProcessor(bean.getClass());
        if (processor != null) {
            JSONObject json = null;
            try {
                json = processor.processBean(bean);
                if (json == null) {
                    json = new JSONObject(true);
                }
                JSONObject.removeInstance(bean);
                JSONObject.fireObjectEndEvent();
            }
            catch (JSONException jsone) {
                JSONObject.removeInstance(bean);
                JSONObject.fireErrorEvent(jsone);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONObject.removeInstance(bean);
                JSONException jsone = new JSONException(e);
                JSONObject.fireErrorEvent(jsone);
                throw jsone;
            }
            return json;
        }
        Collection exclusions = jsonConfig.getMergedExcludes();
        JSONObject jsonObject = new JSONObject();
        try {
            PropertyDescriptor[] pds = PropertyUtils.getPropertyDescriptors((Object)bean);
            Class<?> beanClass = bean.getClass();
            for (int i = 0; i < pds.length; ++i) {
                String key = pds[i].getName();
                if (exclusions.contains(key) || jsonConfig.isIgnoreTransientFields() && JSONObject.isTransientField(key, beanClass)) continue;
                Class<?> type = pds[i].getPropertyType();
                if (pds[i].getReadMethod() != null) {
                    Object value = PropertyUtils.getProperty((Object)bean, (String)key);
                    JsonValueProcessor jsonValueProcessor = jsonConfig.findJsonValueProcessor(beanClass, type, key);
                    if (jsonValueProcessor != null && !JsonVerifier.isValidJsonValue(value = jsonValueProcessor.processObjectValue(key, value))) {
                        throw new JSONException("Value is not a valid JSON value. " + value);
                    }
                    JSONObject.setValue(jsonObject, key, value, type);
                    continue;
                }
                String warning = "Property '" + key + "' has no read method. SKIPPED";
                JSONObject.fireWarnEvent(warning);
                log.warn((Object)warning);
            }
        }
        catch (JSONException jsone) {
            JSONObject.removeInstance(bean);
            JSONObject.fireErrorEvent(jsone);
            throw jsone;
        }
        catch (Exception e) {
            JSONObject.removeInstance(bean);
            JSONException jsone = new JSONException(e);
            JSONObject.fireErrorEvent(jsone);
            throw jsone;
        }
        JSONObject.removeInstance(bean);
        JSONObject.fireObjectEndEvent();
        return jsonObject;
    }

    private static JSONObject _fromDynaBean(DynaBean bean) {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        JSONObject.fireObjectStartEvent();
        if (bean == null) {
            JSONObject.fireObjectEndEvent();
            return new JSONObject(true);
        }
        if (!JSONObject.addInstance(bean)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsObject(bean);
            }
            catch (JSONException jsone) {
                JSONObject.removeInstance(bean);
                JSONObject.fireErrorEvent(jsone);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONObject.removeInstance(bean);
                JSONException jsone = new JSONException(e);
                JSONObject.fireErrorEvent(jsone);
                throw jsone;
            }
        }
        JSONObject jsonObject = new JSONObject();
        try {
            DynaProperty[] props = bean.getDynaClass().getDynaProperties();
            Collection exclusions = jsonConfig.getMergedExcludes();
            for (int i = 0; i < props.length; ++i) {
                DynaProperty dynaProperty = props[i];
                String key = dynaProperty.getName();
                if (exclusions.contains(key)) continue;
                Class type = dynaProperty.getType();
                Object value = bean.get(dynaProperty.getName());
                JsonValueProcessor jsonValueProcessor = jsonConfig.findJsonValueProcessor(type, key);
                if (jsonValueProcessor != null && !JsonVerifier.isValidJsonValue(value = jsonValueProcessor.processObjectValue(key, value))) {
                    throw new JSONException("Value is not a valid JSON value. " + value);
                }
                JSONObject.setValue(jsonObject, key, value, type);
            }
        }
        catch (JSONException jsone) {
            JSONObject.removeInstance(bean);
            JSONObject.fireErrorEvent(jsone);
            throw jsone;
        }
        catch (RuntimeException e) {
            JSONObject.removeInstance(bean);
            JSONException jsone = new JSONException(e);
            JSONObject.fireErrorEvent(jsone);
            throw jsone;
        }
        JSONObject.removeInstance(bean);
        JSONObject.fireObjectEndEvent();
        return jsonObject;
    }

    private static JSONObject _fromJSONObject(JSONObject object) {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        JSONObject.fireObjectStartEvent();
        if (object == null || object.isNullObject()) {
            JSONObject.fireObjectEndEvent();
            return new JSONObject(true);
        }
        if (!JSONObject.addInstance(object)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsObject(object);
            }
            catch (JSONException jsone) {
                JSONObject.removeInstance(object);
                JSONObject.fireErrorEvent(jsone);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONObject.removeInstance(object);
                JSONException jsone = new JSONException(e);
                JSONObject.fireErrorEvent(jsone);
                throw jsone;
            }
        }
        JSONArray sa = object.names();
        Collection exclusions = jsonConfig.getMergedExcludes();
        JSONObject jsonObject = new JSONObject();
        for (String key : sa) {
            if (exclusions.contains(key)) continue;
            Object value = object.opt(key);
            if (jsonObject.properties.containsKey(key)) {
                jsonObject.accumulate(key, value);
                JSONObject.firePropertySetEvent(key, value, true);
                continue;
            }
            jsonObject._setInternal(key, value);
            JSONObject.firePropertySetEvent(key, value, false);
        }
        JSONObject.removeInstance(object);
        JSONObject.fireObjectEndEvent();
        return jsonObject;
    }

    private static JSONObject _fromJSONString(JSONString string) {
        return JSONObject._fromJSONTokener(new JSONTokener(string.toJSONString()));
    }

    private static JSONObject _fromJSONTokener(JSONTokener tokener) {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        JSONObject.fireObjectStartEvent();
        try {
            if (tokener.matches("null.*")) {
                JSONObject.fireObjectEndEvent();
                return new JSONObject(true);
            }
            if (tokener.nextClean() != '{') {
                throw tokener.syntaxError("A JSONObject text must begin with '{'");
            }
            Collection exclusions = jsonConfig.getMergedExcludes();
            JSONObject jsonObject = new JSONObject();
            block14: while (true) {
                Object value;
                Object v;
                char c = tokener.nextClean();
                switch (c) {
                    case '\u0000': {
                        throw tokener.syntaxError("A JSONObject text must end with '}'");
                    }
                    case '}': {
                        JSONObject.fireObjectEndEvent();
                        return jsonObject;
                    }
                }
                tokener.back();
                String key = tokener.nextValue().toString();
                c = tokener.nextClean();
                if (c == '=') {
                    if (tokener.next() != '>') {
                        tokener.back();
                    }
                } else if (c != ':') {
                    throw tokener.syntaxError("Expected a ':' after a key");
                }
                if (!JSONUtils.isFunctionHeader(v = tokener.nextValue())) {
                    if (exclusions.contains(key)) {
                        switch (tokener.nextClean()) {
                            case ',': 
                            case ';': {
                                if (tokener.nextClean() == '}') {
                                    JSONObject.fireObjectEndEvent();
                                    return jsonObject;
                                }
                                tokener.back();
                                continue block14;
                            }
                            case '}': {
                                JSONObject.fireObjectEndEvent();
                                return jsonObject;
                            }
                        }
                        throw tokener.syntaxError("Expected a ',' or '}'");
                    }
                    if (v instanceof String && JSONUtils.mayBeJSON((String)v)) {
                        value = "\"" + v + "\"";
                        if (jsonObject.properties.containsKey(key)) {
                            jsonObject.accumulate(key, value);
                            JSONObject.firePropertySetEvent(key, value, true);
                        } else {
                            jsonObject.element(key, value);
                            JSONObject.firePropertySetEvent(key, value, false);
                        }
                    } else if (jsonObject.properties.containsKey(key)) {
                        jsonObject.accumulate(key, v);
                        JSONObject.firePropertySetEvent(key, v, true);
                    } else {
                        jsonObject.element(key, v);
                        JSONObject.firePropertySetEvent(key, v, false);
                    }
                } else {
                    char ch;
                    String params = JSONUtils.getFunctionParams((String)v);
                    int i = 0;
                    StringBuffer sb = new StringBuffer();
                    while ((ch = tokener.next()) != '\u0000') {
                        if (ch == '{') {
                            ++i;
                        }
                        if (ch == '}') {
                            --i;
                        }
                        sb.append(ch);
                        if (i != 0) continue;
                        break;
                    }
                    if (i != 0) {
                        throw tokener.syntaxError("Unbalanced '{' or '}' on prop: " + v);
                    }
                    String text = sb.toString();
                    text = text.substring(1, text.length() - 1).trim();
                    value = new JSONFunction(params != null ? StringUtils.split((String)params, (String)",") : null, text);
                    if (jsonObject.properties.containsKey(key)) {
                        jsonObject.accumulate(key, value);
                        JSONObject.firePropertySetEvent(key, value, true);
                    } else {
                        jsonObject.element(key, value);
                        JSONObject.firePropertySetEvent(key, value, false);
                    }
                }
                switch (tokener.nextClean()) {
                    case ',': 
                    case ';': {
                        if (tokener.nextClean() == '}') {
                            JSONObject.fireObjectEndEvent();
                            return jsonObject;
                        }
                        tokener.back();
                        continue block14;
                    }
                    case '}': {
                        JSONObject.fireObjectEndEvent();
                        return jsonObject;
                    }
                }
                break;
            }
            throw tokener.syntaxError("Expected a ',' or '}'");
        }
        catch (JSONException jsone) {
            JSONObject.fireErrorEvent(jsone);
            throw jsone;
        }
    }

    private static JSONObject _fromMap(Map map) {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        JSONObject.fireObjectStartEvent();
        if (map == null) {
            JSONObject.fireObjectEndEvent();
            return new JSONObject(true);
        }
        if (!JSONObject.addInstance(map)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsObject(map);
            }
            catch (JSONException jsone) {
                JSONObject.removeInstance(map);
                JSONObject.fireErrorEvent(jsone);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONObject.removeInstance(map);
                JSONException jsone = new JSONException(e);
                JSONObject.fireErrorEvent(jsone);
                throw jsone;
            }
        }
        Collection exclusions = jsonConfig.getMergedExcludes();
        JSONObject jsonObject = new JSONObject();
        try {
            for (Map.Entry entry : map.entrySet()) {
                Object k = entry.getKey();
                String key = k instanceof String ? (String)k : String.valueOf(k);
                if (exclusions.contains(key)) continue;
                Object value = entry.getValue();
                if (value != null) {
                    JsonValueProcessor jsonValueProcessor = jsonConfig.findJsonValueProcessor(value.getClass(), key);
                    if (jsonValueProcessor != null && !JsonVerifier.isValidJsonValue(value = jsonValueProcessor.processObjectValue(key, value))) {
                        throw new JSONException("Value is not a valid JSON value. " + value);
                    }
                    JSONObject.setValue(jsonObject, key, value, value.getClass());
                    continue;
                }
                if (jsonObject.properties.containsKey(key)) {
                    jsonObject.accumulate(key, JSONNull.getInstance());
                    JSONObject.firePropertySetEvent(key, JSONNull.getInstance(), true);
                    continue;
                }
                jsonObject.element(key, JSONNull.getInstance());
                JSONObject.firePropertySetEvent(key, JSONNull.getInstance(), false);
            }
        }
        catch (JSONException jsone) {
            JSONObject.removeInstance(map);
            JSONObject.fireErrorEvent(jsone);
            throw jsone;
        }
        catch (RuntimeException e) {
            JSONObject.removeInstance(map);
            JSONException jsone = new JSONException(e);
            JSONObject.fireErrorEvent(jsone);
            throw jsone;
        }
        JSONObject.removeInstance(map);
        JSONObject.fireObjectEndEvent();
        return jsonObject;
    }

    private static JSONObject _fromString(String str) {
        if (str == null || "null".compareToIgnoreCase(str) == 0) {
            JSONObject.fireObjectStartEvent();
            JSONObject.fireObjectEndEvent();
            return new JSONObject(true);
        }
        return JSONObject._fromJSONTokener(new JSONTokener(str));
    }

    private static Class findTargetClass(String key, Map classMap) {
        Class targetClass = (Class)classMap.get(key);
        if (targetClass == null) {
            for (Map.Entry entry : classMap.entrySet()) {
                if (!RegexpUtils.getMatcher((String)entry.getKey()).matches(key)) continue;
                targetClass = (Class)entry.getValue();
                break;
            }
        }
        return targetClass;
    }

    private static boolean isTransientField(String name, Class beanClass) {
        try {
            Field field = beanClass.getDeclaredField(name);
            return (field.getModifiers() & 0x80) == 128;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void setProperty(Object bean, String key, Object value) throws Exception {
        if (bean instanceof Map) {
            ((Map)bean).put(key, value);
        } else {
            PropertyUtils.setSimpleProperty((Object)bean, (String)key, (Object)value);
        }
    }

    private static void setValue(JSONObject jsonObject, String key, Object value, Class type) {
        boolean accumulated = false;
        if (value == null) {
            value = JSONUtils.isArray(type) ? new JSONArray() : (JSONUtils.isNumber(type) ? (JSONUtils.isDouble(type) ? (Number)new Double(0.0) : (Number)new Integer(0)) : (JSONUtils.isBoolean(type) ? Boolean.FALSE : (JSONUtils.isString(type) ? "" : JSONNull.getInstance())));
        }
        if (jsonObject.properties.containsKey(key)) {
            if (String.class.isAssignableFrom(type)) {
                Object o = jsonObject.opt(key);
                if (o instanceof JSONArray) {
                    ((JSONArray)o).addString((String)value);
                } else {
                    jsonObject.properties.put(key, new JSONArray().element(o).addString((String)value));
                }
            } else {
                jsonObject.accumulate(key, value);
            }
            accumulated = true;
        } else if (String.class.isAssignableFrom(type)) {
            jsonObject.properties.put(key, value);
        } else {
            jsonObject._setInternal(key, value);
        }
        value = jsonObject.opt(key);
        if (accumulated) {
            JSONArray array = (JSONArray)value;
            value = array.get(array.size() - 1);
        }
        JSONObject.firePropertySetEvent(key, value, accumulated);
    }

    public JSONObject() {
    }

    public JSONObject(boolean isNull) {
        this();
        this.nullObject = isNull;
    }

    public JSONObject accumulate(String key, boolean value) {
        return this._accumulate(key, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public JSONObject accumulate(String key, double value) {
        return this._accumulate(key, value);
    }

    public JSONObject accumulate(String key, int value) {
        return this._accumulate(key, value);
    }

    public JSONObject accumulate(String key, long value) {
        return this._accumulate(key, value);
    }

    public JSONObject accumulate(String key, Object value) {
        return this._accumulate(key, value);
    }

    public void accumulateAll(Map map) {
        if (map instanceof JSONObject) {
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                this.accumulate(key, value);
            }
        } else {
            for (Map.Entry entry : map.entrySet()) {
                String key = String.valueOf(entry.getKey());
                Object value = entry.getValue();
                this.accumulate(key, value);
            }
        }
    }

    public void clear() {
        this.properties.clear();
    }

    public int compareTo(Object obj) {
        if (obj != null && obj instanceof JSONObject) {
            int size2;
            JSONObject other = (JSONObject)obj;
            int size1 = this.size();
            if (size1 < (size2 = other.size())) {
                return -1;
            }
            if (size1 > size2) {
                return 1;
            }
            if (this.equals(other)) {
                return 0;
            }
        }
        return -1;
    }

    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    public boolean containsValue(Object value) {
        try {
            value = this.processValue(value);
        }
        catch (JSONException e) {
            return false;
        }
        return this.properties.containsValue(value);
    }

    public JSONObject element(String key, boolean value) {
        this.verifyIsNull();
        return this.element(key, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public JSONObject element(String key, Collection value) {
        this.verifyIsNull();
        if (value instanceof JSONArray) {
            return this.setInternal(key, value);
        }
        return this.element(key, JSONArray.fromObject(value));
    }

    public JSONObject element(String key, double value) {
        this.verifyIsNull();
        Double d = new Double(value);
        JSONUtils.testValidity(d);
        return this.element(key, d);
    }

    public JSONObject element(String key, int value) {
        this.verifyIsNull();
        return this.element(key, new Integer(value));
    }

    public JSONObject element(String key, long value) {
        this.verifyIsNull();
        return this.element(key, new Long(value));
    }

    public JSONObject element(String key, Map value) {
        this.verifyIsNull();
        if (value instanceof JSONObject) {
            return this.setInternal(key, value);
        }
        return this.element(key, JSONObject.fromObject(value));
    }

    public JSONObject element(String key, Object value) {
        this.verifyIsNull();
        if (key == null) {
            throw new JSONException("Null key.");
        }
        if (value != null) {
            value = this.processValue(key, value);
            this.setInternal(key, value);
        } else {
            this.remove(key);
        }
        return this;
    }

    public JSONObject elementOpt(String key, Object value) {
        this.verifyIsNull();
        if (key != null && value != null) {
            this.element(key, value);
        }
        return this;
    }

    public Set entrySet() {
        return this.properties.entrySet();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JSONObject)) {
            return false;
        }
        JSONObject other = (JSONObject)obj;
        if (this.isNullObject()) {
            return other.isNullObject();
        }
        if (other.isNullObject()) {
            return false;
        }
        if (other.size() != this.size()) {
            return false;
        }
        for (String key : this.properties.keySet()) {
            if (!other.properties.containsKey(key)) {
                return false;
            }
            Object o1 = this.properties.get(key);
            Object o2 = other.properties.get(key);
            if (JSONNull.getInstance().equals(o1)) {
                if (JSONNull.getInstance().equals(o2)) continue;
                return false;
            }
            if (JSONNull.getInstance().equals(o2)) {
                return false;
            }
            if (o1 instanceof String && o2 instanceof JSONFunction) {
                if (o1.equals(String.valueOf(o2))) continue;
                return false;
            }
            if (o1 instanceof JSONFunction && o2 instanceof String) {
                if (o2.equals(String.valueOf(o1))) continue;
                return false;
            }
            if (o1 instanceof JSONObject && o2 instanceof JSONObject) {
                if (o1.equals(o2)) continue;
                return false;
            }
            if (o1 instanceof JSONArray && o2 instanceof JSONArray) {
                if (o1.equals(o2)) continue;
                return false;
            }
            if (o1 instanceof JSONFunction && o2 instanceof JSONFunction) {
                if (o1.equals(o2)) continue;
                return false;
            }
            if (o1 instanceof String) {
                if (o1.equals(String.valueOf(o2))) continue;
                return false;
            }
            if (o2 instanceof String) {
                if (o2.equals(String.valueOf(o1))) continue;
                return false;
            }
            Morpher m1 = JSONUtils.getMorpherRegistry().getMorpherFor(o1.getClass());
            Morpher m2 = JSONUtils.getMorpherRegistry().getMorpherFor(o2.getClass());
            if (!(m1 != null && m1 != IdentityObjectMorpher.getInstance() ? !o1.equals(JSONUtils.getMorpherRegistry().morph(o1.getClass(), o2)) : (m2 != null && m2 != IdentityObjectMorpher.getInstance() ? !JSONUtils.getMorpherRegistry().morph(o1.getClass(), o1).equals(o2) : !o1.equals(o2)))) continue;
            return false;
        }
        return true;
    }

    public Object get(Object key) {
        if (key instanceof String) {
            return this.get((String)key);
        }
        return null;
    }

    public Object get(String key) {
        this.verifyIsNull();
        Object o = this.opt(key);
        if (o == null) {
            throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a Boolean.");
    }

    public double getDouble(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        try {
            return o instanceof Number ? ((Number)o).doubleValue() : Double.parseDouble((String)o);
        }
        catch (Exception e) {
            throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a number.");
        }
    }

    public int getInt(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(key);
    }

    public JSONArray getJSONArray(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        if (JSONNull.getInstance().equals(o)) {
            return new JSONObject(true);
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a JSONObject.");
    }

    public long getLong(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(key);
    }

    public String getString(String key) {
        this.verifyIsNull();
        return this.get(key).toString();
    }

    public boolean has(String key) {
        this.verifyIsNull();
        return this.properties.containsKey(key);
    }

    public int hashCode() {
        int hashcode = 19;
        if (this.isNullObject()) {
            return hashcode + JSONNull.getInstance().hashCode();
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            hashcode += key.hashCode() + JSONUtils.hashCode(value);
        }
        return hashcode;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isEmpty() {
        this.verifyIsNull();
        return this.properties.isEmpty();
    }

    public boolean isNullObject() {
        return this.nullObject;
    }

    public Iterator keys() {
        this.verifyIsNull();
        return this.properties.keySet().iterator();
    }

    public Set keySet() {
        return this.properties.keySet();
    }

    public int length() {
        this.verifyIsNull();
        return this.properties.size();
    }

    public JSONArray names() {
        this.verifyIsNull();
        JSONArray ja = new JSONArray();
        Iterator keys = this.keys();
        while (keys.hasNext()) {
            ja.element(keys.next());
        }
        return ja;
    }

    public Object opt(String key) {
        this.verifyIsNull();
        return key == null ? null : this.properties.get(key);
    }

    public boolean optBoolean(String key) {
        this.verifyIsNull();
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        this.verifyIsNull();
        try {
            return this.getBoolean(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double optDouble(String key) {
        this.verifyIsNull();
        return this.optDouble(key, Double.NaN);
    }

    public double optDouble(String key, double defaultValue) {
        this.verifyIsNull();
        try {
            Object o = this.opt(key);
            return o instanceof Number ? ((Number)o).doubleValue() : new Double((String)o).doubleValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(String key) {
        this.verifyIsNull();
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        this.verifyIsNull();
        try {
            return this.getInt(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(String key) {
        this.verifyIsNull();
        Object o = this.opt(key);
        return o instanceof JSONArray ? (JSONArray)o : null;
    }

    public JSONObject optJSONObject(String key) {
        this.verifyIsNull();
        Object o = this.opt(key);
        return o instanceof JSONObject ? (JSONObject)o : null;
    }

    public long optLong(String key) {
        this.verifyIsNull();
        return this.optLong(key, 0L);
    }

    public long optLong(String key, long defaultValue) {
        this.verifyIsNull();
        try {
            return this.getLong(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(String key) {
        this.verifyIsNull();
        return this.optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        this.verifyIsNull();
        Object o = this.opt(key);
        return o != null ? o.toString() : defaultValue;
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key is null.");
        }
        Object previous = this.properties.get(key);
        this.element(String.valueOf(key), value);
        return previous;
    }

    public void putAll(Map map) {
        if (map instanceof JSONObject) {
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                this.properties.put(key, value);
            }
        } else {
            for (Map.Entry entry : map.entrySet()) {
                String key = String.valueOf(entry.getKey());
                Object value = entry.getValue();
                this.element(key, value);
            }
        }
    }

    public Object remove(Object key) {
        return this.properties.remove(key);
    }

    public Object remove(String key) {
        this.verifyIsNull();
        return this.properties.remove(key);
    }

    public int size() {
        this.verifyIsNull();
        return this.properties.size();
    }

    public JSONArray toJSONArray(JSONArray names) {
        this.verifyIsNull();
        if (names == null || names.size() == 0) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (int i = 0; i < names.size(); ++i) {
            ja.element(this.opt(names.getString(i)));
        }
        return ja;
    }

    public String toString() {
        if (this.isNullObject()) {
            return JSONNull.getInstance().toString();
        }
        try {
            Iterator keys = this.keys();
            StringBuffer sb = new StringBuffer("{");
            while (keys.hasNext()) {
                if (sb.length() > 1) {
                    sb.append(',');
                }
                Object o = keys.next();
                sb.append(JSONUtils.quote(o.toString()));
                sb.append(':');
                sb.append(JSONUtils.valueToString(this.properties.get(o)));
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString(int indentFactor) {
        if (this.isNullObject()) {
            return JSONNull.getInstance().toString();
        }
        if (indentFactor == 0) {
            return this.toString();
        }
        return this.toString(indentFactor, 0);
    }

    public String toString(int indentFactor, int indent) {
        if (this.isNullObject()) {
            return JSONNull.getInstance().toString();
        }
        int n = this.size();
        if (n == 0) {
            return "{}";
        }
        if (indentFactor == 0) {
            return this.toString();
        }
        Iterator keys = this.keys();
        StringBuffer sb = new StringBuffer("{");
        int newindent = indent + indentFactor;
        if (n == 1) {
            Object o = keys.next();
            sb.append(JSONUtils.quote(o.toString()));
            sb.append(": ");
            sb.append(JSONUtils.valueToString(this.properties.get(o), indentFactor, indent));
        } else {
            int i;
            while (keys.hasNext()) {
                Object o = keys.next();
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                for (i = 0; i < newindent; ++i) {
                    sb.append(' ');
                }
                sb.append(JSONUtils.quote(o.toString()));
                sb.append(": ");
                sb.append(JSONUtils.valueToString(this.properties.get(o), indentFactor, newindent));
            }
            if (sb.length() > 1) {
                sb.append('\n');
                for (i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
            }
            for (i = 0; i < indent; ++i) {
                sb.insert(0, ' ');
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public Collection values() {
        return Collections.unmodifiableCollection(this.properties.values());
    }

    public Writer write(Writer writer) {
        try {
            if (this.isNullObject()) {
                writer.write(JSONNull.getInstance().toString());
                return writer;
            }
            boolean b = false;
            Iterator keys = this.keys();
            writer.write(123);
            while (keys.hasNext()) {
                if (b) {
                    writer.write(44);
                }
                Object k = keys.next();
                writer.write(JSONUtils.quote(k.toString()));
                writer.write(58);
                Object v = this.properties.get(k);
                if (v instanceof JSONObject) {
                    ((JSONObject)v).write(writer);
                } else if (v instanceof JSONArray) {
                    ((JSONArray)v).write(writer);
                } else {
                    writer.write(JSONUtils.valueToString(v));
                }
                b = true;
            }
            writer.write(125);
            return writer;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    private JSONObject _accumulate(String key, Object value) {
        if (this.isNullObject()) {
            throw new JSONException("Can't accumulate on null object");
        }
        if (!this.has(key)) {
            this.setInternal(key, value);
        } else {
            Object o = this.opt(key);
            if (o instanceof JSONArray) {
                ((JSONArray)o).element(value);
            } else {
                this.setInternal(key, new JSONArray().element(o).element(value));
            }
        }
        return this;
    }

    private Object _processValue(Object value) {
        if (value != null && Class.class.isAssignableFrom(value.getClass()) || value instanceof Class) {
            return ((Class)value).getName();
        }
        if (value instanceof JSON) {
            return value;
        }
        if (JSONUtils.isFunction(value)) {
            if (value instanceof String) {
                value = JSONFunction.parse((String)value);
            }
            return value;
        }
        if (value instanceof JSONString) {
            return JSONSerializer.toJSON((Object)((JSONString)value));
        }
        if (JSONUtils.isArray(value)) {
            return JSONArray.fromObject(value);
        }
        if (JSONUtils.isString(value)) {
            String str = String.valueOf(value);
            if (JSONUtils.mayBeJSON(str)) {
                try {
                    return JSONSerializer.toJSON((Object)str);
                }
                catch (JSONException jsone) {
                    return JSONUtils.stripQuotes(str);
                }
            }
            if (value == null) {
                return "";
            }
            return str;
        }
        if (JSONUtils.isNumber(value)) {
            JSONUtils.testValidity(value);
            return JSONUtils.transformNumber((Number)value);
        }
        if (JSONUtils.isBoolean(value)) {
            return value;
        }
        if (value != null && Enum.class.isAssignableFrom(value.getClass())) {
            return String.valueOf(value);
        }
        return JSONObject.fromObject(value);
    }

    private JSONObject _setInternal(String key, Object value) {
        this.verifyIsNull();
        if (key == null) {
            throw new JSONException("Null key.");
        }
        this.properties.put(key, this._processValue(value));
        return this;
    }

    private Object processValue(Object value) {
        JsonConfig jsonConfig;
        JsonValueProcessor processor;
        if (value != null && (processor = (jsonConfig = JsonConfig.getInstance()).findJsonValueProcessor(value.getClass())) != null && !JsonVerifier.isValidJsonValue(value = processor.processObjectValue(null, value))) {
            throw new JSONException("Value is not a valid JSON value. " + value);
        }
        return this._processValue(value);
    }

    private Object processValue(String key, Object value) {
        JsonConfig jsonConfig;
        JsonValueProcessor processor;
        if (value != null && (processor = (jsonConfig = JsonConfig.getInstance()).findJsonValueProcessor(value.getClass(), key)) != null && !JsonVerifier.isValidJsonValue(value = processor.processObjectValue(null, value))) {
            throw new JSONException("Value is not a valid JSON value. " + value);
        }
        return this._processValue(value);
    }

    private JSONObject setInternal(String key, Object value) {
        return this._setInternal(key, this.processValue(key, value));
    }

    private void verifyIsNull() {
        if (this.isNullObject()) {
            throw new JSONException("null object");
        }
    }
}

