package jp.co.cybec.laxide.editpolicies;

import jp.co.cybec.laxide.model.base.AbstractModel;
import jp.co.cybec.laxide.model.base.LetsAjax2ColumnHeaderLayoutModel;
import jp.co.cybec.laxide.model.base.LetsAjax2ColumnLayoutModel;
import jp.co.cybec.laxide.model.base.LetsAjaxBodyModel;
import jp.co.cybec.laxide.model.base.LetsAjaxButtonModel;
import jp.co.cybec.laxide.model.base.LetsAjaxChartModel;
import jp.co.cybec.laxide.model.base.LetsAjaxCheckBoxModel;
import jp.co.cybec.laxide.model.base.LetsAjaxComboBoxModel;
import jp.co.cybec.laxide.model.base.LetsAjaxImageModel;
import jp.co.cybec.laxide.model.base.LetsAjaxLabelModel;
import jp.co.cybec.laxide.model.base.LetsAjaxLayoutConstant;
import jp.co.cybec.laxide.model.base.LetsAjaxLinkButtonModel;
import jp.co.cybec.laxide.model.base.LetsAjaxPlainLayoutModel;
import jp.co.cybec.laxide.model.base.LetsAjaxRadioButtonModel;
import jp.co.cybec.laxide.model.base.LetsAjaxTextAreaModel;
import jp.co.cybec.laxide.model.base.LetsAjaxTextFieldModel;
import jp.co.cybec.laxide.model.base.LetsAjaxTextModel;
import jp.co.cybec.laxide.model.commands.ChangeConstraintCommand;
import jp.co.cybec.laxide.model.commands.CreateCommand;
import jp.co.cybec.laxide.model.extension.LetsAjaxDataTableModel;
import jp.co.cybec.laxide.model.extension.YuiBasicAnimateModel;
import jp.co.cybec.laxide.model.extension.YuiCalendarModel;
import jp.co.cybec.laxide.model.js.LetsAjaxJSControlModel;
import jp.co.cybec.laxide.model.js.YuiColorAnimateJSModel;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

/**
 * CreateR}hpEditPolicy. t@CFLetsAjaxXYLayoutEditPolicy.java
 * 
 * @author nakamura 쐬F14:44:39
 * 
 */
public class LetsAjaxXYLayoutEditPolicy extends XYLayoutEditPolicy {

	protected Command createChangeConstraintCommand(EditPart child,
			Object constraint) {
		// R}h̍쐬
		ChangeConstraintCommand command = new ChangeConstraintCommand();
		// ҏWΏۂ̃f̐ݒ
		command.setModel(child.getModel());
		command.setConstraint((Rectangle) constraint);
		// R}hԂ
		return command;
	}

	protected Command getCreateCommand(CreateRequest request) {
		CreateCommand command = new CreateCommand();

		// 쐬郂f̃TCYƈʒu()擾
		Rectangle constraint = (Rectangle) getConstraintFor(request);
		// VK쐬郂f̎擾
		AbstractModel model = (AbstractModel) request.getNewObject();

		LetsAjaxBodyModel bodyModel = (LetsAjaxBodyModel) getHost().getModel();
		int count = bodyModel.getChildCount() + 1;
		if (model instanceof LetsAjaxLabelModel) {
			// ǉ
			model.setId("Label" + count);
			model.setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_LABEL);
			constraint.height = 20;
			constraint.width = -1;

		} else if (model instanceof LetsAjaxTextModel) {
			// ǉ
			model.setId("Text" + count);
			model.setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_TEXT);
			constraint.height = 20;
			constraint.width = -1;

		} else if (model instanceof LetsAjaxButtonModel) {
			// ǉ
			model.setId("Button" + count);
			model.setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_BUTTON);
			constraint.height = 20;
			constraint.width = 60;
		} else if (model instanceof LetsAjaxTextFieldModel) {
			// ǉ
			model.setId("TextField" + count);
			model.setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_TEXTFIELD);
			constraint.height = 20;
			constraint.width = 100;
		} else if (model instanceof LetsAjaxTextAreaModel) {
			// ǉ
			model.setId("TextArea" + count);
			model.setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_TEXTAREA);
			constraint.height = 50;
			constraint.width = 160;
		} else if (model instanceof LetsAjaxRadioButtonModel) {
			// ǉ
			model.setId("RadioButton" + count);
			model.setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_RADIOBUTTON);
			constraint.height = 20;
			constraint.width = 100;
		} else if (model instanceof LetsAjaxCheckBoxModel) {
			// ǉ
			model.setId("CheckBox" + count);
			model.setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_CHECKBOX);
			constraint.height = 20;
			constraint.width = 100;
		} else if (model instanceof LetsAjaxLinkButtonModel) {
			// ǉ
			model.setId("LinkButton" + count);
			model.setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_LINKBUTTON);
			constraint.height = 20;
			constraint.width = 60;
		} else if (model instanceof LetsAjaxComboBoxModel) {
			// ǉ
			model.setId("ComboBox" + count);
			model.setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_COMBO_BOX);
			constraint.height = 20;
			constraint.width = 100;
		} else if (model instanceof LetsAjaxImageModel) {
			// ǉ
			model.setId("Image" + count);
			model.setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_IMAGE);
			constraint.height = 50;
			constraint.width = 60;
		} else if (model instanceof LetsAjaxDataTableModel) {
			// ǉ
			model.setId("DataTable" + count);
			model.setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_DATATABLE);
			constraint.height = 50;
			constraint.width = 100;
		} else if (model instanceof LetsAjaxJSControlModel) {
			// ǉ
			model.setId("JSControl" + count);
			model.setType(LetsAjaxLayoutConstant.LETSAJAX_JS_SAMPLE_FUNCTION);
			constraint.height = 50;
			constraint.width = 60;
		} else if (model instanceof YuiCalendarModel) {
			// ǉ
			model.setId("YuiCalendarJS" + count);
			model.setType(LetsAjaxLayoutConstant.LETSAJAX_YUI_CALENDAR);
			constraint.height = 80;
			constraint.width = 180;
		} else if (model instanceof YuiBasicAnimateModel) {
			// ǉ
			model.setId("YuiAnimateJS" + count);
			model.setType(LetsAjaxLayoutConstant.LETSAJAX_YUI_ANIMATE);
			constraint.height = 80;
			constraint.width = 180;
		} else if (model instanceof YuiColorAnimateJSModel) {
			// ǉ
			model.setId("YuiColorAnimateJS" + count);
			model.setType(LetsAjaxLayoutConstant.LETSAJAX_JS_YUI_COLOR_ANIMATE);
			constraint.height = 80;
			constraint.width = 180;
		} else if (model instanceof LetsAjaxChartModel) {
			// ǉ
			model.setId("LetsAjaxChartModel" + count);
			model.setType(LetsAjaxLayoutConstant.LETSAJAX_JS_CHART);
			constraint.height = 80;
			constraint.width = 100;
		} else if (model instanceof LetsAjaxPlainLayoutModel) {
			// ǉ
			model.setId("LetsAjaxPlainLayoutModel" + count);
			model.setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_PLAIN_LAYOUT);

			constraint.height = 501;
			constraint.width = 501;
			constraint.x = 10;
			constraint.y = 10;
		} else if (model instanceof LetsAjax2ColumnLayoutModel) {
			// ǉ
			model.setId("LetsAjax2ColumnLayoutModel" + count);
			model.setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_2COLOMUN_LAYOUT);

			constraint.height = 501;
			constraint.width = 501;
			constraint.x = 10;
			constraint.y = 10;
		} else if (model instanceof LetsAjax2ColumnHeaderLayoutModel) {
			// ǉ
			model.setId("LetsAjax2ColumnHeaderLayoutModel" + count);
			model
					.setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_2COLOMUN_HEADER_LAYOUT);

			constraint.height = 501;
			constraint.width = 501;
			constraint.x = 10;
			constraint.y = 10;
		}
		// ̐ݒ
		model.setConstraint(constraint);

		// TODO getHost().getModel()ĉH
		command.setLetsAjaxBodyModel(getHost().getModel());
		command.setAbstractModel(model);
		return command;
	}
}
