package jp.co.cybec.laxide.model.base;

import jp.co.cybec.laxide.util.LetsAjaxUtil;

import org.eclipse.draw2d.geometry.Rectangle;

/**
 * 
 * fNX̊{ƂȂNX
 * 
 * @author tokumaru
 */
public class BaseModel extends AbstractModel {
	// ύX̎ނʂ邽߂̕
	public static final String P_CONSTRAINT = "_constraint";

	protected static final String P_ID = "_id";

	protected static final String P_CLASS_NAME = "_className";

	protected Rectangle constraint; // 

	// f̑
	private String type;

	protected String id;

	private String x;

	private String y;

	private String className = "className";

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getConstraint()
	 */
	public Rectangle getConstraint() {
		return constraint;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setConstraint(org.eclipse.draw2d.geometry.Rectangle)
	 */
	public void setConstraint(Rectangle rect) {
		constraint = rect;
		if (this.constraint != null) {
			this.setX(Integer.toString(this.constraint.x));
			this.setY(Integer.toString(this.constraint.y));
		}
		// ύX̒ʒm
		firePropertyChange(P_CONSTRAINT, null, constraint);
	}

	// XMLt@Cւ̕ۑ
	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getLayoutXML()
	 */
	public String getLayoutXML() {
		String html = "<" + this.type + this.getId() + getBodyComponentXml()
				+ " x=\"" + this.x + "\" y=\"" + this.y + "\" />\n";
		return html;
	}

	/**
	 * @return id
	 */
	public String getId() {
		if (id == null || (id != null && id.equals(""))) {
			return "";
		}
		return " id=\"" + this.id + "\" ";
	}

	/**
	 * @return id
	 */
	protected String getComponentId() {
		if (id == null || (id != null && id.equals(""))) {
			return "";
		}
		return this.id;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setId(java.lang.String)
	 */
	public void setId(final String id) {
		this.id = LetsAjaxUtil.checkNull(id);
	}

	/**
	 * @return type
	 */
	public String getType() {
		return this.type;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setType(java.lang.String)
	 */
	public void setType(final String type) {
		this.type = type;
	}

	/**
	 * @return x
	 */
	public String getX() {
		return x;
	}

	/**
	 * @param x
	 *            x ݒB
	 */
	public void setX(String x) {
		this.x = x;
	}

	/**
	 * @return y
	 */
	public String getY() {
		return y;
	}

	/**
	 * @param y
	 *            y ݒB
	 */
	public void setY(String y) {
		this.y = y;
	}

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getBodyComponentXml()
	 */
	@Override
	public String getBodyComponentXml() {
		return "";
	}

	/**
	 * @return className
	 */
	public String getCssClassName() {
		return className;
	}

	/**
	 * @param className
	 *            className ݒB
	 */
	public void setCssClassName(String className) {
		this.className = LetsAjaxUtil.checkNull(className);

		firePropertyChange(P_CLASS_NAME, null, this.className);
	}

	/**
	 * @return
	 */
	public String getCssClassNameForXml() {
		if (className == null || (className != null && className.equals(""))) {
			return "";
		}
		return LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_CLASSNAME + "=\""
				+ className + "\"";
	}

}
