package jp.co.cybec.laxide.model.base;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jdom.Element;

/**
 * x̃fNX
 * 
 * @author tokumaru
 */
public class LetsAjaxLabelModel extends BaseModel {

	public static final String P_VALUE = "_value";

	public static final String P_FOR_COMPONENT_ID = "_forComponentId";

	private String value = "LABEL";

	private String componentWidth = "-1";

	private String componentHeight = "20";

	private String forComponentId = "";

	/**
	 * xvaluelԂ܂
	 * 
	 * @return
	 */
	public String getValue() {
		return this.value;
	}

	/**
	 * .laxt@Cɕۑ邽߂valuelԂ܂B
	 * 
	 * @return
	 */
	private String getValueForXml() {
		if (value == null || (value != null && value.equals(""))) {
			return "";
		}
		return " value=\"" + this.value + "\" ";
	}

	/**
	 * 
	 * 
	 * @param text
	 */
	public void setValue(String text) {
		this.value = text;
		firePropertyChange(P_VALUE, null, text);
	}

	/**
	 * i̕Ԃ܂B
	 * 
	 * @return i̕
	 */
	public String getComponentWidth() {
		return this.componentWidth;
	}

	/**
	 * i̕ݒ肵܂B
	 * 
	 * @param width
	 *            i̕
	 */
	public void setComponentWidth(String width) {
		this.componentWidth = width;
	}

	/**
	 * .laxt@Cɕۑ邽߂̕i̕Ԃ܂B
	 * 
	 * @return i̕
	 */
	private String getComponetWidthForXml() {
		if (componentWidth == null
				|| (componentWidth != null && componentWidth.equals(""))) {
			return " componentWidth=\""
					+ Integer.toString(this.value.length() * 5) + "\"";
		}
		return " componentWidth=\"" + this.componentWidth + "\" ";
	}

	/**
	 * .laxt@Cɕۑ邽߂̕i̍Ԃ܂B
	 * 
	 * @return i̍
	 */
	private String getComponetHeightForXml() {
		if (componentHeight == null
				|| (componentHeight != null && componentHeight.equals(""))) {
			return " componentHeight=\"20\"";
		}
		return " componentHeight=\"" + this.componentHeight + "\" ";
	}

	/**
	 * .laxt@Cɕۑ邽߂̕iforComponentIdԂ܂B ID̓x^Oforlɂ܂B
	 * 
	 * @return
	 */
	private String getForComponentIdForXml() {
		if (this.forComponentId == null
				|| (this.forComponentId != null && ""
						.equals(this.forComponentId))) {
			return " ";
		}
		return " forComponentId=\"" + this.forComponentId + "\" ";
	}

	/**
	 * i̍Ԃ܂B
	 * 
	 * @return i̍
	 */
	public String getComponetHeight() {
		return this.componentHeight;
	}

	/**
	 * i̍ݒ肵܂B
	 * 
	 * @param componentHeight
	 *            i̍
	 */
	public void setComponentHeight(String componentHeight) {
		this.componentHeight = componentHeight;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getPropertyDescriptors()
	 */
	public IPropertyDescriptor[] getPropertyDescriptors() {
		IPropertyDescriptor[] descriptors = new IPropertyDescriptor[] {
				new TextPropertyDescriptor(P_ID, "ID"),
				new TextPropertyDescriptor(P_VALUE, "eLXg"),
				new TextPropertyDescriptor(P_CLASS_NAME, "CSSNX"),
				new TextPropertyDescriptor(P_FOR_COMPONENT_ID, "֘A镔iID") };
		return descriptors;

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getPropertyValue(java.lang.Object)
	 */
	public Object getPropertyValue(Object id) {
		if (id.equals(super.P_ID)) {
			return super.id;
		}
		if (id.equals(P_VALUE)) {
			return value;
		} else if (id.equals(P_FOR_COMPONENT_ID)) {
			return forComponentId;
		} else if (id.equals(P_CLASS_NAME)) {
			return getCssClassName();
		}

		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#isPropertySet(java.lang.Object)
	 */
	public boolean isPropertySet(Object id) {
		if (id.equals(P_VALUE) || id.equals(P_FOR_COMPONENT_ID)
				|| id.equals(P_CLASS_NAME)) {
			return true;
		} else {
			return false;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setPropertyValue(java.lang.Object,
	 *      java.lang.Object)
	 */
	public void setPropertyValue(Object id, Object value) {
		if (id.equals(P_VALUE)) {
			// eLXgύX
			setValue((String) value);
		} else if (id.equals(P_FOR_COMPONENT_ID)) {
			setForComponentId((String) value);
		} else if (id.equals(P_CLASS_NAME)) {
			setCssClassName((String) value);
		}
	}

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getBodyComponentXml()
	 */
	@Override
	public String getBodyComponentXml() {
		StringBuilder builder = new StringBuilder();

		builder.append(getValueForXml());
		builder.append(this.getComponetWidthForXml());
		builder.append(this.getComponetHeightForXml());
		builder.append(getCssClassNameForXml());
		builder.append(getForComponentIdForXml());

		return builder.toString();

	}

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setAttribute(org.jdom.Element)
	 */
	@Override
	public void setAttribute(Element element) {
		super.setAttribute(element);
		String value = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_VALUE);
		String forComponentId = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_FOR_COMPONENT_ID);

		String cssClass = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_CLASSNAME);

		setCssClassName(cssClass);
		setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_LABEL);
		setForComponentId(forComponentId);

		this.setValue(value);
	}

	/**
	 * forlԂ܂B
	 * 
	 * @return forComponentId forl
	 */
	public String getForComponentId() {
		return this.forComponentId;
	}

	/**
	 * forlݒ肵܂B
	 * 
	 * @param forComponentId
	 *            forl
	 */
	public void setForComponentId(String forComponentId) {
		this.forComponentId = forComponentId;
	}
}
