package jp.co.cybec.laxide.model.base;

import jp.co.cybec.laxide.util.LetsAjaxUtil;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jdom.Element;

/**
 * eLXgGÃfNX
 * eLXgGA̓vpeB̐ݒAsƕ͂邽߁AI
 * {|IDEɕ\Ă
 * 
 * @author tokumaru
 *
 */
public class LetsAjaxTextAreaModel extends BaseModel {
	private String name = "name";

	public static final String P_NAME = "_name";

	private String value = "value";

	public static final String P_VALUE = "_value";

	private String cols = "20";

	public static final String P_COLS = "_cols";

	private String rows = "5";

	public static final String P_ROWS = "_rows";

	public static final String P_EVENT = "_event";

	public static final String P_DATASOURCE_ID = "_dataSourceId";

	private String dataSourceId = "dataSourceId";

	private int eventId = 1;

	private String events[] = {"", "onClick", "onDblClick ", "onMouseDown",
			"onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseUp",
			"onMouseOver", "onMouseOut", "onMouseMove", "onChange", "onSelect" };

	/**	̔{ */
	private static int WIDTH_SCALE = 8;
	
	/**	̔{ */
	private static int HEGHT_SCALE = 10;
	
	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.BaseModel#getBodyComponentXml()
	 */
	@Override
	public String getBodyComponentXml() {
		String html = "";
		html = html + getNameForXml();
		html = html + getValueForXml();
		html = html + getColsForXml();
		html = html + getRowsForXml();
		html = html + getCssClassNameForXml();
		html = html + getEventForXml() + getDataSourceIdForXml();
		return html;
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setAttribute(org.jdom.Element)
	 */
	@Override
	public void setAttribute(Element element) {
		super.setAttribute(element);
		String id = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_ID);
		super.setId(id);
		super.setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_TEXTAREA);
		setName(element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_NAME));
		setValue(element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_VALUE));
		setCols(element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_COLS));
		setRows(element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_ROWS));
		setConstraint(new Rectangle(Integer.parseInt(super.getX()), Integer
				.parseInt(super.getY()), Integer.parseInt(getCols()), Integer
				.parseInt(getRows())));
		String event = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_EVENT);
		String dataSourceId = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_DATASOURCEID);
		String cssClass = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_CLASSNAME);
		
		setCssClassName(cssClass);
		setDataSourceId(dataSourceId);
		setEventId(1);
		for (int i = 0; i < events.length; i++) {
			if (event != null && event.equals(events[i])) {
				setEventId(i + 1);
				break;
			}
		}
	}

	/**
	 * eLXgGAݒ肵܂
	 * 
	 * @param valvue eLXgGA
	 */
	public void setName(String valvue) {
		this.name = LetsAjaxUtil.checkNull(valvue);
		firePropertyChange(P_NAME, null, value);
	}

	/**
	 * eLXgGAԂ܂
	 * 
	 * @return eLXgGA
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * .laxɐݒ肷邽߂̃eLXgGAԂ܂
	 * 
	 * @return .laxɐݒ肷邽߂̃eLXgGA
	 */
	private String getNameForXml() {
		if (this.name == null || (this.name != null && this.name.equals(""))) {
			return "";
		}
		return " name=\"" + this.name + "\" ";
	}

	/**
	 * eLXgGAValuelݒ肵܂
	 * 
	 * @param value eLXgGAValuel
	 */
	public void setValue(String value) {
		this.value = LetsAjaxUtil.checkNull(value);
		firePropertyChange(P_VALUE, null, value);
	}

	/**
	 * eLXgGAValuelԂ܂
	 * 
	 * @return eLXgGAValuel
	 */
	public String getValue() {
		return this.value;
	}

	/**
	 * .laxt@Cɐݒ肷邽߂ValuelԂ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂Valuel
	 */
	private String getValueForXml() {
		if (this.value == null || (this.value != null && this.value.equals(""))) {
			return "";
		}
		return " value=\"" + this.value + "\"";
	}

	/**
	 * colsݒ肵܂
	 * 
	 * @param value cols
	 */
	public void setCols(String value) {
		this.cols = value;
		
		if (getConstraint() != null) {
			// RRŐɍݒ肷邱Ƃɂă}EXł̑傫ύXsɂĂ
			getConstraint().width = Integer.parseInt(this.cols) * WIDTH_SCALE;
		}
		
		firePropertyChange(P_COLS, null, String.valueOf(Integer.parseInt(value) * WIDTH_SCALE));
	}

	/**
	 * colslԂ܂
	 * 
	 * @return colsl
	 */
	public String getCols() {
		return String.valueOf(Integer.parseInt(this.cols) * WIDTH_SCALE);
	}

	/**
	 * .laxt@Cɐݒ肷colslԂ܂
	 * 
	 * @return .laxt@Cɐݒ肷colsl
	 */
	private String getColsForXml() {
		if (this.cols == null || (this.cols != null && this.cols.equals(""))) {
			return "";
		}
		return " cols=\"" + this.cols + "\" ";
	}

	/**
	 * rowslݒ肵܂
	 * 
	 * @param value rowsl
	 */
	public void setRows(String value) {
		this.rows = value;
		
		if (getConstraint() != null) {
			// RRŐɍݒ肷邱Ƃɂă}EXł̑傫ύXsɂĂ
			getConstraint().height = Integer.parseInt(this.rows) * HEGHT_SCALE;
		}
		
		firePropertyChange(P_ROWS, null, String.valueOf(Integer.parseInt(value) * HEGHT_SCALE));
	}

	/**
	 * rowslԂ܂
	 * 
	 * @return rowsl
	 */
	public String getRows() {
		return String.valueOf(Integer.parseInt(this.rows) * HEGHT_SCALE);
	}

	/**
	 * .laxt@Cɐݒ肷邽߂rowslԂ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂rowsl
	 */
	private String getRowsForXml() {
		if (this.rows == null || (this.rows != null && this.rows.equals(""))) {
			return "";
		}
		return " rows=\"" + this.rows + "\" ";
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getPropertyDescriptors()
	 */
	public IPropertyDescriptor[] getPropertyDescriptors() {
		IPropertyDescriptor[] descriptors = new IPropertyDescriptor[] {
				new TextPropertyDescriptor(P_ID, "ID"),
				new TextPropertyDescriptor(P_NAME, ""),
				new TextPropertyDescriptor(P_VALUE, "l"),
				new TextPropertyDescriptor(P_COLS, ""),
				new TextPropertyDescriptor(P_ROWS, "s"),
				new TextPropertyDescriptor(P_CLASS_NAME, "CSSNX"),
				new ComboBoxPropertyDescriptor(P_EVENT, "Cxg", events),
				new TextPropertyDescriptor(P_DATASOURCE_ID, "DATASOURCEID") };
		return descriptors;
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getPropertyValue(java.lang.Object)
	 */
	public Object getPropertyValue(Object id) {
		if (id.equals(P_ID)) {
			return super.id;
		} else if (id.equals(P_NAME)) {
			return this.name;
		} else if (id.equals(P_VALUE)) {
			return this.value;
		} else if (id.equals(P_COLS)) {
			return this.cols;
		} else if (id.equals(P_ROWS)) {
			return this.rows;
		} else if (id.equals(P_EVENT)) {
			return new Integer(this.eventId - 1);
		} else if (id.equals(P_DATASOURCE_ID)) {
			return dataSourceId;
		} else if (id.equals(P_CLASS_NAME)) {
			return getCssClassName();
		}
		
		return null;
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#isPropertySet(java.lang.Object)
	 */
	public boolean isPropertySet(Object id) {
		if (id.equals(P_NAME)) {
			return true;
		} else if (id.equals(P_VALUE)) {
			return true;
		} else if (id.equals(P_COLS)) {
			return true;
		} else if (id.equals(P_ROWS)) {
			return true;
		} else if (id.equals(P_EVENT)) {
			return true;
		} else if (id.equals(P_DATASOURCE_ID)) {
			return true;
		} else if (id.equals(P_CLASS_NAME)) {
			return true;
		} else {
			return false;
		}
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setPropertyValue(java.lang.Object, java.lang.Object)
	 */
	public void setPropertyValue(Object id, Object value) {
		if (id.equals(P_NAME)) {
			setName((String) value);
		} else if (id.equals(P_VALUE)) {
			setValue((String) value);
		} else if (id.equals(P_COLS)) {
			setCols(LetsAjaxUtil.getDigitValue(this.cols, (String)value));
		} else if (id.equals(P_ROWS)) {
			setRows(LetsAjaxUtil.getDigitValue(this.rows, (String)value));
		} else if (id.equals(P_EVENT)) {
			setEventId(((Integer) value).intValue() + 1);
		} else if (id.equals(P_DATASOURCE_ID)) {
			setDataSourceId((String) value);
		} else if (id.equals(P_CLASS_NAME)) {
			setCssClassName((String) value);
		}
	}

	/**
	 * f[^\[XIDԂ܂
	 * 
	 * @return dataSourceId f[^\[XID
	 */
	public String getDataSourceId() {
		return dataSourceId;
	}

	/**
	 * f[^\[XIDݒ肵܂
	 * 
	 * @param dataSourceId f[^\[XID
	 */
	public void setDataSourceId(String dataSourceId) {
		this.dataSourceId = LetsAjaxUtil.checkNull(dataSourceId);
		firePropertyChange(P_DATASOURCE_ID, null, dataSourceId);
	}

	/**
	 * .laxɐݒ肷邽߂̃f[^\[XIDԂ܂
	 * 
	 * @return .laxɐݒ肷邽߂̃f[^\[XID
	 */
	private String getDataSourceIdForXml() {
		if (this.dataSourceId == null
				|| (this.dataSourceId != null && this.dataSourceId.equals(""))) {
			return "";
		}
		return " dataSourceId=\"" + this.dataSourceId + "\"";
	}

	/**
	 * CxgIDԂ܂
	 * 
	 * @return event CxgID
	 */
	public int getEventId() {
		return eventId;
	}

	/**
	 * CxgIDݒ肵܂
	 * 
	 * @param event CxgID
	 */
	public void setEventId(Integer eventId) {
		this.eventId = LetsAjaxUtil.checkNull(eventId);
		
		firePropertyChange(P_EVENT, null, this.eventId);
	}

	/**
	 * .laxt@Cɐݒ肷邽߂̃CxgIDԂ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂̃CxgID
	 */
	private String getEventForXml() {
		return " event=\"" + events[eventId - 1] + "\"";
	}
}
