/**
 * vWFNg laxIde
 * NX LetsAjaxJSControlModel.java
 * 쐬: 2007/06/07
 * 
 */
package jp.co.cybec.laxide.model.js;

import jp.co.cybec.laxide.model.base.LetsAjaxLayoutConstant;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jdom.Element;

/**
 * {IJavaScriptɑ郂f t@CFLetsAjaxJSControlModel.java
 * 
 * @author nakamura 쐬F10:22:34
 * 
 */
public class LetsAjaxJSControlModel extends JSBaseModel {

	public static final String P_JSNAME = "_jsName";

	public static final String P_COMPONENTID = "_componentId";

	private String jsName = "testFunction";

	private String componentId = ""; // ^[QbgR|[lgIDw

	public String getJsName() {
		return this.jsName;
	}

	private String getJsNameForXml() {
		if (jsName == null || (jsName != null && jsName.equals(""))) {
			return "";
		}
		return " jsName=\"" + this.jsName + "\" ";
	}

	public void setJsName(String text) {
		this.jsName = text;
		firePropertyChange(P_JSNAME, null, text);
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		IPropertyDescriptor[] descriptors = new IPropertyDescriptor[] {
				new TextPropertyDescriptor(P_COMPONENTID, "R|[lgID"),
				new TextPropertyDescriptor(P_JSNAME, "JSt@C") };
		return descriptors;

	}

	public Object getPropertyValue(Object id) {
		if (id.equals(P_JSNAME)) {
			// vpeBEr[ɕ\f[^Ԃ
			return jsName;
		} else if (id.equals(P_COMPONENTID)) {
			return componentId;
		}
		return null;
	}

	public boolean isPropertySet(Object id) {
		if (id.equals(P_JSNAME) || id.equals(P_COMPONENTID)) {
			return true;
		} else {
			return false;
		}
	}

	public void setPropertyValue(Object id, Object value) {
		if (id.equals(P_JSNAME)) {
			// eLXgύX
			setJsName((String) value);
		} else if (id.equals(P_COMPONENTID)) {
			setComponentId((String) value);
		}
	}

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getBodyComponentXml()
	 */
	@Override
	public String getBodyComponentXml() {
		return getJsNameForXml() + getComponentForXml();
	}

	private String getComponentForXml() {
		if (componentId == null
				|| (componentId != null && componentId.equals(""))) {
			return "";
		}
		return " componentId=\"" + this.componentId + "\" ";
	}

	/**
	 * @return componentId
	 */
	public String getComponentId() {
		return componentId;
	}

	/**
	 * @param componentId
	 *            componentId ݒB
	 */
	public void setComponentId(String componentId) {
		this.componentId = componentId;
		firePropertyChange(P_COMPONENTID, null, componentId);
	}

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setAttribute(org.jdom.Element)
	 */
	@Override
	public void setAttribute(Element element) {
		super.setAttribute(element);
		setType(LetsAjaxLayoutConstant.LETSAJAX_JS_SAMPLE_FUNCTION);
		String jsName = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_JSNAME);
		setJsName(jsName);
	}
}
