<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Engine
 *
 * @author Administrator
 */

class Engine {

    public $request = null;
    public $view = true;

    /**
     * コンストラクタ
     */
    public function __construct(){
	require_once(dirname(__FILE__) . '/core/config.php');
	$yaml = $this->yaml(BASE . "config/ini.yml");
	$this->name = $yaml['name'];
	require_once(BASE . 'Control.php');
    }

    /**
     * YAMLファイルを取得、パースする
     * 
     * @param type String $yaml
     * @return type YAML
     */
    public function yaml($yaml){
	require_once(BASE . 'lib/spyc.php');
	$spyc = new Spyc();
	return $spyc->YAMLLoad($yaml);
    }

    /**
     * Engineオブジェクトを返す
     * @return Engine
     */
    public function getEngine(){
	return $this;
    }

    /**
     * フレームワーク実行
     * 
     */
    public function execute(){
	
	foreach($_GET as $key => $val){
	    $_GET[$key] = preg_replace('/\x00|\00/', '', htmlspecialchars(trim($val), ENT_QUOTES));
	}

	$page = !$_GET['action'] ? 'index' : $_GET['action'] ;

	if(!method_exists('Control', $page)){
	    return true;
	}

	    require_once(CORE . 'Request_Engine.php');
	    $this->request = new Request_Engine($page);
//	    if(is_null($this->request->error) && !$this->request->error && !$this->request->is_request_post) {
//		$trans = Control::$page();
//	    }
	    if(is_null($this->request->error) && !$this->request->error) {
		$trans = Control::$page();
	    }

	    if(is_null($this->request->error) && !$this->request->error && $this->request->is_request_post && $trans) {
		Control::$trans();
	    }

	    if($this->output){
		$this->request->form = $this->output;
	    }
	    
//	    if(is_null($this->request->error)) Control::$page();
//	    if($this->request->is_request) {
//		Control::$page();
//	    }
	    if(is_file(BASE . 'view/' . $page . '.php') && $this->view === true){
		require_once(BASE . 'view/' . $page . '.php');
	    }
    }

    /**
     * モデルのクラスファクトリー
     * 
     * @param type String $name
     * @return Model
     */
    public function getModel($name){
	require_once(BASE . 'config/db.php');
	require_once(CORE . 'Request_Engine.php');
	Request_Engine::__construct($name);
	require_once(CORE . 'Model_Engine.php');
	require_once(BASE . "model/{$name}.php");
	return new $name($name);
    }

    /**
     * 遷移
     * 
     * @param type $name
     */
    public function display($name){
	require_once(CORE . 'Request_Engine.php');
//	$this->request = new Request_Engine($_GET['action']);
	if(in_array($name, $_GET)) return false;
	Control::$name();
	$this->view = false;
	if(is_file(BASE . "view/{$name}.php")){
	    require_once(BASE . "view/{$name}.php");
	}
    }
    
    /**
     * セッション取得
     * 
     * @param type String $key
     * @return Session_Engine 
     */
    protected function getSession($key){
	require_once(CORE . 'Session_Engine.php');
	return new Session_Engine($key);
    }
}
?>