<?php
/*
 ロジックモデル層のコア部分
 */

/**
 * Model_Engine
 *
 * @author panasocli
 */
abstract class Model_Engine extends Engine {

    public $dbconfig = null;
    public $db = null;
    public $table = null;
    public $result = null;
    public $db_plugin = null;
    public $set = null;
    public $pk = null;
    public $index = null;
    public $where = null;
    public $value = null;
    public $order = null;

    /**
     * コンストラクタ
     *
     * @param string $name
     */
    public function  __construct($name) {
	parent::__construct();
	$this->dbconfig = new DBConfig();
	if(!is_file(DB_PLUGIN . "{$this->dbconfig->dbconfig['plugin']}.php")){
	    return false;
	}
	require_once(DB_PLUGIN . "{$this->dbconfig->dbconfig['plugin']}.php");
	$this->db_plugin = new $this->dbconfig->dbconfig['plugin']($this->dbParser());
	$this->db = $this->db_plugin->__construct($this->dbParser());
	if($this->dbconfig->dbconfig['utf8'] === true) $this->db->query('SET NAMES UTF8');
	if($this->dbconfig->dbconfig['orm'] === false) return true;
	$this->table = $name;
	$this->dbAnalyzer();
    }

    /**
     * SELECTのソート順を決定する
     *
     * @param string $key
     * @param string $sort
     */
    public function order($key, $sort='DESC'){
	$this->order = $sort != 'DESC' && $sort != 'ASC' ? " ORDER BY {$key} ASC " :  " ORDER BY {$key} {$sort} " ;
    }

    /**
     * 取得する個数を設定する
     *
     * @param int $start
     * @param int $num
     */
    public function limit($start=0, $num=1){
	if($num !== 0){
	    $this->limit = array('start' => 'LIMIT ' . $start, 'num' => ',' . $num);
	}
    }

    /**
     * DBからデータを取得するよう命令する
     *
     * @param Variable $where
     * @param Variable $value
     */
    public function select($where=null, $value=null){
	if($this->dbconfig->dbconfig['orm'] === false) return true;
	$this->where = $where;
	$this->value = $value;
	$sql = "SELECT * FROM `{$this->table}` WHERE ";
	if(is_array($where) && count($where) === count($value)){
	    foreach($where as $key => $val){
		$temp[] = is_numeric($value[$key]) ? "{$val} = {$value[$key]} " : "{$val} = '{$value[$key]}' ";
	    }
	    $sql .= implode(' AND ', $temp);
	    $db = $this->db->query($sql . $this->order . $this->limit['start'] . $this->limit['num']);
	    $this->result = $this->db_plugin->get($db);
	}elseif(is_null($where)){
	    $sql = "SELECT * FROM `{$this->table}`";
	    $db = $this->db->query($sql . $this->order . $this->limit['start'] . $this->limit['num']);
	    $this->result = $this->db_plugin->get($db);
	}else{
	    $sql = "SELECT * FROM `{$this->table}` WHERE {$where} = {$value}";
	    $db = $this->db->query($sql . $this->order . $this->limit['start'] . $this->limit['num']);
	    $this->result = $this->db_plugin->get($db);
	}
    }

    /**
     * データを取得する(get前にselectメソッドの実行が必要)
     *
     * @param string $column 取得元のカラム
     * @param int $num 取得個数
     * @return Array
     */
    public function get($column=null, $num=null){
	if($this->dbconfig->dbconfig['orm'] === false) return true;
	if(is_null($num)){
	    foreach($this->result as $val){
		$vals[] = $val[$column];
	    }
	    return $vals;
	}else{
	    return $this->result[$num][$column];
	}
    }

    /**
     * 同レコードの指定された列全てを取得する
     *
     * @return Array
     */
    public function getAll(){
	if($this->dbconfig->dbconfig['orm'] === false) return true;
	return $this->result;
    }

    /**
     * 同レコード全体を取得する
     *
     * @return Array
     */
    public function getOne(){
	if($this->dbconfig->dbconfig['orm'] === false) return true;
	return $this->result[0];
    }

    /**
     * OR/Mにデータをセットする
     *
     * @param string $column 指定先のカラム
     * @param Variable 値
     */
    public function set($column=null, $value=null){
	if($this->dbconfig->dbconfig['orm'] === false) return true;
	$this->set[$column] = $value;
    }

    /**
     * データを更新する
     *
     */
    public function update(){
	if($this->dbconfig->dbconfig['orm'] === false) return true;
	$sql = "UPDATE `{$this->table}` SET ";
	foreach($this->set as $key => $val){
	    $vals[] = " {$key} = '{$val}' ";
	}
	$sql .= implode(', ', $vals);
	if(is_array($this->where) && count($this->where) === count($this->value)){
	    foreach($this->where as $key => $val){
		$temp[] = "{$val} = '{$this->value[$key]}' ";
	    }
	    $sql .= ' WHERE ' . implode(' AND ', $temp);
	}elseif(is_null($this->where)){
	}else{
	    $sql .= "WHERE {$this->where} = {$this->value}";
	}
	$this->db->query($sql);
    }

    /**
     * データを削除する
     *
     */
    public function delete(){
	if($this->dbconfig->dbconfig['orm'] === false) return true;
	$sql = "DELETE FROM `{$this->table}`";
	if(is_array($this->where) && count($this->where) === count($this->value)){
	    foreach($this->where as $key => $val){
		$temp[] = "{$val} = '{$this->value[$key]}' ";
	    }
	    $sql .= ' WHERE ' . implode(' AND ', $temp);
	}elseif(is_null($this->where)){
	}else{
	    $sql .= "WHERE {$this->where} = {$this->value}";
	}
	$this->db->query($sql);
    }

    /**
     * データを追加する
     *
     */
    public function insert(){
	if($this->dbconfig->dbconfig['orm'] === false) return true;
	$sql = "INSERT INTO `{$this->table}` (";
	foreach($this->set as $key => $val){
	    $columns[] = $key;
	    $value[] = is_numeric($val) ? $val : "'{$val}'" ;
	}
	$sql .= implode(',', $columns);
	$sql .= ') VALUES (' . implode(',', $value) . ')';
	$db = $this->db->query($sql);
    }

    /**
     * PEAR DB記法のDB接続設定をパースする
     *
     * @return Array
     */
    private function dbParser(){
	$db = $this->dbconfig->dbconfig['db'];
	$temp = preg_split('/:\/\/|:|@|\/{1}/', $db);
	if(count($temp) < 5){
	    $db = array('driver' => $temp[0],
				'user' =>  $temp[1],
				'host' =>  $temp[2],
				'database' => $temp[3],
				);
	    return $db;
	}
	    $db = array('driver' => $temp[0],
				'user' =>  $temp[1],
				'password' =>  $temp[2],
				'host' => $temp[3],
				'database' => $temp[4],
				);
	    return $db;
    }

    /**
     *
     * データベースを解析する(主キー&インデックスキー取得)
     */
    private function dbAnalyzer(){
	$sql = "SHOW COLUMNS FROM {$this->table}";
	$db = $this->db->query($sql);
	foreach($this->db_plugin->get($db) as $val){
	    if($val['Key'] == 'PRI') $this->pk = $val['Field'];
	    if($val['Key'] == 'MUL') $this->index = $val['Field'];
	}
    }
}
?>