/* Copyright (C) 2021 Momi-g

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

/*SH_doc
title=txt2lit section=1 repnl=\040

@name txt2lit
@_brief conv text to C-lang literal form
@_syno
	txt2lit [-hHV] [-b] [-o ofname] infile
@tl;dr
		@(code)@
	~$ txt2lit mylua.lj		#>> output
	~$ cat mylua.lj | txt2lit -b	#>> array mode with '\0' end
	~$ echo '1"23\' | txt2lit -o out.txt	#>> "1\"23\\\n"
		@()
@_opt
	@(list_o)
	-hHV: usage, version
	-b: output binary array format instead of literal
	-o file: set output to `_file` (dfl@:stdout)
	@()
@_desc
	`txt2lit` outputs quoted strings for C-lang and byte size.
		@(code)--
	--mylua.lua
	print("hw")
	return 0
	
	~$ txt2lit mylua.lua > mylua.h
	~$ cat mylua.h	#>>>
	  "--mylua.lua\n"
	  "print(\"hw\")\n"
	  "return 0\n"
	  / *112* /
	
	// almost the same as:
	// sed -e 's/[\]/&&/g;s/"/\\"/g;s@.*@"&\\n"@g'
		@()--

	output code is used as:
	@(code)--
	#include <stdio.h>
	static const char* str =
		#include "out.txt"
		;
	// const char str[] = ... if use -b option, c99+
	int main(int ac, char** av){
	  puts("text is:");
	  puts(str);
	  return 0;
	}
	@()--
	'-b' opt outputs array syntax {1,2,3...,0} end with '\0'.
	the last '\0' is out of binary size count.
@EXIT_STATUS
	suc/err == 0/not0

@conforming_to	POSIX.1-2001+
@copyright
	Copyright (C) 2021 Momi-g --
@_ver 2021-11-26 v1.0.2
@_see `lbc(3)`
//SH_docE*/
#ifndef txt2lit_5c607fb65f2e
#define txt2lit_5c607fb65f2e

#include <stdio.h>
#include <string.h>
#if ( _POSIX_C_SOURCE +0 < 200112L )
	#include "stop cc: needs compiler posix-2001 or upper(c99+)"
#endif

int txt2lit_main(int ac, char** av);
#endif /* txt2lit_5c607fb65f2e */
