#!/bin/sh
cat << 'EEE' > /dev/null
/* Copyright (C) 2021 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE

set -eu

# path/binary setting
cd `dirname $0`	#base $0 dir
fdir=`pwd`
cd ../..
topdir=`pwd`	#configure root
cp -Rf $fdir ./
cd _tests
wdir=`pwd`
PATH="$wdir:$PATH"
touch log.txt

cp -RLf "$topdir"/src/txt2lit ./
cp -RLf "$topdir"/src/liblbc.a ./
cp -RLf "$topdir"/src/lbc.h ./
#cp -RLf "$topdir"/src/tests.code ./tests.c

eval "`shunit_m`"
echo "--- run binary test: `pwd`/$0
..."

set +e
( set -x

### -- test_maincode
# cc [!_]*.c [!_]*.a -lm -ldl
# _suc
# ./a.out
# _suc

# info
cat <<-'EEE'> _buf.c
	#include <stdio.h>
	int main(){	puts("hw");	return 0; }
EEE
cc _buf.c; _suc
./a.out; _suc

echo "print('from_lua'); return 11" | txt2lit > mylua.txt
_suc

cat <<-'EEE' > _buf.c
	#include <stdio.h>
	#include "lbc.h"
	int main(int argc, char** argv) {
	  lbc_t* obj = lbc_new();
	  const char* s = 
		#include "mylua.txt"
		;
	  int rc = lbc_runstrM(obj, argc, argv, s);
	  lbc_rt val = lbc_tbval(obj, 0, 1);
	  printf("%d\n", val.i);
	  lbc_free(obj);
	  return 0;
	}
	//~$ cc src.c liblbc.a -lm -ldl
EEE
cc _buf.c liblbc.a -lm -ldl; _suc
./a.out; _suc

echo "return function() print('from_luareq'); return 21; end" | txt2lit > mymod.txt
echo "local m = require('mymod'); return m()" | txt2lit > mylua.txt
cat <<-'EEE' > _buf.c
	#include <stdio.h>
	#include "lbc.h"
	int main(int argc, char** argv) {
	  lbc_t* obj = lbc_new();
	  const char* mymod = 
		#include "mymod.txt"
		;
	  const char* mylua = 
		#include "mylua.txt"
		;
	  lbc_reqstrM(obj, mymod);
	  int rc = lbc_runstrM(obj, argc, argv, mylua);
	  lbc_rt val = lbc_tbval(obj, 0, 1);
	  printf("%d\n", val.i);
	  lbc_free(obj);
	  return 0;
	}
	//~$ cc src.c liblbc.a -lm -ldl
EEE
cc _buf.c liblbc.a -lm -ldl; _suc
./a.out; _suc

cat <<-'EEE' > _buf.c
	#include <stdio.h>
	#include <stdlib.h>
	#include "lbc.h"
	int main(int argc, char** argv) {
	  lbc_t* obj = lbc_new();
	  int rc = lbc_runstrM(obj, argc, argv, "print('test') return 13");
	  lbc_rt val = lbc_tbval(obj, 0, 1);
	  printf("%d\n", val.i);
	  if(val.i!=13){exit(1);}
	  
	  const char* s = "a\0bc";
	  const char* fmt = " ffi = require('ffi')"
	  " local str = " LBC_P2S
	  " return str..'xyz'"
	  ;
	  lbc_directf(obj, fmt, s, 4);  // ptr,binsz == "a\0bc", 4
	  val = lbc_tbval(obj, 0, 1);
	  printf("%c %s %s, %d\n", val.tp,val.s,val.s+2,val.sz);
	  // 's', a(\0bcxyz), bcxyz, 7
	  
	  lbc_free(obj);
	  return 0;
	}
	//~$ cc src.c liblbc.a -lm -ldl
EEE
cc _buf.c liblbc.a -lm -ldl; _suc
./a.out; _suc

_res 2>&3
echo "--- SUCCESS for all tests. see $0, log.txt if needs" >&3
) 3>&2 >log.txt 2>&1 
test $? = 0 && flg=0 || flg=1

#clean
#cp -rf "$bdir" "$topdir"
#af=`ls *`
#buf=`printf '%s\n' $af $bf|sort|uniq -u`
#rm -rf $buf

test "$flg" = 0 && exit 0
#err
tail log.txt >/dev/stderr
echo "--- test FAILED, see $0, log.txt" >/dev/stderr
exit 1
