/****************************************************************************/
/* The developnent of this program is partly supported by IPA.              */
/* (Infomation-Technology Promotion Agency, Japan).                         */
/****************************************************************************/

/****************************************************************************/
/*  cloopoptimizer.c                                                        */
/*  Copyright : Copyright (C) 2006 ALPHA SYSTEMS INC.                       */
/*  Authors   : TAN Hideyuki (tanh@alpha.co.jp)                             */
/*              ALPHA SYSTEMS INC. knoppix team (knoppix@alpha.co.jp)       */
/*                                                                          */
/*  This is free software; you can redistribute it and/or modify            */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 2 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This software is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this software; if not, write to the Free Software            */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,  */
/*  USA.                                                                    */
/****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "cloop_optimizer.h"

int main(int argc, char **argv) {

  int ret = 0;

  // arg check
  if (! (argc == 3 || argc ==4)) {
    fprintf(stderr,
	    "%s : Usage <original cloop file> <boot block list> <application block list>\n",
	    argv[0]);
    exit(1);
  }

  do_optimize = 1;
  verbose = 1;

  ret = cloop_optimizer(argv[1], NULL, argv[2], (argc == 4 ? argv[3] : NULL), NULL, NULL);

  if (ret != CLOOP_OPT_OK) {
    char *msg = get_optimizer_message(ret);
    fprintf(stderr, "Err : %s\n", msg);
    if (msg)
      free(msg);
    exit(1);
  }

  exit(0);
}
