/****************************************************************************/
/* The developnent of this program is partly supported by IPA.              */
/* (Infomation-Technology Promotion Agency, Japan).                         */
/****************************************************************************/

/****************************************************************************/
/*  support.c                                                               */
/*  Copyright : Copyright (C) 2006 ALPHA SYSTEMS INC.                       */
/*  Authors : Daisuke Abe (abeda@alpha.co.jp)                               */
/*           ALPHA SYSTEMS INC. knoppix team(knoppix@alpha.co.jp)           */
/*                                                                          */
/*  This is free software; you can redistribute it and/or modify            */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 2 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This software is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this software; if not, write to the Free Software            */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,  */
/*  USA.                                                                    */
/****************************************************************************/

/**
 * Comment for Doxygen
 * @file support.c 
 * @author Daisuke Abe
 * @date 28/11/2005
 */

///Macro Defines
#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <fcntl.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include "cloopprofiler.h"
#include "support.h"
#include "cloop_optimizer.h"

/**
 * @brief lookup_widget - widget lookup function
 * @param[in] parent widget 
 * @param[in] widget name
 * @note generate by glade
 */

GtkWidget *
lookup_widget (GtkWidget * widget, const gchar * widget_name)
{
  GtkWidget *parent, *found_widget;

  for (;;)
    {
      if (GTK_IS_MENU (widget))
	parent = gtk_menu_get_attach_widget (GTK_MENU (widget));
      else
	parent = widget->parent;
      if (!parent)
	parent =
	  (GtkWidget *) g_object_get_data (G_OBJECT (widget),
					   "GladeParentKey");
      if (parent == NULL)
	break;
      widget = parent;
    }

  found_widget = (GtkWidget *) g_object_get_data (G_OBJECT (widget),
						  widget_name);
  if (!found_widget)
    g_warning ("Widget not found: %s", widget_name);
  return found_widget;
}

static GList *pixmaps_directories = NULL;

/* Use this function to set the directory containing installed pixmaps. */
void
add_pixmap_directory (const gchar * directory)
{
  pixmaps_directories = g_list_prepend (pixmaps_directories,
					g_strdup (directory));
}

/* This is an internally used function to find pixmap files. */
static gchar *
find_pixmap_file (const gchar * filename)
{
  GList *elem;

  /* We step through each of the pixmaps directory to find it. */
  elem = pixmaps_directories;
  while (elem)
    {
      gchar *pathname = g_strdup_printf ("%s%s%s", (gchar *) elem->data,
					 G_DIR_SEPARATOR_S, filename);
      if (g_file_test (pathname, G_FILE_TEST_EXISTS))
	return pathname;
      g_free (pathname);
      elem = elem->next;
    }
  return NULL;
}

/* This is an internally used function to create pixmaps. */
GtkWidget *
create_pixmap (GtkWidget * widget, const gchar * filename)
{
  gchar *pathname = NULL;
  GtkWidget *pixmap;

  if (!filename || !filename[0])
    return gtk_image_new ();

  pathname = find_pixmap_file (filename);

  if (!pathname)
    {
      g_warning (_("Couldn't find pixmap file: %s"), filename);
      return gtk_image_new ();
    }

  pixmap = gtk_image_new_from_file (pathname);
  g_free (pathname);
  return pixmap;
}

/* This is an internally used function to create pixmaps. */
GdkPixbuf *
create_pixbuf (const gchar * filename)
{
  gchar *pathname = NULL;
  GdkPixbuf *pixbuf;
  GError *error = NULL;

  if (!filename || !filename[0])
    return NULL;

  pathname = find_pixmap_file (filename);

  if (!pathname)
    {
      g_warning (_("Couldn't find pixmap file: %s"), filename);
      return NULL;
    }

  pixbuf = gdk_pixbuf_new_from_file (pathname, &error);
  if (!pixbuf)
    {
      fprintf (stderr, "Failed to load pixbuf file: %s: %s\n",
	       pathname, error->message);
      g_error_free (error);
    }
  g_free (pathname);
  return pixbuf;
}

/* This is used to set ATK action descriptions. */
void
glade_set_atk_action_description (AtkAction * action,
				  const gchar * action_name,
				  const gchar * description)
{
  gint n_actions, i;

  n_actions = atk_action_get_n_actions (action);
  for (i = 0; i < n_actions; i++)
    {
      if (!strcmp (atk_action_get_name (action, i), action_name))
	atk_action_set_description (action, i, description);
    }
}

/**
 * @brief set_color - set draw color
 * @param[in] target graphic context
 * @param[in] base color
 * @param[in] change rate
 * @param[out] dekiagatta graphic context
 */
GdkGC *
set_color (GdkGC * gc, GdkColor color, gint rate)
{
  gshort change_color = 0;

  change_color = 0x0300 * rate;

  if (rate > 0)
    {
      if (color.red - change_color < color.red)
	color.red -= change_color;
      else
	color.red = 0xeeee;

      if (color.green - change_color < color.green)
	color.green -= change_color;
      else
	color.green = 0xeeee;

      if (color.blue - change_color < color.blue)
	color.blue -= change_color;
      else
	color.blue = 0xeeee;
    }

  gdk_color_alloc (gdk_colormap_get_system (), &color);
  gdk_gc_set_foreground (gc, &color);

  return gc;

}

/**
 * @brief count_read_freq - count read frequency by a block data
 * @param[in] block data a
 * @param[in] block data b
 *
 */
void
count_read_freq (gpointer data, gpointer user_data)
{
  t_block *tmp = (t_block *) data;
  t_block *tmp2 = (t_block *) user_data;

  if (tmp->blk_no == tmp2->blk_no)
    tmp2->draw_freq++;
}


/**
 * @brief blk_progress_reset - reset block progress
 * @param[in] block data
 * @param[in] application running status
 *
 */
void
blk_progress_reset (gpointer data, gpointer user_data)
{
  t_block *blk = (t_block *) data;
  blk->progress = FALSE;
}

/**
 * @brief part_font_init - font setup by a charactor
 * @param[in] font data
 * @param[in] target widget
 * @param[in] font name
 * @param[in] succcess:0 failed:1
 */
gint
parts_font_init (t_font_g2 * font, GtkWidget * widget, char *font_name)
{
  PangoContext *p_context;
  PangoFontMetrics *p_metrics;

  if ((font->font = pango_font_description_from_string (font_name)) == NULL)
    {
      fprintf (stderr,
	       "app_font_init()->pango_font_description_from_string:Failed.\n");
      return 1;
    }
  if ((p_context = gtk_widget_create_pango_context (widget)) == NULL)
    {
      fprintf (stderr,
	       "app_font_init()->gtk_widget_get_pango_context:Failed.\n");
      return 1;
    }
  if ((font->layout = pango_layout_new (p_context)) == NULL)
    {
      fprintf (stderr, "app_font_init()->pango_layout_new:Failed.\n");
      return 1;
    }

  pango_layout_set_font_description (font->layout, font->font);

  p_metrics = pango_context_get_metrics (p_context,
					 font->font,
					 pango_context_get_language
					 (p_context));

  font->width =
    PANGO_PIXELS (pango_font_metrics_get_approximate_digit_width (p_metrics));
  font->ascent = PANGO_PIXELS (pango_font_metrics_get_ascent (p_metrics));
  font->descent = PANGO_PIXELS (pango_font_metrics_get_descent (p_metrics));
  font->height = font->ascent + font->descent;

  g_object_unref (p_context);
  pango_font_metrics_unref (p_metrics);

  return 0;
}

/**
 * @brief app_font_init - font setup to application
 * @param[in] pointer that contains all parameters
 * @param[in] font name
 * @param[in] succcess:0 failed:1
 */
gint
app_font_init (gpointer tmp, char *font_name)
{
  t_app_status *app = (t_app_status *) tmp;

  t_draw *f_blks = &app->blks;
  t_text *f_time = &app->time;
  t_text *f_size = &app->size;
  t_text *f_state = &app->state;

  if (f_blks->font == NULL)
    {
      f_blks->font = malloc (sizeof (t_font_g2));
      if (f_blks->font == NULL)
	{
	  fprintf (stderr, "memory error.\n");
	  abort();
	  //exit (1);
	}
      memset (f_blks->font, '\0', sizeof (t_font_g2));
    }
  parts_font_init (f_blks->font, f_blks->widget, font_name);

  if (f_time->font == NULL)
    {
      f_time->font = malloc (sizeof (t_font_g2));
      if (f_time->font == NULL)
	{
	  fprintf (stderr, "memory error.\n");
	  abort();
	  //exit (1);
	}
      memset (f_time->font, '\0', sizeof (t_font_g2));
    }

  parts_font_init (f_time->font, f_time->widget, font_name);

  if (f_size->font == NULL)
    {
      f_size->font = malloc (sizeof (t_font_g2));
      if (f_size->font == NULL)
	{
	  fprintf (stderr, "memory error.\n");
	  abort();
	  exit (1);
	}
      memset (f_size->font, '\0', sizeof (t_font_g2));
    }

  parts_font_init (f_size->font, f_size->widget, font_name);

  if (f_state->font == NULL)
    {
      f_state->font = malloc (sizeof (t_font_g2));
      if (f_state->font == NULL)
	{
	  fprintf (stderr, "memory error.\n");
	  abort();
	  //exit (1);
	}
      memset (f_state->font, '\0', sizeof (t_font_g2));
    }

  parts_font_init (f_state->font, f_state->widget, font_name);

  return 0;
}

/**
 * @brief get_char_width - get length the string mesured in a pixel
 * @param[in] pango font data
 * @param[in] target charactors
 * @param[in] width as the pixel
 */
gint
get_char_width (PangoFontDescription * pfd, gchar * s)
{
  GtkWidget *widget;
  PangoContext *pc;
  PangoLayout *pl;
  gint width;

  widget = gtk_label_new (NULL);
  pc = gtk_widget_get_pango_context (widget);
  pango_context_set_font_description (pc, pfd);

  pl = pango_layout_new (pc);
  pango_layout_set_text (pl, s, strlen (s));
  pango_layout_get_pixel_size (pl, &width, NULL);

  g_object_unref (G_OBJECT (pl));
  g_object_unref (G_OBJECT (pc));

  gtk_widget_destroy (widget);

  return width;

}

void
thread_flush (void)
{
  GdkDisplay *display = gdk_display_get_default ();
  XFlush (GDK_DISPLAY_XDISPLAY (display));
}

int
file_size_check (gchar *filename)
{
  struct stat st;

  if (lstat (filename, &st) < 0)
    {
      dialog_message("%s %s",filename,ERR_FOPEN);
      return 0;
    }

  return st.st_size;
}

int
regular_file_check (gchar * filename)
{
  struct stat st;

  if (lstat (filename, &st) < 0)
    {
      dialog_message("%s %s",filename,ERR_FOPEN);
      //dialog_message ("File Open Failed.");
      return 0;
    }

  if (!S_ISREG (st.st_mode))
    {
#if 0
      gchar *msg;
      if ((msg = malloc (sizeof (gchar) * 512)) < 0)
	{
	  fprintf (stderr, "memory error.\n");
	  abort();
	  //exit (1);
	}
      memset (msg, '\0', sizeof (gchar) * 512);
      sprintf (msg, "%s is not Regular File.", filename);
      dialog_message (msg);
#endif
      dialog_message("%s %s",filename,ERR_FTYPE);
      return 0;
    }
  return 1;
}
