/****************************************************************************/
/* The developnent of this program is partly supported by IPA.              */
/* (Infomation-Technology Promotion Agency, Japan).                         */
/****************************************************************************/

/****************************************************************************/
/*  callbacks.c                                                             */
/*  Copyright : Copyright (C) 2006 ALPHA SYSTEMS INC.                       */
/*  Authors : Daisuke Abe (abeda@alpha.co.jp)                               */
/*           ALPHA SYSTEMS INC. knoppix team(knoppix@alpha.co.jp)           */
/*                                                                          */
/*  This is free software; you can redistribute it and/or modify            */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 2 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This software is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this software; if not, write to the Free Software            */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,  */
/*  USA.                                                                    */
/****************************************************************************/

/**
 * Comment for Doxygen
 * @file callbacks.c 
 * @author Daisuke Abe
 * @date 28/11/2005
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <errno.h>

#include "cloopprofiler.h"
#include "support.h"
#include "log2list.h"
#include "callbacks.h"
#include "cloop_optimizer.h"

void (*blklst_func[])(GtkWidget*, gpointer)=
{
  create_blklst,
  close_blklst_dialog,
  clean_dialog
};

void (*opt_func[])(GtkWidget*, gpointer)=
{
  select_optimage,
  optimize_clp,
  close_opt_dialog,
  clean_dialog
};

void (*wizard_func[])(GtkWidget*, gpointer)=
{
  select_outputfile,
  acceleration_cloop,
  close_wiz_dialog,
  clean_dialog
};

/**
 * @brisef - clearance_field - clearance draw_field
 * @param[in] pointer who contains all parameters
 */
void
clearance_field (gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_scale *scale = &app->scale;
  GtkWidget *clist = app->list.widget;

  t_run_status *run = ((t_all_data *) tmp)->run;
  t_timer *timer = &run->timer;

  if (timer->timer_tag != 0)
    stop_timer (tmp);
  reset_timer (tmp);
  
  if(timer->t_count!=0)timer->t_count=0;

  scale->adjust->upper = 100;
  gtk_adjustment_set_value (GTK_ADJUSTMENT (scale->adjust),0);

  g_list_foreach (run->blk_list, blk_progress_reset, NULL);

  run->b_loc = 0;
  run->b_edge = 0;
  run->size = 0;
  run->p_timer = 0;

  run->tmp_list = g_list_first (run->blk_list);

  if (clist != NULL)
    {
      dbg ("clist clear.\n");
      gtk_clist_freeze (GTK_CLIST (clist));
      gtk_clist_clear (GTK_CLIST (clist));
    }

}

void
statusbar_change (gpointer tmp, gchar * message)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_state *state = &app->sbar;
  gchar *msg;

  dbg ("message : %s\n", message);

  msg = malloc (sizeof (gchar) * strlen (message) + 1);
  if(msg == NULL)
    {
      fprintf (stderr, "%s\n",ERR_MEMORY);
      abort();
    }
  memset (msg, '\0', sizeof (gchar) * strlen (message) + 1);
  strcpy (msg, message);

  gtk_statusbar_push (GTK_STATUSBAR (state->widget),
		      GPOINTER_TO_INT (state->cid), msg);
}


/**
 * @brief play_label_change
 * @param[in] pointer who contains all parameters
 */
void
play_label_change (gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  //t_draw *blks = &app->blks;

  t_run_status *run = ((t_all_data *) tmp)->run;
  t_play *play = &run->play;

  GtkLabel *label;
  GList *list, *t;

  list = gtk_container_children (GTK_CONTAINER (app->btns.play));
  t = g_list_nth (list, 0);

  label = GTK_LABEL (t->data);

  //No Play
  if (!play->is_play)
    {
      play->is_play = TRUE;
      play->is_pause = FALSE;
      play->frame = 1;
      
      gtk_label_set (label, "||");
    }
  else
    {
      play->is_play = FALSE;
      play->is_pause = TRUE;
      play->r_draw = TRUE;
      play->frame = 0;
      gtk_label_set (label, ">");

    }
}

/**
 *
 *
 */
void
check_name_input_mkrh (GtkEditable * edit, gpointer tmp)
{
  ///Application Status
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;  
  
  if (strlen (gtk_editable_get_chars (GTK_EDITABLE (dialog->blklst_widget->input_entry),0,-1)) > 0 &&
      strlen (gtk_editable_get_chars (GTK_EDITABLE (dialog->blklst_widget->output_entry),0,-1)) > 0)
    gtk_widget_set_sensitive (dialog->next_button[dialog->wid], TRUE);
  else
    gtk_widget_set_sensitive (dialog->next_button[dialog->wid], FALSE);
  return;
  
}

/**
 *
 *
 */
void
check_name_input_opt (GtkEditable * edit, gpointer tmp)
{
  ///Application Status
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;
  
  if (strlen (gtk_editable_get_chars (GTK_EDITABLE (dialog->opt_widget->inputblklst_entry),0,-1)) > 0 &&
      (strlen (gtk_editable_get_chars (GTK_EDITABLE (dialog->opt_widget->inputclp_entry),0,-1)) > 0 &&
       strlen (gtk_editable_get_chars (GTK_EDITABLE (dialog->opt_widget->outputclp_entry),0,-1)) > 0))
    gtk_widget_set_sensitive (dialog->next_button[dialog->wid], TRUE);
  else
    gtk_widget_set_sensitive (dialog->next_button[dialog->wid], FALSE);
  
  return;
}

void
check_name_input_wiz (GtkEditable * edit, gpointer tmp)
{
  ///Application Status
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;
  
  if (strlen (gtk_editable_get_chars (GTK_EDITABLE (dialog->wiz_widget->blklst_entry),0,-1)) > 0 &&
      strlen (gtk_editable_get_chars (GTK_EDITABLE (dialog->wiz_widget->opt_entry),0,-1)) > 0 &&
      strlen (gtk_editable_get_chars (GTK_EDITABLE (dialog->wiz_widget->rblkstat_entry),0,-1)) > 0 &&
      strlen (gtk_editable_get_chars (GTK_EDITABLE (dialog->wiz_widget->noopt_entry),0,-1)) > 0 )
    gtk_widget_set_sensitive (dialog->next_button[dialog->wid], TRUE);
  else
    gtk_widget_set_sensitive (dialog->next_button[dialog->wid], FALSE);
  
  return;
}

void
check_name_input(GtkEditable* edit, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;
  
  switch(dialog->type)
    {
    case BLKLST:
      check_name_input_mkrh(edit, tmp);
      break;
    case OPTIMIZE:
      check_name_input_opt(edit, tmp);
      break;
    case WIZARD:
      check_name_input_wiz(edit, tmp);
      break;
    }
}

/**
 * @brief - window_destroy - window close
 * @param[in] window object
 * @param[in] pointer who contains all parameters
 */
void
window_destroy (GtkObject * object, gpointer tmp)
{
  t_run_status *run = ((t_all_data *) tmp)->run;
  t_result *result = &run->result;
  
  if (result->read_jiffies != 0)
    {
      draw_view (tmp, EV_STOP);
    }

  gtk_main_quit ();
}

/**
 * @brief - on_quit1_activate - quit menu activate - window close
 * @param[in] menu object
 * @param[in] pointer who contains all parameters
 */
void
on_quit1_activate (GtkMenuItem * menuitem, gpointer tmp)
{
  dialog_quit ("Quit Anyway.", tmp);
}

/**
 * @brief - on_info_activate - info menu activate - infomation view
 * @param[in] menu object
 * @param[in] pointer who contains all parameters
 */
void
on_info_activate (GtkMenuItem * menuitem, gpointer tmp)
{
  GtkWidget *dialog, *label, *okbutton;
  GdkPixbuf *pixbuf;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GtkWidget *iconbox;
  //  GError *error;

  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), _("Info..."));
  gtk_window_set_default_size (GTK_WINDOW (dialog), 300, 200);

  label =
    gtk_label_new ("Cloop Reference Profiler\n\nALPHA SYSTEMS Inc. (c) 2006");
  okbutton = gtk_button_new_with_label ("OK");

  //pixbuf = gdk_pixbuf_new_from_file("../icons/cdrom_umount.png",NULL);
  pixbuf = create_pixbuf ("cdrom_unmount.png");
  if (pixbuf == NULL)
    {
      dbg ("file cannnot read.\n");
      return;
    }
  gdk_pixbuf_render_pixmap_and_mask (pixbuf, &pixmap, &mask, 0);
  iconbox = gtk_pixmap_new (pixmap, mask);

  gtk_signal_connect_object (GTK_OBJECT (okbutton),
			     "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy), dialog);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->action_area),
		     okbutton);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), iconbox);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), label);

  gtk_widget_show_all (dialog);

  return;

}

/**
 *
 *
 *
 */
void
analyze_by_name (GtkFileSelection * fselect, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_run_status *run = ((t_all_data *) tmp)->run;
  t_dialog *dialog = &app->dialog_state;

  GtkWidget *list = app->append.list;

  gchar *buf[1];

  buf[0] = malloc (sizeof (gchar) * 512);
  if (buf[0] == NULL)
    {
      fprintf (stderr, "%s\n",ERR_MEMORY);
      abort();
    }
  memset (buf[0], '\0', sizeof (gchar) * 512);

  fselect = GTK_FILE_SELECTION (app->dialog);

  switch (run->fsel)
    {
    case OPEN_LOG:
      strcpy (run->filename,gtk_file_selection_get_filename (GTK_FILE_SELECTION (fselect)));
      gtk_widget_destroy (GTK_WIDGET (fselect));
      analyze_read_log (tmp);
      break;
    case CLP_HEAD:
      strcpy (run->cloopname,gtk_file_selection_get_filename (GTK_FILE_SELECTION (fselect)));
      gtk_widget_destroy (GTK_WIDGET (fselect));
      analyze_cloop (tmp);
      break;
    case IN_LOG:
      strcpy (buf[0],gtk_file_selection_get_filename (GTK_FILE_SELECTION (fselect)));
      if (dialog->window[dialog->wid] != NULL)
	gtk_entry_set_text (GTK_ENTRY (dialog->blklst_widget->input_entry), buf[0]);
      break;
    case IN_LOG_CLP:
      strcpy (buf[0],gtk_file_selection_get_filename (GTK_FILE_SELECTION (fselect)));
      if (dialog->window[dialog->wid] != NULL)
	gtk_entry_set_text (GTK_ENTRY (dialog->opt_widget->inputblklst_entry), buf[0]);
      free (buf[0]);
      break;
    case OUT_LOG:
      strcpy (buf[0],gtk_file_selection_get_filename (GTK_FILE_SELECTION (fselect)));
      if (dialog->window[dialog->wid] != NULL)
	gtk_entry_set_text (GTK_ENTRY (dialog->blklst_widget->output_entry), buf[0]);
      break;
#if 0
    case OUT_LOG_CLP:
      strcpy (buf[0],gtk_file_selection_get_filename (GTK_FILE_SELECTION (fselect)));
      if (dialog->window[dialog->wid] != NULL)
	gtk_entry_set_text (GTK_ENTRY (dialog->opt_widget->outputblklst_entry), buf[0]);
      free (buf[0]);
      break;
#endif /* 0 */
    case IN_CLP:
      strcpy (buf[0],gtk_file_selection_get_filename (GTK_FILE_SELECTION (fselect)));
      if (dialog->window[dialog->wid] != NULL)
	gtk_entry_set_text (GTK_ENTRY (dialog->opt_widget->inputclp_entry), buf[0]);
      free (buf[0]);
      break;
    case OUT_CLP:
      strcpy (buf[0],gtk_file_selection_get_filename (GTK_FILE_SELECTION (fselect)));
      if (dialog->window[dialog->wid] != NULL)
	gtk_entry_set_text (GTK_ENTRY (dialog->opt_widget->outputclp_entry), buf[0]);
      free (buf[0]);
      break;
    case WIZ_BLKLST:
      strcpy (buf[0],gtk_file_selection_get_filename (GTK_FILE_SELECTION (fselect)));
      if (dialog->window[dialog->wid] != NULL)
	gtk_entry_set_text (GTK_ENTRY (dialog->wiz_widget->blklst_entry), buf[0]);
      free (buf[0]);
      break;
    case WIZ_CLP:
      strcpy (buf[0],gtk_file_selection_get_filename (GTK_FILE_SELECTION (fselect)));
      if (dialog->window[dialog->wid] != NULL)
	gtk_entry_set_text (GTK_ENTRY (dialog->wiz_widget->opt_entry), buf[0]);
      free (buf[0]);
      break;
    case APP_IN:
      strcpy (buf[0],gtk_file_selection_get_filename (GTK_FILE_SELECTION (fselect)));
      if (dialog->window[dialog->wid] != NULL)
	{
	  gtk_clist_append (GTK_CLIST(list),buf);
	  dbg("append clist\n");
	}
      //free (buf);
      break;
    default:
      dbg ("hoge-\n");
      break;
    }

  dbg ("analyze over.\n");
  return;
}

void
resensitive_window (GtkObject * widget, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;

  gtk_widget_set_sensitive (app->window, TRUE);
  return;
}

void
resensitive_dialog (GtkObject * widget, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_run_status *run = ((t_all_data *) tmp)->run;
  t_dialog *dialog = &app->dialog_state;  

  dbg("run->fsel : %d\n",run->fsel);

  if(run->fsel < APP_IN)
    {
      if (dialog->window != NULL)
	{
	  gtk_widget_set_sensitive (dialog->window[dialog->wid], TRUE);
	  if (dialog->wid > 1)
	    dialog->wid--;
	}
    }
  else
    {
      gtk_widget_set_sensitive(app->append.window,TRUE);
    }
  return;
}

/**
 * @brief - get_filename get.
 * @param[in] file selector ( will trashed )
 * @param[in] pointer who contains all parameters
 */
void
get_filename (gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_run_status *run = ((t_all_data *) tmp)->run;
  t_dialog *dialog = &app->dialog_state;

  GtkWidget *fselect = NULL;
  fselect = gtk_file_selection_new ("Select File");
  app->dialog = fselect;

  switch (run->fsel)
    {
    case IN_LOG:
    case IN_LOG_CLP:
    case OUT_LOG:
    case OUT_LOG_CLP:
    case IN_CLP:
    case OUT_CLP:
    case WIZ_BLKLST:
    case WIZ_CLP:
    case APP_IN:
    case APPEND:
      gtk_signal_connect (GTK_OBJECT (fselect),
			  "destroy", GTK_SIGNAL_FUNC (resensitive_dialog),
			  (gpointer) tmp);
      break;
    case OPEN_LOG:
    case CLP_HEAD:
      gtk_signal_connect (GTK_OBJECT (fselect),
			  "destroy", GTK_SIGNAL_FUNC (resensitive_window),
			  (gpointer) tmp);
      break;
    default:
      break;
    }

  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fselect)->ok_button),
		      "clicked",
		      GTK_SIGNAL_FUNC (analyze_by_name), (gpointer) tmp);
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (fselect)->ok_button),
			     "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     (gpointer) fselect);
  gtk_signal_connect_object (GTK_OBJECT(GTK_FILE_SELECTION (fselect)->cancel_button),
			     "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     (gpointer) fselect);

  if (run->fsel < 2)
    gtk_widget_set_sensitive (app->window, FALSE);
  else
    {
      if (dialog->window != NULL)
	{
	  if (dialog->window[dialog->wid] != NULL)
	    gtk_widget_set_sensitive (dialog->window[dialog->wid], FALSE);
	}
    }
  gtk_widget_show (fselect);

  return;
}

/**
 * @brief - on_openlog_menu_activate - log file select
 * @param[in] menu item
 * @param[in] pointer who contains all parameters
 */
void
on_openlog_menu_activate (GtkMenuItem * menuitem, gpointer tmp)
{
  t_run_status *run = ((t_all_data *) tmp)->run;
  run->fsel = 0;
  run->is_cloop = FALSE;

  if (run->filename == NULL)
    {
      run->filename = malloc (sizeof (gchar) * NAMELEN);
      if (run->filename == NULL)
	{
	  fprintf (stderr, "%s\n",ERR_MEMORY);
	  abort();
	}
    }
  memset (run->filename, '\0', NAMELEN);
  get_filename (tmp);
}

/**
 * @brief - on_openclp_menu_activate - cloop header read
 * @param[in] menu item
 * @param[in] pointer who contains all parameters
 */
void
on_openclp_menu_activate (GtkMenuItem * menuitem, gpointer tmp)
{
  t_run_status *run = ((t_all_data *) tmp)->run;

  run->fsel = 1;
  run->is_cloop = TRUE;

  if (run->cloopname == NULL)
    {
      run->cloopname = malloc (sizeof (gchar) * NAMELEN);
      if (run->cloopname == NULL)
	{
	  fprintf (stderr, "%s\n",ERR_MEMORY);;
	  abort();
	}
    }
  memset (run->cloopname, '\0', NAMELEN);
  get_filename (tmp);
}

/**
 * @brief on_timemenu_activate - "view->block color->read time" activate
 * @param[in] radio menu item
 * @param[in] pointer who contains all parameters
 */
void
on_timemenu_activate (GtkRadioMenuItem * item, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_draw *blks = &app->blks;
  GtkWidget *mode = app->mode.widget;

  t_run_status *run = ((t_all_data *) tmp)->run;

  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (mode)->entry), "read time");

  run->type = R_TIME;
  statusbar_change (tmp, "drawmode change : draw time");
  draw_initalize (blks->summary_cnt, tmp);
}

/**
 * @brief on_freqmenu_activate - "view->block color->read freq" activate
 * @param[in] radio menu item
 * @param[in] pointer who contains all parameters
 */
void
on_freqmenu_activate (GtkRadioMenuItem * item, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_draw *blks = &app->blks;
  GtkWidget *mode = app->mode.widget;

  t_run_status *run = ((t_all_data *) tmp)->run;

  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (mode)->entry), "read count");

  run->type = R_FREQ;
  statusbar_change (tmp, "drawmode change : draw freq");
  draw_initalize (blks->summary_cnt, tmp);
}

/**
 * @brief on_timefreqmenu_activate - "view->block color->time/count" activate
 * @param[in] radio menu item
 * @param[in] pointer who contains all parameters
 */
void
on_timefreqmenu_activate (GtkRadioMenuItem * item, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_draw *blks = &app->blks;
  GtkWidget *mode = app->mode.widget;

  t_run_status *run = ((t_all_data *) tmp)->run;

  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (mode)->entry), "time/count");
  run->type = R_TIMEF;
  statusbar_change (tmp, "drawmode change : time/freq");
  draw_initalize (blks->summary_cnt, tmp);
}

/**
 * @brief on_freqtimemenu_activate - "view->block color->count\time" activate
 * @param[in] radio menu item
 * @param[in] pointer who contains all parameters
 */
void
on_freqtimemenu_activate (GtkRadioMenuItem * item, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_draw *blks = &app->blks;
  GtkWidget *mode = app->mode.widget;

  t_run_status *run = ((t_all_data *) tmp)->run;

  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (mode)->entry), "count/time");
  run->type = R_FREQT;
  statusbar_change (tmp, "drawmode change : freq/time");
  draw_initalize (blks->summary_cnt, tmp);
}

/**
 * @brief on_rblog_menu_activate - "view->resource mode->read_blocks log" activate
 * @param[in] radio menu item
 * @param[in] pointer who contains all parameters
 */
void
on_rblog_menu_activate (GtkRadioMenuItem * item, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_run_status *run = ((t_all_data *) tmp)->run;

  t_draw *blks = &app->blks;
  t_spin *spin =&app->summary;

#if 0
  GtkWidget *sbtn = app->summary.widget;
  GtkWidget *label = app->summary.label;
  GtkAdjustment *adj = (GtkAdjustment*)app->summary.adj_bc;
  gchar *txt = app->summary.txt;
#endif /* 0 */
  
  GtkObject *adj_tmp = NULL;
  gchar *txt = NULL;
  
  txt = malloc (sizeof (gchar) * 20);
  if (txt == NULL)
    {
      fprintf (stderr, "%s\n",ERR_MEMORY);
      abort();
    }
  memset (txt, '\0', sizeof (gchar) * 20);

  sprintf (txt, "Block/Cell      : ");
  gtk_label_set (GTK_LABEL (spin->label), txt);

  adj_tmp = gtk_adjustment_new (4, 1, 100, 1, 1, 11);
  gtk_spin_button_set_adjustment (GTK_SPIN_BUTTON (spin->widget), GTK_ADJUSTMENT(adj_tmp));
  spin->adj = adj_tmp;

  run->restype = READ_BLOCKS;
  get_summary_cnt(spin);
  check_draw_area (tmp);
  statusbar_change (tmp, "select read_blocks log.");
  draw_initalize (blks->summary_cnt, tmp);
}

/**
 * @brief on_clphead_menu_activate - "view->resource mode->cloop header" activate
 * @param[in] radio menu item
 * @param[in] pointer who contains all parameters
 */
void
on_clphead_menu_activate (GtkRadioMenuItem * item, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_run_status *run = ((t_all_data *) tmp)->run;

  t_draw *blks = &app->blks;
  t_spin *spin =&app->summary;
#if 0
  GtkWidget *sbtn = app->summary.widget;
  GtkWidget *label = app->summary.label;
  GtkAdjustment *adj = (GtkAdjustment*)app->summary.adj_sc;
  gchar *txt = app->summary.txt;
#endif /* 0 */
  GtkObject *adj_tmp = NULL;
  gchar *txt = NULL;

  txt = malloc (sizeof (gchar) * 32);
  if (txt == NULL)
    {
      fprintf (stderr, "%s\n",ERR_MEMORY);
      abort();
    }
  memset (txt, '\0', sizeof (gchar) * 32);

  sprintf (txt, "Size/Cell(KB) : 2^");
  gtk_label_set (GTK_LABEL (spin->label), txt);

  adj_tmp = gtk_adjustment_new (4, 2, 16, 1, 1, 11);
  gtk_spin_button_set_adjustment (GTK_SPIN_BUTTON (spin->widget), GTK_ADJUSTMENT(adj_tmp));
  spin->adj = adj_tmp;

  run->restype = CLOOP_HEADER;
  get_summary_cnt(spin);
  check_draw_area (tmp);
  statusbar_change (tmp, "select cloop header.");
  draw_initalize (blks->summary_cnt, tmp);
}


/**
 *
 *
 */
void
set_select_mode (GtkButton * button, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_run_status *run = ((t_all_data *) tmp)->run;
  t_dialog *dialog = &app->dialog_state;

  t_append *append = &app->append;
  //t_append *append = &wiz_stat->append;

  switch(dialog->type)
    {
    case BLKLST:
      if (button == GTK_BUTTON (dialog->blklst_widget->input_button))
	run->fsel = IN_LOG;
      else if (button == GTK_BUTTON (dialog->blklst_widget->output_button))
	run->fsel = OUT_LOG;
      else run->fsel = -1;
      break;
    case OPTIMIZE:
      if (button == GTK_BUTTON (dialog->opt_widget->inputblklst_button))
	run->fsel = IN_LOG_CLP;
      else if (button == GTK_BUTTON (dialog->opt_widget->inputclp_button))
	run->fsel = IN_CLP;
#if 0
      else if (button == GTK_BUTTON (dialog->opt_widget->outputblklst_button))
	run->fsel = OUT_LOG_CLP;
#endif /* 0 */
      else if (button == GTK_BUTTON (dialog->opt_widget->outputclp_button))
	run->fsel = OUT_CLP;
      else run->fsel = -1;
      break;
    case WIZARD:
      if (button == GTK_BUTTON (dialog->wiz_widget->blklst_button))
	run->fsel = WIZ_BLKLST;
      else if (button == GTK_BUTTON (dialog->wiz_widget->opt_button))
	run->fsel = WIZ_CLP;
      else if (button == GTK_BUTTON (append->append_button))
	{
	  gtk_widget_set_sensitive (app->append.window, FALSE);
	  run->fsel = APP_IN;
	}
      else if (button == GTK_BUTTON (dialog->wiz_widget->append_button))
	run->fsel = APPEND;
      else run->fsel = -1;
      break;
    default:
      run->fsel = -1;
    }
  dbg ("select mode: %d\n", run->fsel);
  
}

void
clean_dialog (GtkWidget *widget,gpointer tmp)
{
  gtk_widget_destroy(GTK_WIDGET(widget->window));
}


void
optimize_stop (GtkWidget * widget, gpointer tmp)
{
  do_optimize = 0;
}

void
make_dialog(GtkWidget* (*mkdialog)(gpointer tmp),
	    void (*dialog_func)(GtkWidget* widget, gpointer tmp),
	    gpointer tmp)
{
  t_app_status *app = ((t_all_data*)tmp)->app;
  t_dialog *dialog = &app->dialog_state;

  dialog->window[dialog->wid] = mkdialog(tmp);

  gtk_signal_connect (GTK_OBJECT (dialog->window[dialog->wid]),
		      "destroy", GTK_SIGNAL_FUNC (resensitive_window),
		      (gpointer) tmp);

  gtk_signal_connect (GTK_OBJECT (dialog->next_button[dialog->wid]),
		      "clicked",
		      GTK_SIGNAL_FUNC (*dialog_func), (gpointer) tmp);
  
  gtk_signal_connect (GTK_OBJECT (dialog->cancel_button[dialog->wid]),
		      "clicked",
		      GTK_SIGNAL_FUNC (optimize_stop), (gpointer) tmp);

  gtk_signal_connect_object (GTK_OBJECT
			     (dialog->cancel_button[dialog->wid]),
			     "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     (gpointer) dialog->window[dialog->wid]);
  
  gtk_widget_set_sensitive (dialog->next_button[dialog->wid], FALSE);
}

void
init_dialog(gint type,
	    gint fcount,
	    gpointer tmp)
{
  t_app_status *app = ((t_all_data*)tmp)->app;
  t_dialog *dialog = &app->dialog_state;
  gint i=0;

  memset(dialog,'\0',sizeof(t_dialog));
  dialog->type = type;

  switch(dialog->type)
    {
    case BLKLST:
      dialog->opt_widget = NULL;
      dialog->wiz_widget = NULL;
      dialog->blklst_widget= malloc(sizeof(t_rblkstat2list));
      if(dialog->blklst_widget == NULL)
	{
	  fprintf (stderr, "%s\n",ERR_MEMORY);
	  abort();
	}
      memset(dialog->blklst_widget,'\0',sizeof(t_rblkstat2list));
      break;
    case OPTIMIZE:
      dialog->blklst_widget = NULL;
      dialog->wiz_widget = NULL;
      dialog->opt_widget= malloc(sizeof(t_clpoptimize));
      if(dialog->opt_widget == NULL)
	{
	  fprintf (stderr, "%s\n",ERR_MEMORY);
	  abort();
	}
      memset(dialog->opt_widget,'\0',sizeof(t_clpoptimize));
      break;
    case WIZARD:
      dialog->opt_widget = NULL;
      dialog->blklst_widget = NULL;
      dialog->wiz_widget= malloc(sizeof(t_wizard));
      if(dialog->wiz_widget == NULL)
	{
	  fprintf (stderr, "%s\n",ERR_MEMORY);
	  abort();
	}
      memset(dialog->wiz_widget,'\0',sizeof(t_wizard));
      break;
    }

  if(dialog->window!=NULL)
    {
      for(i=0;i<(sizeof(dialog->window)/sizeof(GtkWidget *));i++)
	gtk_widget_unref(dialog->window[i]);
    }
  
  dialog->window = malloc (sizeof (GtkWidget *) * fcount);
  if(dialog->window==NULL)
    {
      fprintf (stderr, "%s\n",ERR_MEMORY);
      abort();
    }
  memset (dialog->window, '\0', (sizeof (GtkWidget *) * fcount));
  
  dialog->next_button = malloc (sizeof (GtkWidget *) * fcount);
  if(dialog->next_button==NULL)
    {
      fprintf (stderr, "%s\n",ERR_MEMORY);
      abort();
    }
  memset (dialog->next_button, '\0', (sizeof (GtkWidget *) * fcount));
  dialog->cancel_button = malloc (sizeof (GtkWidget *) * fcount);
  if(dialog->cancel_button==NULL)
    {
      fprintf (stderr, "%s\n",ERR_MEMORY);
      abort();
    }
  memset (dialog->cancel_button, '\0', (sizeof (GtkWidget *) * fcount));
  dialog->wid = 0;

  dialog->file.inputblklst = NULL;
  dialog->file.inputclp = NULL;
  dialog->file.outputblklst = NULL;
  dialog->file.outputclp = NULL;

}
/**
 *
 *
 */
void
close_blklst_dialog (GtkWidget * widget, gpointer tmp)
{
  ///Application Status
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;

  gtk_widget_hide (dialog->window[dialog->wid]);
  dialog->wid++;
  gtk_widget_show (dialog->window[dialog->wid]);


  gtk_signal_connect (GTK_OBJECT (dialog->window[dialog->wid]),
		      "destroy", GTK_SIGNAL_FUNC (resensitive_window),
		      (gpointer) tmp);
  gtk_signal_connect_object (GTK_OBJECT
			     (dialog->next_button[dialog->wid]),
			     "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     (gpointer) dialog->window[dialog->wid]);
}

/**
 *
 *
 *
 */
int
burst_size_setting (GtkWidget *spin)
{
  gint burst_size = 0;
  gint kb = 0;
 
  ///Burst Size Setting

  gdk_threads_enter();
  kb = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin));
  gdk_threads_leave();

  burst_size = 1024;
  while (kb > 1)
    {
      burst_size = burst_size << 1;
      kb = kb >> 1;
    }
  return burst_size;
}

/**
 *
 *
 *
 */
void
blocklist_thread(gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;

  gint modoriti = 0;

  dbg("log2list ni maru-nage\n");
  dbg("input cloop:%s\n",dialog->file.inputclp);
  dbg("output cloop:%s\n",dialog->file.outputclp);
  dbg("blklst:%s\n",dialog->file.inputblklst);
  dbg("marunagemarunage\n");

  modoriti = rblkstat2list(dialog->file.inputblklst,
			   dialog->file.outputblklst,
			   burst_size_setting(dialog->spin.spin),
			   progress_change,
			   tmp);
			   

  dbg("%s\n",get_optimizer_message(modoriti));
  gdk_threads_enter();
  gtk_progress_set_value(GTK_PROGRESS(dialog->progress.bar),100);
  gtk_widget_set_sensitive (dialog->next_button[dialog->wid], TRUE);
  gdk_threads_leave();
}

/**
 *
 *
 */
void
create_blklst (GtkWidget * widget, gpointer tmp)
{
  ///Application Status
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;  

  GThread *th = NULL;
  GError *error = NULL;

  dbg ("create_blocklst.\n");

  dialog->file.inputblklst = malloc (sizeof (gchar) * 512);
  if (dialog->file.inputblklst == NULL)
    {
      fprintf (stderr, "%s\n",ERR_MEMORY);
      abort();
    }
  memset (dialog->file.inputblklst, '\0', sizeof (gchar) * 512);

  strcpy (dialog->file.inputblklst,  gtk_entry_get_text (GTK_ENTRY (dialog->blklst_widget->input_entry)));

  dialog->file.outputblklst = malloc (sizeof (gchar) * 512);
  if (dialog->file.outputblklst == NULL)
    {
      fprintf (stderr, "%s\n",ERR_MEMORY);
      abort();
    }
  memset (dialog->file.outputblklst, '\0', sizeof (gchar) * 512);

  strcpy (dialog->file.outputblklst, gtk_entry_get_text (GTK_ENTRY (dialog->blklst_widget->output_entry)));

  gtk_widget_hide (dialog->window[dialog->wid]);
  dialog->wid++;
  gtk_widget_show (dialog->window[dialog->wid]);

  gtk_signal_connect (GTK_OBJECT (dialog->cancel_button[dialog->wid]),
		      "clicked",
		      GTK_SIGNAL_FUNC (optimize_stop), (gpointer) tmp);
  gtk_signal_connect_object (GTK_OBJECT
			     (dialog->cancel_button[dialog->wid]),
			     "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     (gpointer) dialog->window[dialog->wid]);

  gtk_widget_set_sensitive (dialog->next_button[dialog->wid], FALSE);

  dbg ("init over.\n");

  do_optimize=1;

  //burst_size_setting
  
  //th = g_thread_create (rblkstat2list, tmp, TRUE, &error);
  th = g_thread_create ((GThreadFunc)&blocklist_thread,
			tmp,
			FALSE,
			&error);
  if(!th)
    {
      dbg ("thread create error.\n");
      exit (1);
    }
  
}
/**
 *
 *
 *
 */
void
on_mkrh_menu_activate (GtkMenuItem * menuitem, gpointer tmp)
{
  ///Application Status
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;

  GtkWidget* (*mkdialog[])(gpointer)=
    {
      dialog_blklst_0,
      dialog_blklst_1,
      dialog_blklst_2
    };

  gint fcount = sizeof(mkdialog)/sizeof(GtkWidget *);
  dbg("%d\n",fcount);
  init_dialog(BLKLST,fcount,tmp);
  for(dialog->wid=0;dialog->wid<fcount;dialog->wid++)
    {
      make_dialog(mkdialog[dialog->wid],blklst_func[dialog->wid],tmp);
    }

  gtk_widget_set_sensitive (dialog->next_button[dialog->wid-1], TRUE);
  dialog->wid = 0;

  gtk_widget_set_sensitive(app->window,FALSE);

  gtk_signal_connect (GTK_OBJECT (dialog->blklst_widget->input_button),
		      "clicked",
		      GTK_SIGNAL_FUNC (set_select_mode), (gpointer) tmp);
  gtk_signal_connect_object (GTK_OBJECT (dialog->blklst_widget->input_button),
			     "clicked",
			     GTK_SIGNAL_FUNC (get_filename), (gpointer) tmp);

  gtk_signal_connect (GTK_OBJECT (dialog->blklst_widget->output_button),
		      "clicked",
		      GTK_SIGNAL_FUNC (set_select_mode), (gpointer) tmp);
  gtk_signal_connect_object (GTK_OBJECT (dialog->blklst_widget->output_button),
			     "clicked",
			     GTK_SIGNAL_FUNC (get_filename), (gpointer) tmp);

  gtk_signal_connect (GTK_OBJECT (dialog->blklst_widget->input_entry),
		      "changed",
		      GTK_SIGNAL_FUNC (check_name_input),
		      (gpointer) tmp);
  gtk_signal_connect (GTK_OBJECT (dialog->blklst_widget->output_entry),
		      "changed",
		      GTK_SIGNAL_FUNC (check_name_input),
		      (gpointer) tmp);
  gtk_signal_connect_object (GTK_OBJECT
			     (dialog->cancel_button[dialog->wid]),
			     "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     (gpointer) dialog->window[dialog->wid]);

  gtk_widget_show (dialog->window[dialog->wid]);
}

void
close_opt_dialog (GtkWidget * widget, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;
  //t_clpoptimize *opt_stat = &app->optimize_dialog;

  gtk_widget_hide (dialog->window[dialog->wid]);
  dialog->wid++;
  gtk_widget_show (dialog->window[dialog->wid]);

  gtk_signal_connect (GTK_OBJECT (dialog->window[dialog->wid]),
		      "destroy", GTK_SIGNAL_FUNC (resensitive_window),
		      (gpointer) tmp);
  gtk_signal_connect_object (GTK_OBJECT
			     (dialog->next_button[dialog->wid]),
			     "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     (gpointer) dialog->window[dialog->wid]);
}

void
optimize_thread(gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;

  gint modoriti = 0;

  dbg("optimizer ni maru-nage\n");
  dbg("input cloop:%s\n",dialog->file.inputclp);
  dbg("output cloop:%s\n",dialog->file.outputclp);
  dbg("blklst:%s\n",dialog->file.inputblklst);
  dbg("marunagemarunage\n");

  modoriti = cloop_optimizer(dialog->file.inputclp, 
			     dialog->file.outputclp,
			     dialog->file.inputblklst, 
			     NULL,
			     progress_change, 
			     tmp);

  dbg("%s\n",get_optimizer_message(modoriti));
  gdk_threads_enter();
  gtk_progress_set_value(GTK_PROGRESS(dialog->progress.bar),100);
  gtk_widget_set_sensitive (dialog->next_button[dialog->wid], TRUE);
  gdk_threads_leave();
}

void
optimize_clp (GtkWidget * widget, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;
  
  GThread *th = NULL;
  GError *error = NULL;

  dialog->file.inputblklst = malloc (sizeof (gchar) * 512);
  if (dialog->file.inputblklst == NULL)
    {
      fprintf (stderr, "%s\n",ERR_MEMORY);
      abort();
      //dbg ("memory error.\n");
      //exit (1);
    }
  memset (dialog->file.inputblklst, '\0', sizeof (gchar) * 512);

  strcpy (dialog->file.inputblklst,
	  gtk_entry_get_text (GTK_ENTRY (dialog->opt_widget->inputblklst_entry)));

  dialog->file.inputclp = malloc (sizeof (gchar) * 512);
  if (dialog->file.inputclp == NULL)
    {
      fprintf (stderr, "%s\n",ERR_MEMORY);
      abort();
      //dbg ("memory error.\n");
      //exit (1);
    }
  memset (dialog->file.inputclp, '\0', sizeof (gchar) * 512);

  strcpy (dialog->file.inputclp,
	  gtk_entry_get_text (GTK_ENTRY (dialog->opt_widget->inputclp_entry)));
  dialog->file.outputclp = malloc (sizeof (gchar) * 512);
  if (dialog->file.outputclp == NULL)
    {
      fprintf (stderr, "%s\n",ERR_MEMORY);
      abort();
    }
  memset (dialog->file.outputclp, '\0', sizeof (gchar) * 512);
  strcpy (dialog->file.outputclp,
	  gtk_entry_get_text (GTK_ENTRY (dialog->opt_widget->outputclp_entry)));

  dialog->run = TRUE;

  gtk_widget_hide (dialog->window[dialog->wid]);
  dialog->wid++;
  gtk_widget_show (dialog->window[dialog->wid]);

  gtk_widget_set_sensitive (dialog->next_button[dialog->wid], FALSE);
  
  do_optimize=1;
  
  th = g_thread_create ((GThreadFunc)&optimize_thread,
			tmp,
			FALSE,
			&error);
  if(!th)
    {
      dbg ("thread create error.\n");
      exit (1);
    }

}

/**
 *
 *
 */
void
select_optimage (GtkWidget * widget, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;

  //t_clpoptimize *opt_stat = &app->optimize_dialog;

  gtk_widget_hide (dialog->window[dialog->wid]);
  dialog->wid++;
  gtk_widget_show (dialog->window[dialog->wid]);

  gtk_widget_set_sensitive (dialog->next_button[dialog->wid], FALSE);

  gtk_signal_connect (GTK_OBJECT (dialog->opt_widget->inputblklst_button),
		      "clicked",
		      GTK_SIGNAL_FUNC (set_select_mode), (gpointer) tmp);
  gtk_signal_connect_object (GTK_OBJECT (dialog->opt_widget->inputblklst_button),
			     "clicked",
			     GTK_SIGNAL_FUNC (get_filename), (gpointer) tmp);

  gtk_signal_connect (GTK_OBJECT (dialog->opt_widget->inputclp_button),
		      "clicked",
		      GTK_SIGNAL_FUNC (set_select_mode), (gpointer) tmp);
  gtk_signal_connect_object (GTK_OBJECT (dialog->opt_widget->inputclp_button),
			     "clicked",
			     GTK_SIGNAL_FUNC (get_filename), (gpointer) tmp);

  gtk_signal_connect (GTK_OBJECT (dialog->opt_widget->outputclp_button),
		      "clicked",
		      GTK_SIGNAL_FUNC (set_select_mode), (gpointer) tmp);
  gtk_signal_connect_object (GTK_OBJECT (dialog->opt_widget->outputclp_button),
			     "clicked",
			     GTK_SIGNAL_FUNC (get_filename), (gpointer) tmp);

  gtk_signal_connect (GTK_OBJECT (dialog->opt_widget->inputclp_entry),
		      "changed",
		      GTK_SIGNAL_FUNC (check_name_input), (gpointer) tmp);
  gtk_signal_connect (GTK_OBJECT (dialog->opt_widget->inputblklst_entry),
		      "changed",
		      GTK_SIGNAL_FUNC (check_name_input), (gpointer) tmp);
  gtk_signal_connect (GTK_OBJECT (dialog->opt_widget->outputclp_entry),
		      "changed",
		      GTK_SIGNAL_FUNC (check_name_input), (gpointer) tmp);
}

/**
 *
 *
 *
 */
void
on_optwiz_menu_activate (GtkMenuItem * menuitem, gpointer tmp)
{
  ///Application Status
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;
  //t_clpoptimize *opt_stat = &app->optimize_dialog;

  GtkWidget* (*mkdialog[])(gpointer)=
    {
      dialog_opt_0,
      dialog_opt_1,
      dialog_opt_2,
      dialog_opt_3
    };
  gint fcount = sizeof(mkdialog)/sizeof(GtkWidget *);
  dbg("%d\n",fcount);
  init_dialog(OPTIMIZE,fcount,tmp);
  for(dialog->wid=0;dialog->wid<fcount;dialog->wid++)
    {
      make_dialog(mkdialog[dialog->wid],opt_func[dialog->wid],tmp);
    }
  gtk_widget_set_sensitive (dialog->next_button[dialog->wid-1], TRUE);
  dialog->wid=0;

  gtk_widget_set_sensitive (app->window, FALSE);

  gtk_widget_set_sensitive(dialog->next_button[dialog->wid],TRUE);
  gtk_widget_show (dialog->window[dialog->wid]);
}


void
close_wiz_dialog(GtkWidget *widget, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;
  //t_wizard *wiz_stat = &app->wizard_dialog;

  gtk_widget_hide (dialog->window[dialog->wid]);
  dialog->wid++;
  gtk_widget_show (dialog->window[dialog->wid]);

  gtk_signal_connect (GTK_OBJECT (dialog->window[dialog->wid]),
		      "destroy", GTK_SIGNAL_FUNC (resensitive_window),
		      (gpointer) tmp);
  gtk_signal_connect_object (GTK_OBJECT
			     (dialog->next_button[dialog->wid]),
			     "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     (gpointer) dialog->window[dialog->wid]);
}


void
accelerate_thread(gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;
  t_append *append = &app->append;

  gchar *tmpfile = NULL;
  gint ret = 0;

  tmpfile = malloc(sizeof(gchar)*NAMELEN);
  if(!tmpfile)
    {
      fprintf (stderr, "%s\n",ERR_MEMORY);
      abort();
    }
  memset(tmpfile,'\0',sizeof(gchar)*NAMELEN);

  dbg("Acceleration shimasuyo\n");
  dbg("input cloop:%s\n",dialog->file.inputclp);
  dbg("output cloop:%s\n",dialog->file.outputclp);
  dbg("input rblkfile:%s\n",dialog->file.inputblklst);
  dbg("output listfile:%s\n",dialog->file.outputblklst);
  dbg("applst:%s\n",*append->filename);
  dbg("marunagemarunage\n");

  do_optimize = 1;

  ret = rblkstat2list(dialog->file.inputblklst,
		      dialog->file.outputblklst,
		      burst_size_setting(dialog->spin.spin),
		      progress_change,
		      tmp);

  if(do_optimize != 1 || ret < 0) goto end;

  if(append->filename != NULL)
    {
      dbg("applist make.\n");
#if 0
      ret = appstat2list(append->filename,
			 tmpfile,
			 strlen(append->filename),
			 progress_change,
			 tmp);
#endif
      strcpy(tmpfile, "/tmp/.optimize.applicationlist");
    }

  if(do_optimize != 1 || ret < 0) goto end;

  ret = cloop_optimizer(dialog->file.inputclp, 
			dialog->file.outputclp,
			dialog->file.inputblklst, 
			strlen(tmpfile) == 0 ? NULL : tmpfile,
			progress_change, 
			tmp);
  dbg("%s\n",get_optimizer_message(ret));
  
 end:
  free(append->filename);
  unlink(tmpfile);

  gdk_threads_enter();
  gtk_progress_set_value(GTK_PROGRESS(dialog->progress.bar),100);
  gtk_widget_set_sensitive (dialog->next_button[dialog->wid], TRUE);
  gdk_threads_leave();
}

void
acceleration_cloop(GtkWidget *widget, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_run_status *run = ((t_all_data *) tmp)->run;

  t_dialog *dialog = &app->dialog_state;

  GThread *th = NULL;
  GError *error = NULL;

  dialog->file.inputblklst = malloc (sizeof (gchar) * 512);
  if (dialog->file.inputblklst == NULL)
    {
      fprintf (stderr, "%s\n",ERR_MEMORY);
      abort();
    }
  memset (dialog->file.inputblklst, '\0', sizeof (gchar) * 512);
  strcpy (dialog->file.inputblklst, run->filename);

  dialog->file.inputclp = malloc (sizeof (gchar) * 512);
  if (dialog->file.inputclp == NULL)
    {
      fprintf (stderr, "%s\n",ERR_MEMORY);
      abort();
    }
  memset (dialog->file.inputclp, '\0', sizeof (gchar) * 512);

  strcpy (dialog->file.inputclp, run->cloopname);

  dialog->file.outputclp = malloc (sizeof (gchar) * 512);
  if (dialog->file.outputclp == NULL)
    {
      fprintf (stderr, "%s\n",ERR_MEMORY);
      abort();
    }
  memset (dialog->file.outputclp, '\0', sizeof (gchar) * 512);

  strcpy (dialog->file.outputclp,
	  gtk_entry_get_text (GTK_ENTRY (dialog->wiz_widget->opt_entry)));
  dialog->file.outputblklst = malloc (sizeof (gchar) * 512);
  if (dialog->file.outputblklst == NULL)
    {
      fprintf (stderr, "%s\n",ERR_MEMORY);
      abort();
    }
  memset (dialog->file.outputblklst, '\0', sizeof (gchar) * 512);

  strcpy (dialog->file.outputblklst, gtk_entry_get_text (GTK_ENTRY (dialog->wiz_widget->blklst_entry)));

  gtk_widget_hide (dialog->window[dialog->wid]);
  dialog->wid++;
  gtk_widget_show (dialog->window[dialog->wid]);

  gtk_widget_set_sensitive (dialog->next_button[dialog->wid], FALSE);
  
  do_optimize=1;

  th = g_thread_create ((GThreadFunc)&accelerate_thread, 
			tmp, 
			FALSE, 
			&error);
  if(!th)
    {
      dbg ("thread create error.\n");
      exit (1);
    }
}

#if 0
void
append_application_list(GtkWidget *widget,gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;
  t_append *append = &app->append;

  ///Make append dialog.
  append->window = dialog_append(tmp);

  gtk_widget_set_sensitive(dialog->window[dialog->wid],FALSE);
  gtk_widget_show (append->window);
}
#endif /* 0 */


void
select_outputfile(GtkWidget *widget,gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;

  gtk_widget_hide (dialog->window[dialog->wid]);
  dialog->wid++; 
  gtk_widget_show (dialog->window[dialog->wid]);

  gtk_widget_set_sensitive (dialog->next_button[dialog->wid], FALSE);
  
  gtk_signal_connect (GTK_OBJECT (dialog->wiz_widget->blklst_button),
		      "clicked",
		      GTK_SIGNAL_FUNC (set_select_mode), (gpointer) tmp);
  gtk_signal_connect_object (GTK_OBJECT (dialog->wiz_widget->blklst_button),
			     "clicked",
			     GTK_SIGNAL_FUNC (get_filename), (gpointer) tmp);
#if 0
  gtk_signal_connect(GTK_OBJECT (dialog->wiz_widget->append_button),
		     "clicked",
		     GTK_SIGNAL_FUNC (append_application_list), (gpointer) tmp);
#endif /* 0 */
  gtk_signal_connect (GTK_OBJECT (dialog->wiz_widget->opt_button),
		      "clicked",
		      GTK_SIGNAL_FUNC (set_select_mode), (gpointer) tmp);
  gtk_signal_connect_object (GTK_OBJECT (dialog->wiz_widget->opt_button),
			     "clicked",
			     GTK_SIGNAL_FUNC (get_filename), (gpointer) tmp);

  gtk_signal_connect (GTK_OBJECT (dialog->wiz_widget->blklst_entry),
		      "changed",
		      GTK_SIGNAL_FUNC (check_name_input), (gpointer) tmp);
  gtk_signal_connect (GTK_OBJECT (dialog->wiz_widget->opt_entry),
		      "changed",
		      GTK_SIGNAL_FUNC (check_name_input), (gpointer) tmp);
}

/**
 *
 *
 *
 */
void
on_wizard_menu_activate(GtkMenuItem *menuitem,gpointer tmp)
{
  ///Application Status
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_run_status *run = ((t_all_data *) tmp)->run;
  t_dialog *dialog = &app->dialog_state;

  //t_wizard *wiz_stat = &app->wizard_dialog;
  //t_append *append = &app->append;
  //t_append *append = &wiz_stat->appender;

  GtkWidget* (*mkdialog[])(gpointer)=
    {
      dialog_wiz_0,
      dialog_wiz_1,
      dialog_wiz_2,
      dialog_wiz_3
    };
  gint fcount = sizeof(mkdialog)/sizeof(GtkWidget *);
  dbg("%d\n",fcount);
  init_dialog(WIZARD,fcount,tmp);
  for(dialog->wid=0;dialog->wid<fcount;dialog->wid++)
    {
      make_dialog(mkdialog[dialog->wid],wizard_func[dialog->wid],tmp);
    }
  gtk_widget_set_sensitive (dialog->next_button[dialog->wid-1], TRUE);
  dialog->wid=0;

  gtk_widget_set_sensitive (app->window, FALSE);

  if (run->filename != NULL)
	gtk_entry_set_text (GTK_ENTRY (dialog->wiz_widget->rblkstat_entry), run->filename);
  if (run->cloopname != NULL)
    gtk_entry_set_text (GTK_ENTRY (dialog->wiz_widget->noopt_entry), run->cloopname);

  gtk_widget_set_sensitive(dialog->next_button[dialog->wid],TRUE);
  gtk_widget_show (dialog->window[dialog->wid]);
}

void
reset_rblkstat(GtkWidget* button,gpointer tmp)
{
  system("echo 1 > /proc/cloop/reset_read_blocks");
}

/**
 *
 *
 *
 */
void
on_reset_menu_activate(GtkMenuItem *menuitem,gpointer tmp)
{
  GtkWidget *dialog, *label, *yesbutton, *nobutton;

  dialog = gtk_dialog_new ();
  label = gtk_label_new (MSG_RESET);
  gtk_widget_set_size_request (dialog, 300, 150);

  yesbutton = gtk_button_new_with_label ("Yes");
  nobutton = gtk_button_new_with_label ("No");

  gtk_signal_connect(GTK_OBJECT (yesbutton),
		     "Clicked",
		     GTK_SIGNAL_FUNC (reset_rblkstat), 
		     NULL);
  gtk_signal_connect_object (GTK_OBJECT (yesbutton),
			     "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy), dialog);
  gtk_signal_connect_object (GTK_OBJECT (nobutton),
			     "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy), dialog);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      yesbutton, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      nobutton, TRUE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), label);

  gtk_widget_show_all (dialog);
}



/**
 * @brief - on_drawarea_expose - drawarea expose event
 * @param[in] drawarea widget
 * @param[in] event type
 * @param[in] pointer who contains all parameters
 * @param[out] always FALSE
 */
gboolean
on_drawarea_expose (GtkWidget * widget, GdkEventExpose * event, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_draw *blks = &app->blks;
  GtkWidget *clist = app->list.widget;

  t_run_status *run = ((t_all_data *) tmp)->run;

  if (!blks->pixmap)
    return FALSE;

  //drawarea size check
  blks->width = blks->scrl_win->allocation.width - 2;
  //if unmatch then size matching
  if (run->width != blks->width)
    {
      dbg ("run->width: %d blks->width: %d \n", run->width, blks->width);
      run->width = blks->width;
      check_draw_area (tmp);

      gtk_clist_columns_autosize (GTK_CLIST (clist));
      gtk_clist_thaw (GTK_CLIST (clist));

      draw_view (tmp, EV_STOP);
    }

  blks->gc = widget->style->bg_gc[GTK_STATE_NORMAL];

  gdk_draw_pixmap (widget->window,
		   blks->gc,
		   blks->pixmap,
		   event->area.x, event->area.y,
		   event->area.x, event->area.y,
		   event->area.width, event->area.height);

  return FALSE;
}

/**
 *
 *
 */
GList *
listup_on_drawblock_read_blocks (gpointer tmp, gint bpointer)
{
  t_run_status *run = ((t_all_data *) tmp)->run;
  t_app_status *app = ((t_all_data *) tmp)->app;

  t_draw *blks = &app->blks;

  t_block *block = NULL;
  t_block *tmpblock = NULL;

  GList *list = NULL;
  GList *glist = NULL;
  GList *next = NULL;
  GList *tmplist = NULL;

  gboolean append, prepend;
  gint count = 0;

  glist = g_list_first (run->blk_list);
  append = FALSE;
  prepend = FALSE;

  ///Check Block that were already read.
  while (glist != NULL && count < blks->summary_cnt)
    {
      next = glist->next;
      block = (t_block *) glist->data;
      //dbg("bpointer : %d \n",bpointer);
      //dbg("blk_no");
      ///registration yet
      if (block->blk_no >= bpointer
	  && block->blk_no < (bpointer + blks->summary_cnt)
	  && block->read_no < run->b_edge)
	{
	  if (list != NULL)
	    {
	      tmplist = g_list_first (list);

	      while (tmplist != NULL)
		{
		  tmpblock = (t_block *) tmplist->data;
		  if (tmpblock->blk_no == block->blk_no)
		    {
		      append = FALSE;
		      prepend = FALSE;
		      break;
		    }
		  else if (tmpblock->blk_no < block->blk_no)
		    {
		      append = TRUE;
		      prepend = FALSE;
		    }
		  else if (tmpblock->blk_no > block->blk_no)
		    {
		      prepend = TRUE;
		      append = FALSE;
		    }
		  tmplist = g_list_next (tmplist);
		}
	    }
	  ///unregistration still
	  else if (list == NULL)
	    {
	      list = g_list_append (list, block);
	      //count++;
	    }
	}
      ///insert block at list.
      if (append == TRUE && prepend == FALSE)
	list = g_list_append (list, block);
      else if (prepend == TRUE && append == FALSE)
	list = g_list_prepend (list, block);
      append = FALSE;
      prepend = FALSE;
      glist = next;

      //count++; 
    }
  return list;
}

/**
 *
 *
 *
 */
GList *
listup_on_drawblock_cloop_header (gpointer tmp, glong offset)
{
  t_run_status *run = ((t_all_data *) tmp)->run;
  t_app_status *app = ((t_all_data *) tmp)->app;

  t_draw *blks = &app->blks;

  t_block *block = NULL;
  t_block *tmpblock = NULL;

  GList *list = NULL;
  GList *glist = NULL;
  GList *tmplist = NULL;
  GList *next = NULL;

  gboolean append, prepend;
  gint count = 0;

  glist = g_list_first (run->blk_list);
  append = FALSE;
  prepend = FALSE;

  ///Check Block that were already read.
  while (glist != NULL && count < run->b_loc)
    {
      next = glist->next;
      block = (t_block *) glist->data;

      if ((((block->cloop->offset <= offset)
	    && ((block->cloop->offset + block->cloop->size) >=
		(offset + (blks->summary_cnt * SECTOR_SIZE))))
	   || (((block->cloop->offset + block->cloop->size) >= offset)
	       && ((block->cloop->offset + block->cloop->size) <=
		   (offset + (blks->summary_cnt * SECTOR_SIZE))))
	   || ((block->cloop->offset >= offset)
	       && (block->cloop->offset <=
		   (offset + (blks->summary_cnt * SECTOR_SIZE)))))
	  && block->read_no < run->b_edge)


	{
	  if (list != NULL)
	    {
	      tmplist = g_list_first (list);

	      while (tmplist != NULL)
		{
		  tmpblock = (t_block *) tmplist->data;
		  if (tmpblock->blk_no == block->blk_no)
		    {
		      append = FALSE;
		      prepend = FALSE;
		      break;
		    }
		  else if (tmpblock->blk_no < block->blk_no)
		    {
		      append = TRUE;
		      prepend = FALSE;
		    }
		  else if (tmpblock->blk_no > block->blk_no)
		    {
		      prepend = TRUE;
		      append = FALSE;
		    }

		  tmplist = g_list_next (tmplist);
		}
	    }
	  ///unregistration still
	  else if (list == NULL)
	    {
	      list = g_list_append (list, block);
	    }
	}
      ///insert block at list.
      if (append == TRUE && prepend == FALSE)
	list = g_list_append (list, block);
      else if (prepend == TRUE && append == FALSE)
	list = g_list_prepend (list, block);
      append = FALSE;
      prepend = FALSE;
      glist = next;

      count++;
    }

  return list;

}


/**
 *
 *
 *
 *
 */
GList *
listup_on_drawblock (gpointer tmp, gint bpointer, glong offset)
{
  t_run_status *run = ((t_all_data *) tmp)->run;

  if (run->restype == READ_BLOCKS)
    return listup_on_drawblock_read_blocks (tmp, bpointer);
  else if (run->restype == CLOOP_HEADER)
    return listup_on_drawblock_cloop_header (tmp, offset);

  return NULL;
}

/**
 *
 *
 *
 *
 */
void
make_popup_window (GList * list, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_run_status *run = ((t_all_data *) tmp)->run;

  t_block *block = NULL;
  GString *sbuf;
  GtkWidget *label;

  gint x, y;
  gint w, h;

  x = 0;
  y = 0;

  sbuf = g_string_new ("");
  block = (t_block *) list->data;

  if (list != NULL)
    {
      while (list->prev != NULL)
	{
	  list = list->prev;
	}
    }

  ///popup window
  if (list != NULL)
    {
      h = 15;
      w = 150;

      ///make window's contents
      while (list != NULL)
	{
	  block = (t_block *) (list->data);

	  if (!run->is_cloop)
	    {
	      g_string_sprintfa (sbuf, "blockID:%d size:%d", block->blk_no,
				 block->size);
	      w = 160;
	    }
	  else
	    {
	      g_string_sprintfa (sbuf, "blockID:%d offset:%lu size:%d",
				 block->blk_no, block->cloop->offset,
				 block->size);
	      w = 230;
	    }

	  list = g_list_next (list);
	  if (list == NULL)
	    break;
	  g_string_sprintfa (sbuf, "\n");
	  h += 15;
	}

      label = gtk_label_new (sbuf->str);
      app->popup = gtk_window_new (GTK_WINDOW_POPUP);

      gtk_container_add (GTK_CONTAINER (app->popup), label);
      gtk_widget_set_events (app->popup, GDK_POINTER_MOTION_MASK);

      ///if cursor above this window : bury this window
      g_signal_connect ((gpointer) app->popup,
			"motion_notify_event",
			G_CALLBACK (gtk_widget_destroy), tmp);

      ///Set popup window's position
      gtk_window_set_default_size (GTK_WINDOW (app->popup), w, h);
      gtk_window_set_position (GTK_WINDOW (app->popup), GTK_WIN_POS_MOUSE);
      gtk_window_get_position (GTK_WINDOW (app->popup), &x, &y);

      x += (w / 2 + 10);
      y += (h / 2 + 10);

      gtk_window_move (GTK_WINDOW (app->popup), x, y);

      gtk_widget_show_all (app->popup);

      statusbar_change (tmp, "popup launch");
      dbg ("popup launch.\n");
      g_string_free (sbuf, TRUE);
    }
  return;
}


/**
 * @brief - on_drawarea_press - drawarea popup window active on click
 * @param[in] drawarea widget
 * @param[in] event type
 * @param[in] pointer who contains all parameters
 * @param[out] return TRUE when success popup window 
 */
gint
on_drawarea_press (GtkWidget * widget, GdkEventButton * event, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_run_status *run = ((t_all_data *) tmp)->run;

  t_draw *blks = &app->blks;
  t_popup *popup = &run->popup_list;
  t_block *block = NULL;
  //t_play *play = &run->play;

  GList *list = NULL;
  GdkModifierType state;

  gint x, y;
  gint i, j;

  glong offset = 0;
  gint bpointer = 0;
  gint type = run->type;

  //if(!play->is_play) return FALSE;

  if (run->type == R_TIME)
    type = R_TIME_R;
  else if (run->type == R_FREQ)
    type = R_FREQ_R;
  else if (run->type == R_TIMEF)
    type = R_TIMEF_R;
  else if (run->type == R_FREQT)
    type = R_FREQT_R;

  dbg ("resource type:%d\n", run->restype);

  //get pointer location
  gdk_window_get_pointer (event->window, &x, &y, &state);

  if (x > blks->startx && x < blks->endx && y > blks->starty
      && y < blks->endy)
    {
      ///when run->restype : READ_BLOCKS
      if (run->restype == READ_BLOCKS)
	{
	  i =
	    ((((x - (MARGIN * 2 + blks->bnum_width + MARGIN_2)) / (FRM_WIDTH -
								   1)) *
	      blks->summary_cnt));
	  j =
	    ((((y - (MARGIN + 1)) / (FRM_HEIGHT -
				     1)) * blks->draw_per_line) *
	     blks->summary_cnt);
	  bpointer = j + i;
	}
      else if (run->restype == CLOOP_HEADER)
	{
	  offset =
	    ((((x - (MARGIN * 2 + blks->bnum_width + MARGIN_2)) / (FRM_WIDTH -
								   1)) *
	      (blks->summary_cnt * SECTOR_SIZE)));
	  offset +=
	    ((((y - (MARGIN + 1)) / (FRM_HEIGHT -
				     1)) * blks->draw_per_line) *
	     (blks->summary_cnt * SECTOR_SIZE));
	}
      else
	{
	  return FALSE;
	}

      ///load_block_list method
      list = listup_on_drawblock (tmp, bpointer, offset);
      if (list == NULL)
	return TRUE;
      run->load_list = list;

      make_popup_window (list, tmp);
      list = run->load_list;

      ///paint block to stand out
      if (run->restype == READ_BLOCKS)
	{
	  block = (t_block *) list->data;
	  popup->pblock = block;

	  draw_one_frame (blks, block, F_SEL, 0, tmp);
	  draw_one_block (blks, block, type, 0, tmp);
	}
      else if (run->restype == CLOOP_HEADER)
	{
	  list = g_list_first (list);
	  while (list != NULL)
	    {
	      block = (t_block *) list->data;

	      gint tmpsize = 0;
	      offset = block->cloop->offset;

	      while (tmpsize < block->cloop->size)
		{
		  draw_one_frame (blks, block, F_SEL, offset, tmp);
		  draw_one_block (blks, block, type, offset, tmp);
		  offset += blks->summary_cnt * SECTOR_SIZE;
		  tmpsize += blks->summary_cnt * SECTOR_SIZE;
		}
	      list = g_list_next (list);
	    }
	}
    }
  draw_update (blks);
  return TRUE;
}

  /**
 * @brief on_stop_clicked - stop button widget clicked.
 * @param[in] stop button widget
 * @param[in] pointer who contains all parameters
 */
void
on_stop_clicked (GtkButton * button, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_run_status *run = ((t_all_data *) tmp)->run;
  t_play *play = &run->play;
  t_result *result = &run->result;

  GtkLabel *label;
  GList *list, *t;

  list = gtk_container_children (GTK_CONTAINER (app->btns.play));
  t = g_list_nth (list, 0);

  label = GTK_LABEL (t->data);

  if (result->read_jiffies != 0)
    {
      get_summary_cnt (&app->summary);
      check_draw_area (tmp);
      clearance_field (tmp);
      //play_label_change (tmp);

      draw_view (tmp, EV_STOP);
    }


  gtk_label_set (GTK_LABEL(label), ">");
  play->is_play = FALSE;
  play->is_pause = FALSE;

  statusbar_change (tmp, "Stop.");
}

/**
 * @brief on_play_clicked - play button widget clicked.
 * @param[in] play button widget
 * @param[in] pointer who contains all parameters
 */
void
on_play_clicked (GtkButton * button, gpointer tmp)
{
  t_run_status *run = ((t_all_data *) tmp)->run;

  t_play *play = &run->play;
  t_result *result = &run->result;

  if (result->read_jiffies != 0)
    {
      /// when play state : play
      
      if (play->is_play == FALSE)
	{
	  statusbar_change (tmp, "Play.");
	  
	  //check_draw_area (tmp);
	  
	  play_label_change (tmp);

	  play->is_play = TRUE;
	  play->is_pause = FALSE;
	  play->frame = 1;

	  if(play->is_play)dbg("play.\n");
	  if(play->is_pause)dbg("pause.\n");
	  dbg("play->frame:%d\n",play->frame);

	  draw_timer (tmp);
	}
      /// when play state : playing and not pause
      else if (play->is_play == TRUE)
	{
	  statusbar_change (tmp, "Pause.");
	  pause_playing (tmp);
	  play_label_change (tmp);
	  
	  play->is_play = FALSE;
	  play->is_pause = TRUE;
	  play->r_draw = TRUE;
	  play->frame = 0;
	  
	  if(play->is_play)dbg("play.\n");
	  if(play->is_pause)dbg("pause.\n");
	  dbg("play->frame:%d\n",play->frame);
	  
	}
    }
  else
    {
      statusbar_change (tmp, "Select read_blocks log.");
    }
  return;
}

/**
 * @brief on_rewind_pressed - rewind button widget pressed.
 * @param[in] rewind button widget
 * @param[in] pointer who contains all parameters
 */
void
on_rewind_pressed (GtkButton * button, gpointer tmp)
{
  t_play *play;
  play = &(((t_all_data *) tmp)->run)->play;

  if (play->is_play == TRUE)
    {
      ///Frame rate (that manage playing speed) change.
      statusbar_change (tmp, "rewinding...");
      play->frame = -10;
    }
}

/**
 * @brief on_rewind_released - rewind button widget released.
 * @param[in] rewind button widget
 * @param[in] pointer who contains all parameters
 */
void
on_rewind_released (GtkButton * button, gpointer tmp)
{
  t_play *play;
  play = &(((t_all_data *) tmp)->run)->play;

  if (play->is_play == TRUE)
    {
      ///Frame rate (that manage playing speed) change.
      play->frame = 1;
      statusbar_change (tmp, "Play.");
    }
}

/**
 * @brief on_forward_pressed - forward button widget pressed.
 * @param[in] forward button widget
 * @param[in] pointer who contains all parameters
 */
void
on_forward_pressed (GtkButton * button, gpointer tmp)
{
  t_run_status *run = ((t_all_data *) tmp)->run;
  t_play *play = &run->play;

  if (play->is_play == TRUE)
    {
      ///Frame rate (that manage playing speed) change.     
      play->frame = 10;
      statusbar_change (tmp, "forwarding...");
    }
}

/**
 * @brief on_forward_released - forward button widget released.
 * @param[in] forward button widget
 * @param[in] pointer who contains all parameters
 */
void
on_forward_released (GtkButton * button, gpointer tmp)
{
  t_run_status *run = ((t_all_data *) tmp)->run;
  t_play *play = &run->play;

  if (play->is_play == TRUE)
    {
      ///Frame rate (that manage playing speed) change.
      play->frame = 1;
      statusbar_change (tmp, "Play.");
    }
}

/**
 * @brief - on_summary_changed - rate of datablocks per the drawblocks change.
 * @param[in] summary combobox widget that contain draw rate
 * @param[in] pointer who contains all parameters
 */
void
on_summary_changed (GtkWidget * widget, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;

  t_run_status *run = ((t_all_data *) tmp)->run;
  t_result *result = &run->result;

  get_summary_cnt (&app->summary);

  check_draw_area (tmp);
  if (result->read_jiffies != 0)
    {
      clearance_field (tmp);
      draw_view (tmp, EV_STOP);
    }
  statusbar_change (tmp, "summary changed.");
}

/**
 * @brief - on_disp_changed - draw color change
 * @param[in] summary combobox widget that contains draw colors
 * @param[in] pointer who contains all parameters
 */
void
on_disp_changed (GtkWidget * widget, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_run_status *run = ((t_all_data *) tmp)->run;
  t_draw *blks = &app->blks;
  GtkWidget *rmitem = NULL;
  //t_play *play = &run->play;

  ///cloopprofiler.c/446
  get_disp_state (&app->mode);

  /// Color Mode : read time
  if (strcmp (app->mode.s, "read time") == 0)
    {
      run->type = R_TIME;
      rmitem = app->colormenu_item[0];
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (rmitem), TRUE);
    }
  ///Color Mode : read count
  else if (strcmp (app->mode.s, "read count") == 0)
    {
      run->type = R_FREQ;
      rmitem = app->colormenu_item[1];
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (rmitem), TRUE);
    }
  ///Color Mode : read time / read count
  else if (strcmp (app->mode.s, "time/count") == 0)
    {
      run->type = R_TIMEF;
      rmitem = app->colormenu_item[2];
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (rmitem), TRUE);
    }
  ///Color Mode : read count /read time
  else
    {
      run->type = R_FREQT;
      rmitem = app->colormenu_item[3];
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (rmitem), TRUE);
    }

  statusbar_change (tmp, "display mode changed.");
  draw_initalize (blks->summary_cnt, tmp);
  //draw_initalize(app->summary.cnt,tmp);
}

/**
 * @brief on_select_block - when block in the clist choice by user click
 * @param[in] clist widget
 * @param[in] clist row position
 * @param[in] clist column position
 * @param[in] event type
 * @param[in] pointer who contains all parameters
 */
void
on_select_block (GtkWidget * widget,
		 gint row, gint column, GdkEventButton * event, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_draw *blks = &app->blks;

  t_run_status *run = ((t_all_data *) tmp)->run;

  gchar restype = run->restype;
  t_block *block;
  gchar *blkno;
  gint type = 0;

  gint summary_cnt = blks->summary_cnt;

  glong offset = 0;
  gint tmpsize = 0;

  type = run->type;

  ///change run type to "select color"
  if (run->type == R_TIME)
    type = R_TIME_R;
  else if (run->type == R_FREQ)
    type = R_FREQ_R;
  else if (run->type == R_TIMEF)
    type = R_TIMEF_R;
  else if (run->type == R_FREQT)
    type = R_FREQT_R;

  ///Get block's infomation in the clist
  gtk_clist_get_text (GTK_CLIST (widget), row, INFO_READNO, &blkno);
  dbg ("select:%s\n", blkno);

  block = (t_block *) (g_list_nth (run->blk_list, atoi (blkno)))->data;

  ///Draw select block as select color
  if (restype == READ_BLOCKS)
    {
      draw_one_block (blks, block, type, 0, tmp);
      draw_one_frame (blks, block, F_SEL, 0, tmp);
    }
  else if (restype == CLOOP_HEADER)
    {
      offset = block->cloop->offset;

      while (tmpsize < block->cloop->size)
	{
	  draw_one_block (blks, block, type, offset, tmp);
	  draw_one_frame (blks, block, F_SEL, offset, tmp);

	  offset += summary_cnt * SECTOR_SIZE;
	  tmpsize += summary_cnt * SECTOR_SIZE;
	}
    }
  else
    {
      dbg ("restype error.\n");
      exit (1);
    }

  statusbar_change (tmp, "block selected.");
  draw_update (blks);
}

/**
 * @brief on_unselect_block - when block in the clist unselect by user click
 * @param[in] clist widget
 * @param[in] clist row position
 * @param[in] clist column position
 * @param[in] event type
 * @param[in] pointer who contains all parameters
 */
void
on_unselect_block (GtkWidget * widget,
		   gint row,
		   gint column, GdkEventButton * event, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_draw *blks = &app->blks;

  t_run_status *run = ((t_all_data *) tmp)->run;

  gchar restype = run->restype;
  t_block *block;
  gchar *blkno;
  gint type;

  glong offset = 0;
  gint tmpsize = 0;

  gint summary_cnt = blks->summary_cnt;

  type = run->type;

  gtk_clist_get_text (GTK_CLIST (widget), row, INFO_READNO, &blkno);
  dbg ("unselect:%s\n", blkno);

  ///choose block that unselected.
  block = (t_block *) (g_list_nth (run->blk_list, atoi (blkno)))->data;

  //draw_one_frame(blks,block,F_GRND,tmp);
  //draw_one_block(blks,block,tmp);

  if (restype == READ_BLOCKS)
    {
      draw_one_block (blks, block, type, 0, tmp);
      draw_one_frame (blks, block, F_GRND, 0, tmp);
    }
  else if (restype == CLOOP_HEADER)
    {
      offset = block->cloop->offset;

      while (tmpsize < block->cloop->size)
	{
	  draw_one_block (blks, block, type, offset, tmp);
	  draw_one_frame (blks, block, F_GRND, offset, tmp);

	  offset += summary_cnt * SECTOR_SIZE;
	  tmpsize += summary_cnt * SECTOR_SIZE;
	}
    }
  else
    {
      dbg ("restype error.\n");
      exit (1);
    }

  draw_update (blks);
}

/**
 * @brief clist_compere - Clist Compere Function (used by "on_clist_clicked")
 * @param[in] List of Objective
 * @param[in] parameter as GtkCListRow
 * @param[in] parameter as GtkCListRow
 * @param[out] ptr1<ptr2 : -1 ptr1>ptr2 : 1 ptr1=ptr2 : 0
 */
gint
clist_compare (GtkCList * clist, gconstpointer ptr1, gconstpointer ptr2)
{
  ///Type Conversion 
  const GtkCListRow *row1 = (const GtkCListRow *) ptr1;
  const GtkCListRow *row2 = (const GtkCListRow *) ptr2;
  gchar *text1 = NULL;
  gchar *text2 = NULL;
  gfloat f1, f2;

  ///Read Cell Data
  text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
  text2 = GTK_CELL_TEXT (row2->cell[clist->sort_column])->text;

  f1 = atof (text1);
  f2 = atof (text2);

  return ((f1 < f2) ? -1 : (f1 > f2) ? 1 : 0);
}

/**
 * @brief on_clist_clicked - function that clist tag clicked
 * @param[in] Clist widget
 * @param[in] clist column location
 * @param[in] pointer who contains all parameters
 */
void
on_clist_clicked (GtkCList * clist, gint column, gpointer tmp)
{
  dbg ("column -> %d.\n", column);

  gtk_clist_set_sort_column (GTK_CLIST (clist), column);
  gtk_clist_set_compare_func (GTK_CLIST (clist),
			      (GtkCListCompareFunc) clist_compare);
  gtk_clist_sort (GTK_CLIST (clist));

  statusbar_change (tmp, "list sorted.");
}

/**
 * @brief set_timescale - set timescale value
 * @param[in] pointer that contains all parameters.
 * @param[in] value that is going to set for timescale as parcentage
 *
 */
void
set_timescale (gpointer tmp, gfloat parcent)
{
  t_run_status *run = ((t_all_data *) tmp)->run;

  t_play *play = &run->play;
  t_timer *timer = &run->timer;
  t_result *result = &run->result;

  t_block *tmp_block;

  gint i;
  gdouble ctimer;

  if (play->is_play == TRUE)
    {
      if (parcent == 100)
	parcent = 99.9;

      run->p_timer = result->total_time * parcent / 100;

      i = 0;
      ctimer = 0;
      while (ctimer < run->p_timer)
	{
	  run->tmp_list = g_list_nth (run->blk_list, i++);
	  tmp_block = (t_block *) run->tmp_list->data;
	  ctimer += tmp_block->draw_time;
	  if (run->tmp_list->next == NULL)
	    break;
	}
      run->b_loc = i;
      run->p_timer = ctimer;
    }

  dbg ("run->p_timer:%lf\n", run->p_timer);
  timer->t_count = run->p_timer * 100;

}


gboolean
timescale_change_value (GtkRange * range,
			GtkScrollType arg1, gdouble arg2, gpointer tmp)
{

  t_app_status *app = ((t_all_data *) tmp)->app;
  t_scale *scale = &app->scale;

  gdouble parcent;

  if (scale->adjust->upper == 100)
    {

      if (arg2 <= 0)
	parcent = 0;
      else if (arg2 >= 100)
	parcent = 100;
      else
	parcent = arg2;

      dbg ("parcent=%0.2lf\n", parcent);

      gtk_adjustment_set_value (GTK_ADJUSTMENT (scale->adjust), arg2);

      set_timescale (tmp, parcent);
    }

  statusbar_change (tmp, "timesclale change.");

  return FALSE;
}

/**
 * @brief timescale_pressed - event on timescale pressed
 * @param[in]
 * @param[in]
 * @param[in]
 * @param[out]
 */
gboolean
timescale_pressed (GtkWidget * widget, GdkEventButton * event, gpointer tmp)
{
  t_run_status *run = ((t_all_data *) tmp)->run;

  t_play *play = &run->play;
  //t_timer *timer = &run->timer;

  dbg ("event:%d\n", event->button);

  if (event->button != 1)
    return FALSE;
  else if (event->button == 1 && event->type == GDK_BUTTON_PRESS)
    {
      {
	play->is_pause = TRUE;
	play->frame = 0;
	play->r_draw = TRUE;
	return FALSE;
      }
    }
  return FALSE;
}

/**
 * @brief timescale_released - event on timescale released
 * @param[in]
 * @param[in]
 * @param[in]
 * @param[out]
 */
gboolean
timescale_released (GtkWidget * widget, GdkEventButton * event, gpointer tmp)
{
  t_run_status *run = ((t_all_data *) tmp)->run;
  t_play *play = &run->play;

  if (event->button != 1)
    return FALSE;
  else if (event->button == 1 && event->type == GDK_BUTTON_RELEASE)
    {
      play->is_play = TRUE;
      play->is_pause = FALSE;
      play->frame = 1;
      draw_timer (tmp);
      return FALSE;
    }
  return FALSE;
}
