#!/bin/sh
set -u

wd=`pwd`
software=`basename $wd`

targets="cp932 cp51932 eucjp-ms";
if [ $# -ne 0 ]; then
   targets=$@;
fi

for codeset in $targets;
do
    case "$codeset" in
    cp932)
        my_codeset=cp932
        ;;
    cp51932)
        my_codeset=cp51932
        ;;
    eucjp-ms)
        my_codeset=eucjpms
        ;;
    esac

    ../make_maptbl.sh $software $my_codeset
    ../compare.sh $software $codeset $my_codeset
done
