#!/usr/bin/perl

use strict;
use utf8;
use encoding 'utf8';

print <<END;
SET NAMES utf8;
CREATE TABLE charlist (code varchar(16), ch varchar(8));
END

foreach my $u (0x0000..0x007F) {
    printf("INSERT INTO charlist (code, ch) VALUES('<U00%02X>', _utf8 0x%02X);\n", $u, $u);
}

foreach my $u (0x0080..0xFFFF) {
    printf("INSERT INTO charlist (code, ch) VALUES('<U%04X>', '%s');\n", $u, chr($u));
}
