#!/usr/bin/perl

use Encode qw(decode);

while (<>) {
    chomp;
    s/\\\\/\\/g;
    if (/^(\\x[0-7][0-9A-F])\t(.+)$/) {
	printf("%s <U%04X>\n", $1, hex($2));
    } elsif (/^((?:\\x[0-9A-F][0-9A-F])+)\t(.+)$/) {
	$utf8 = decode("UTF-8", $2);
	print "$1 ";
	for ($i = 0; $i < length($utf8); $i++) {
	    printf("<U%04X>", ord(substr($utf8, $i, 1)));
	}
	print "\n";
    } elsif (/^(<U00[0-7][0-9A-F]>)\t(.+)$/) {
	printf("%s \\x%02X\n", $1, hex($2));
    } elsif (/^(<U[0-9A-F]{4,4}>)\t(.+)$/) {
	if ($2 =~ /^\?$/) {
	    next;
	}
	if (length($2) == 1) {
	    printf("%s \\x%02X\n", $1, ord($2));
	} elsif (length($2) == 2) {
	    printf("%s \\x%02X\\x%02X\n", $1, ord(substr($2,0,1)),
	                                      ord(substr($2,1,1)));
	} elsif (length($2) == 3) {
	    printf("%s \\x%02X\\x%02X\\x%02X\n", $1, ord(substr($2,0,1)),
	                                             ord(substr($2,1,1)),
	                                             ord(substr($2,2,1)));
	}
    }
}
