<?php
#include 'utf8lib.php';
#include 'ucs4lib.php';

function ucs4ord($c)
{
    return unpack('N*', $c);
}

function ucs4ord_1char($c)
{
    $u = ucs4ord($c);
    return $u[1];
}

function ucs4chr($u)
{
    return pack('N*', $u);
}

function print_ucs2mb_one_char($ucs, $mb)
{
    $mblen = strlen($mb);

    printf("<U%04X> ", $ucs);
    for ($i = 0; $i < $mblen; $i++) {
        printf("\\x%02X", ord($mb[$i]));
    }
    print "\n";
}

function dump_ucs2mb_plane($codeset, $plane)
{
    for ($u = 0; $u < 0x10000; $u++) {
        if ($plane == 0 && $u >= 0xD800 && $u <= 0xDFFF) {
            continue;
        }
        $u = $plane << 16 | $u;
        $ucs = ucs4chr($u);
        $mb = mb_convert_encoding($ucs, $codeset, "UCS-4");
        if ($u == 0x003F || ord($mb[0]) != 0x3F) {
            print_ucs2mb_one_char($u, $mb);
        }
    }
}

function dump_ucs2mb($codeset)
{
    dump_ucs2mb_plane($codeset, 0);
#    dump_ucs2mb_plane($codeset, 2);
}

if ($argc != 2) {
    fputs(STDERR, "Usage: php_mb2ucs.php codeset\n");
    exit(1);
}

dump_ucs2mb($argv[1]);
exit(0);

?>

