#!/usr/bin/perl

use strict;

print <<END;
SET CLIENT_ENCODING TO 'SJIS';
CREATE TABLE charlist (codepoint varchar(16), character varchar(8));
COPY charlist (codepoint, "character") FROM stdin;
END

foreach my $c1 (0x00..0x7F) {
    printf("\\\\x%02X\t\\%o\n", $c1, $c1);
}

foreach my $c1 (0xA1..0xDF) {
    printf("\\\\x%02X\t%c\n", $c1, $c1);
}

foreach my $c1 (0x80..0x9F, 0xE0..0xFC) {
  foreach my $c2 (0x40..0x7E, 0x80..0xFC) {
    printf("\\\\x%02X\\\\x%02X\t%c%c\n", $c1, $c2, $c1, $c2);
  }
}

print "\\.\n";
