#!/usr/bin/perl

use strict;
use utf8;
use encoding 'utf8';

print <<END;
SET CLIENT_ENCODING TO 'UNICODE';
CREATE TABLE charlist (codepoint varchar(16), character varchar(8));
COPY charlist (codepoint, "character") FROM stdin;
END

foreach my $u (0x0000..0x007F) {
    printf("<U00%02X>\t\\%o\n", $u, $u);
}

foreach my $u (0x0080..0xFFFF) {
    if ($u >= 0xD800 && $u <= 0xDFFF) {
	next;
    }
    printf("<U%04X>\t%s\n", $u, chr($u));
}
print "\\.\n";
