#!/usr/bin/perl

use Encode qw(decode);

while (<>) {
  chomp;
  if (/^ (\\x[0-7][0-9A-F]) +\| (.+)$/) {
    printf("%s <U%04X>\n", $1, hex($2));
  } elsif (/^ ((?:\\x[0-9A-F][0-9A-F])+) +\| (.+)$/) {
    printf("%s <U%04X>\n", $1, ord(decode("UTF-8", $2)));
  } elsif (/^ (<U00[0-7][0-9A-F]>) +\| (.+)$/) {
    printf("%s \\x%02X\n", $1, hex($2));
  } elsif (/^ (<U[0-9A-F]{4,4}>) +\| (.+)$/) {
    if (length($2) == 1) {
      printf("%s \\x%02X\n", $1, ord($2));
    } elsif (length($2) == 2) {
      printf("%s \\x%02X\\x%02X\n", $1, ord(substr($2,0,1)),
                                        ord(substr($2,1,1)));
    } elsif (length($2) == 3) {
      printf("%s \\x%02X\\x%02X\\x%02X\n", $1, ord(substr($2,0,1)),
                                               ord(substr($2,1,1)),
                                               ord(substr($2,2,1)));
    }
  }
}
